/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.ObservatoryConnector;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.run.FlutterPositionMapper;
import io.flutter.run.bazelTest.BazelTestConfig;
import io.flutter.run.bazelTest.BazelTestDebugProcess;
import io.flutter.run.bazelTest.BazelTestLaunchState;
import io.flutter.run.common.CommonTestConfigUtils;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.JsonUtils;
import io.flutter.utils.StdoutJsonParser;
import io.flutter.utils.UrlUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelTestRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance(BazelTestRunner.class);

    @NotNull
    public String getRunnerId() {
        return "FlutterBazelTestRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            BazelTestRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            BazelTestRunner.$$$reportNull$$$0(1);
        }
        return ("Run".equals(executorId) || "Debug".equals(executorId)) && profile instanceof BazelTestConfig;
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            BazelTestRunner.$$$reportNull$$$0(2);
        }
        if (env == null) {
            BazelTestRunner.$$$reportNull$$$0(3);
        }
        return this.runInDebugger((BazelTestLaunchState)state, env);
    }

    protected RunContentDescriptor runInDebugger(@NotNull BazelTestLaunchState launcher, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (launcher == null) {
            BazelTestRunner.$$$reportNull$$$0(4);
        }
        if (env == null) {
            BazelTestRunner.$$$reportNull$$$0(5);
        }
        final ExecutionResult executionResult = launcher.execute(env.getExecutor(), (ProgramRunner)this);
        final Connector connector = new Connector(executionResult.getProcessHandler(), env.getProject());
        final DartUrlResolver resolver = DartUrlResolver.getInstance((Project)env.getProject(), (VirtualFile)launcher.getTestFile());
        FlutterPositionMapper.Analyzer analyzer = FlutterPositionMapper.Analyzer.create(env.getProject(), launcher.getTestFile());
        final BazelPositionMapper mapper = new BazelPositionMapper(env.getProject(), env.getProject().getBaseDir(), resolver, analyzer, connector);
        XDebuggerManager manager = XDebuggerManager.getInstance((Project)env.getProject());
        XDebugSession session = manager.startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new BazelTestDebugProcess(env, session, executionResult, resolver, connector, mapper);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "io/flutter/run/bazelTest/BazelTestRunner$1", "start"));
            }
        });
        return session.getRunContentDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/bazelTest/BazelTestRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runInDebugger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Connector
    implements ObservatoryConnector {
        private final StdoutJsonParser stdoutParser = new StdoutJsonParser();
        private final ProcessListener listener;
        private String observatoryUri;
        private String runfilesDir;
        private String workspaceDirName;
        private static final String STARTED_PROCESS = "test.startedProcess";
        private static final String OBSERVATORY_URI_KEY = "vmServiceUri";
        private static final String RUNFILES_DIR_KEY = "runfilesDir";
        private static final String WORKSPACE_DIR_NAME_KEY = "workspaceDirName";

        public Connector(final ProcessHandler handler, Project project) {
            Workspace workspace = WorkspaceCache.getInstance(project).get();
            assert (workspace != null);
            final String configWarningPrefix = workspace.getConfigWarningPrefix();
            this.listener = new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    String text = event.getText();
                    if (configWarningPrefix != null && text.startsWith(configWarningPrefix)) {
                        FlutterMessages.showWarning("Configuration warning", UrlUtils.generateHtmlFragmentWithHrefTags(text.substring(configWarningPrefix.length())), null);
                    }
                    if (!outputType.equals((Object)ProcessOutputTypes.STDOUT)) {
                        return;
                    }
                    if (FlutterSettings.getInstance().isVerboseLogging()) {
                        LOG.info("[<-- " + text.trim() + "]");
                    }
                    stdoutParser.appendOutput(text);
                    for (String line : stdoutParser.getAvailableLines()) {
                        if (!line.startsWith("[{")) continue;
                        line = line.trim();
                        String json = line.substring(1, line.length() - 1);
                        this.dispatchJson(json);
                    }
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    handler.removeProcessListener(listener);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "io/flutter/run/bazelTest/BazelTestRunner$Connector$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            handler.addProcessListener(this.listener);
        }

        @Override
        @Nullable
        public String getWebSocketUrl() {
            if (this.observatoryUri == null || !this.observatoryUri.startsWith("http:")) {
                return null;
            }
            return CommonTestConfigUtils.convertHttpServiceProtocolToWs(this.observatoryUri);
        }

        @Override
        @Nullable
        public String getBrowserUrl() {
            return this.observatoryUri;
        }

        @Nullable
        public String getRunfilesDir() {
            return this.runfilesDir;
        }

        @Nullable
        public String getWorkspaceDirName() {
            return this.workspaceDirName;
        }

        @Override
        @Nullable
        public String getRemoteBaseUrl() {
            return null;
        }

        @Override
        public void onDebuggerPaused(@NotNull Runnable resume) {
            if (resume == null) {
                Connector.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void onDebuggerResumed() {
        }

        private void dispatchJson(String json) {
            JsonObject obj;
            try {
                JsonElement elem = JsonUtils.parseString(json);
                obj = elem.getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                FlutterUtils.warn(LOG, "Unable to parse JSON from Flutter test", e);
                return;
            }
            JsonPrimitive primId = obj.getAsJsonPrimitive("id");
            if (primId != null) {
                LOG.info("Ignored JSON from Flutter test: " + json);
                return;
            }
            JsonPrimitive primEvent = obj.getAsJsonPrimitive("event");
            if (primEvent == null) {
                FlutterUtils.warn(LOG, "Missing event field in JSON from Flutter test: " + String.valueOf(obj));
                return;
            }
            String eventName = primEvent.getAsString();
            if (eventName == null) {
                FlutterUtils.warn(LOG, "Unexpected event field in JSON from Flutter test: " + String.valueOf(obj));
                return;
            }
            JsonObject params = obj.getAsJsonObject("params");
            if (params == null) {
                FlutterUtils.warn(LOG, "Missing parameters in event from Flutter test: " + String.valueOf(obj));
                return;
            }
            if (eventName.equals(STARTED_PROCESS)) {
                JsonPrimitive primWorkspaceDirName;
                JsonPrimitive primRunfilesDir;
                JsonPrimitive primUri = params.getAsJsonPrimitive(OBSERVATORY_URI_KEY);
                if (primUri != null) {
                    this.observatoryUri = primUri.getAsString();
                }
                if ((primRunfilesDir = params.getAsJsonPrimitive(RUNFILES_DIR_KEY)) != null) {
                    this.runfilesDir = primRunfilesDir.getAsString();
                }
                if ((primWorkspaceDirName = params.getAsJsonPrimitive(WORKSPACE_DIR_NAME_KEY)) != null) {
                    this.workspaceDirName = primWorkspaceDirName.getAsString();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resume", "io/flutter/run/bazelTest/BazelTestRunner$Connector", "onDebuggerPaused"));
        }
    }

    private static final class BazelPositionMapper
    extends FlutterPositionMapper {
        @NotNull
        final Connector connector;

        public BazelPositionMapper(@NotNull Project project, @NotNull VirtualFile sourceRoot, @NotNull DartUrlResolver resolver, @Nullable FlutterPositionMapper.Analyzer analyzer, @NotNull Connector connector) {
            if (project == null) {
                BazelPositionMapper.$$$reportNull$$$0(0);
            }
            if (sourceRoot == null) {
                BazelPositionMapper.$$$reportNull$$$0(1);
            }
            if (resolver == null) {
                BazelPositionMapper.$$$reportNull$$$0(2);
            }
            if (connector == null) {
                BazelPositionMapper.$$$reportNull$$$0(3);
            }
            super(project, sourceRoot, resolver, analyzer);
            this.connector = connector;
        }

        @Override
        @Nullable
        protected VirtualFile findLocalFile(@NotNull String uri) {
            String workspaceDirName;
            if (uri == null) {
                BazelPositionMapper.$$$reportNull$$$0(4);
            }
            if (StringUtils.isEmpty((CharSequence)(workspaceDirName = this.connector.getWorkspaceDirName())) || !uri.startsWith(workspaceDirName + ":/")) {
                return super.findLocalFile(uri);
            }
            String pathFromWorkspace = uri.substring(workspaceDirName.length() + 1);
            return (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
                for (Module module : DartSdkLibUtil.getModulesWithDartSdkEnabled((Project)this.getProject())) {
                    for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                        String includedRootPath;
                        int workspaceOffset;
                        VirtualFile includedRoot = contentEntry.getFile();
                        if (includedRoot == null || (workspaceOffset = (includedRootPath = includedRoot.getPath()).indexOf(workspaceDirName)) == -1) continue;
                        String pathToWorkspace = includedRootPath.substring(0, workspaceOffset + workspaceDirName.length());
                        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(pathToWorkspace + pathFromWorkspace);
                        if (virtualFile == null) continue;
                        return virtualFile;
                    }
                }
                return super.findLocalFile(uri);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoot";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connector";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/run/bazelTest/BazelTestRunner$BazelPositionMapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findLocalFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

