/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.common;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import io.flutter.dart.DartSyntax;
import io.flutter.editor.ActiveEditorsOutlineService;
import io.flutter.run.common.TestType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonTestConfigUtils {
    private final Map<String, OutlineCache> cache = new HashMap<String, OutlineCache>();
    private static final Map<String, LineMarkerUpdatingListener> listenerCache = new HashMap<String, LineMarkerUpdatingListener>();

    public static String convertHttpServiceProtocolToWs(String url) {
        return StringUtil.trimTrailing((String)url.replaceFirst("http:", "ws:"), (char)'/') + "/ws";
    }

    public void refreshOutline(@NotNull PsiElement element) {
        if (element == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(0);
        }
        this.getTestsFromOutline(element.getContainingFile());
    }

    public TestType asTestCall(@NotNull PsiElement element) {
        TestType namedTestCall;
        if (element == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(1);
        }
        if ((namedTestCall = this.findNamedTestCall(element)) != null) {
            return namedTestCall;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCachedInfo(String path) {
        CommonTestConfigUtils commonTestConfigUtils = this;
        synchronized (commonTestConfigUtils) {
            this.cache.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Map<Integer, TestType> getTestsFromOutline(@NotNull PsiFile file) {
        Project project;
        ActiveEditorsOutlineService outlineService;
        if (file == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(2);
        }
        if ((outlineService = this.getActiveEditorsOutlineService(project = file.getProject())) == null) {
            return new HashMap<Integer, TestType>();
        }
        FlutterOutline outline = outlineService.getIfUpdated(file);
        String path = file.getVirtualFile().getPath();
        CommonTestConfigUtils commonTestConfigUtils = this;
        // MONITORENTER : commonTestConfigUtils
        OutlineCache entry = this.cache.get(path);
        boolean outlineOutdated = this.cache.containsKey(path) && outline != entry.outline;
        // MONITOREXIT : commonTestConfigUtils
        if (outline != null && !outlineOutdated) {
            commonTestConfigUtils = this;
            // MONITORENTER : commonTestConfigUtils
            entry = new OutlineCache(outline, file);
            this.cache.put(path, entry);
            Map<Integer, TestType> map = entry.callToTestType;
            // MONITOREXIT : commonTestConfigUtils
            if (map != null) return map;
            CommonTestConfigUtils.$$$reportNull$$$0(3);
            return map;
        }
        this.clearCachedInfo(path);
        LineMarkerUpdatingListener listener = this.getListenerForFile(file);
        if (listener == null) return new HashMap<Integer, TestType>();
        outlineService.addListener(listener);
        return new HashMap<Integer, TestType>();
    }

    @Nullable
    protected TestType findNamedTestCall(@NotNull PsiElement element) {
        if (element == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(4);
        }
        if (element instanceof DartCallExpression) {
            DartCallExpression call = (DartCallExpression)element;
            return this.getTestsFromOutline(element.getContainingFile()).get(call.getTextOffset());
        }
        return null;
    }

    @Nullable
    public String findTestName(@Nullable PsiElement elt) {
        if (elt == null) {
            return null;
        }
        DartCallExpression call = this.findEnclosingTestCall(elt, this.getTestsFromOutline(elt.getContainingFile()));
        if (call == null) {
            return null;
        }
        DartStringLiteralExpression lit = DartSyntax.getArgument(call, 0, DartStringLiteralExpression.class);
        if (lit == null) {
            return null;
        }
        String name = DartSyntax.unquote(lit);
        if (name == null) {
            return null;
        }
        return StringEscapeUtils.unescapeJava((String)name);
    }

    @Nullable
    private DartCallExpression findEnclosingTestCall(@NotNull PsiElement element, @NotNull Map<Integer, TestType> callToTestType) {
        if (element == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(5);
        }
        if (callToTestType == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(6);
        }
        while (element != null) {
            if (element instanceof DartCallExpression) {
                DartCallExpression call = (DartCallExpression)element;
                if (callToTestType.containsKey(call.getTextOffset())) {
                    return call;
                }
                element = element.getParent();
            }
            element = DartSyntax.findClosestEnclosingFunctionCall(element);
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    protected ActiveEditorsOutlineService getActiveEditorsOutlineService(@NotNull Project project) {
        if (project == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(7);
        }
        return ActiveEditorsOutlineService.getInstance(project);
    }

    private LineMarkerUpdatingListener getListenerForFile(@NotNull PsiFile file) {
        if (file == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(8);
        }
        String path = file.getVirtualFile().getCanonicalPath();
        ActiveEditorsOutlineService service = this.getActiveEditorsOutlineService(file.getProject());
        if (!listenerCache.containsKey(path) && service != null) {
            listenerCache.put(path, new LineMarkerUpdatingListener(this, file.getProject(), service));
            Disposer.register((Disposable)file.getProject(), () -> listenerCache.remove(path));
        }
        return listenerCache.get(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/common/CommonTestConfigUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callToTestType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/common/CommonTestConfigUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsFromOutline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refreshOutline";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "asTestCall";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestsFromOutline";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNamedTestCall";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingTestCall";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActiveEditorsOutlineService";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getListenerForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class OutlineCache {
        final Map<Integer, TestType> callToTestType = new HashMap<Integer, TestType>();
        final FlutterOutline outline;

        private OutlineCache(FlutterOutline outline, PsiFile file) {
            this.outline = outline;
            this.populateTestTypeMap(outline, file);
        }

        private void populateTestTypeMap(@NotNull FlutterOutline outline, @NotNull PsiFile file) {
            if (outline == null) {
                OutlineCache.$$$reportNull$$$0(0);
            }
            if (file == null) {
                OutlineCache.$$$reportNull$$$0(1);
            }
            if (outline.getDartElement() != null) {
                switch (outline.getDartElement().getKind()) {
                    case "UNIT_TEST_GROUP": {
                        PsiElement element = file.findElementAt(outline.getOffset());
                        DartCallExpression enclosingCall = DartSyntax.findClosestEnclosingFunctionCall(element);
                        if (enclosingCall == null) break;
                        this.callToTestType.put(enclosingCall.getTextOffset(), TestType.GROUP);
                        break;
                    }
                    case "UNIT_TEST_TEST": {
                        PsiElement element = file.findElementAt(outline.getOffset());
                        DartCallExpression enclosingCall = DartSyntax.findClosestEnclosingFunctionCall(element);
                        if (enclosingCall == null) break;
                        this.callToTestType.put(enclosingCall.getTextOffset(), TestType.SINGLE);
                        break;
                    }
                }
            }
            if (outline.getChildren() != null) {
                for (FlutterOutline child : outline.getChildren()) {
                    this.populateTestTypeMap(child, file);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outline";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "io/flutter/run/common/CommonTestConfigUtils$OutlineCache";
            objectArray[2] = "populateTestTypeMap";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LineMarkerUpdatingListener
    implements ActiveEditorsOutlineService.Listener {
        @NotNull
        final CommonTestConfigUtils commonTestConfigUtils;
        @NotNull
        final Project project;
        @NotNull
        final ActiveEditorsOutlineService service;

        private LineMarkerUpdatingListener(@NotNull CommonTestConfigUtils commonTestConfigUtils, @NotNull Project project, @NotNull ActiveEditorsOutlineService service) {
            if (commonTestConfigUtils == null) {
                LineMarkerUpdatingListener.$$$reportNull$$$0(0);
            }
            if (project == null) {
                LineMarkerUpdatingListener.$$$reportNull$$$0(1);
            }
            if (service == null) {
                LineMarkerUpdatingListener.$$$reportNull$$$0(2);
            }
            this.commonTestConfigUtils = commonTestConfigUtils;
            this.project = project;
            this.service = service;
        }

        @Override
        public void onOutlineChanged(@NotNull String filePath, @Nullable FlutterOutline outline) {
            if (filePath == null) {
                LineMarkerUpdatingListener.$$$reportNull$$$0(3);
            }
            this.commonTestConfigUtils.clearCachedInfo(filePath);
            this.forceFileAnnotation();
            this.service.removeListener(this);
        }

        private void forceFileAnnotation() {
            ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)this.project).restart(), ModalityState.NON_MODAL, this.project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commonTestConfigUtils";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/run/common/CommonTestConfigUtils$LineMarkerUpdatingListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onOutlineChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

