/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.common;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import org.jetbrains.annotations.NotNull;

public enum RunMode {
    DEBUG("Debug", true),
    RUN("Run", true),
    COVERAGE("Coverage", false),
    PROFILE("PROFILE", false);

    private final String myModeString;
    private final boolean mySupportsReload;

    private RunMode(String modeString, boolean supportsReload) {
        this.myModeString = modeString;
        this.mySupportsReload = supportsReload;
    }

    public String mode() {
        return this.myModeString;
    }

    public boolean supportsReload() {
        return this.mySupportsReload;
    }

    public boolean isProfiling() {
        return this == PROFILE;
    }

    @NotNull
    public static RunMode fromEnv(@NotNull ExecutionEnvironment env) throws ExecutionException {
        String mode;
        if (env == null) {
            RunMode.$$$reportNull$$$0(0);
        }
        if ("Run".equals(mode = env.getExecutor().getId())) {
            RunMode runMode = RUN;
            if (runMode == null) {
                RunMode.$$$reportNull$$$0(1);
            }
            return runMode;
        }
        if ("Debug".equals(mode)) {
            RunMode runMode = DEBUG;
            if (runMode == null) {
                RunMode.$$$reportNull$$$0(2);
            }
            return runMode;
        }
        if (RunMode.COVERAGE.myModeString.equals(mode)) {
            RunMode runMode = COVERAGE;
            if (runMode == null) {
                RunMode.$$$reportNull$$$0(3);
            }
            return runMode;
        }
        if ("Android Profiler".equals(mode)) {
            RunMode runMode = PROFILE;
            if (runMode == null) {
                RunMode.$$$reportNull$$$0(4);
            }
            return runMode;
        }
        throw new ExecutionException("unsupported run mode: " + mode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/common/RunMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/common/RunMode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromEnv";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

