/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.common;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.Function;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartId;
import io.flutter.run.common.CommonTestConfigUtils;
import io.flutter.run.common.TestType;
import io.flutter.run.test.TestConfigUtils;
import java.util.Date;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestLineMarkerContributor
extends RunLineMarkerContributor {
    private static final int SCANNED_TEST_RESULT_LIMIT = 1024;
    @NotNull
    private final CommonTestConfigUtils testConfigUtils;

    protected TestLineMarkerContributor(@NotNull CommonTestConfigUtils testConfigUtils) {
        if (testConfigUtils == null) {
            TestLineMarkerContributor.$$$reportNull$$$0(0);
        }
        this.testConfigUtils = testConfigUtils;
    }

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        DartId dartId;
        if (element == null) {
            TestLineMarkerContributor.$$$reportNull$$$0(1);
        }
        if (element instanceof LeafElement && element.getParent() instanceof DartId && (dartId = (DartId)element.getParent()).getParent() != null) {
            if (dartId.getParent().getParent() instanceof DartCallExpression) {
                DartCallExpression dartCallExpression = (DartCallExpression)dartId.getParent().getParent();
                TestType testCall = this.testConfigUtils.asTestCall((PsiElement)dartCallExpression);
                if (testCall != null) {
                    Icon icon = TestLineMarkerContributor.getTestStateIcon(element, testCall.getIcon());
                    Function tooltipProvider = psiElement -> testCall.getTooltip((PsiElement)psiElement, this.testConfigUtils);
                    return new RunLineMarkerContributor.Info(icon, tooltipProvider, ExecutorAction.getActions());
                }
            } else if (dartId.getParent().getParent() instanceof DartFunctionDeclarationWithBodyOrNative) {
                if (this.testConfigUtils instanceof TestConfigUtils) {
                    return null;
                }
                if ("main".equals(dartId.getText())) {
                    this.testConfigUtils.refreshOutline(element);
                    TestType testCall = TestType.MAIN;
                    Icon icon = TestLineMarkerContributor.getTestStateIcon(element, testCall.getIcon());
                    Function tooltipProvider = psiElement -> testCall.getTooltip((PsiElement)psiElement, this.testConfigUtils);
                    return new RunLineMarkerContributor.Info(icon, tooltipProvider, ExecutorAction.getActions());
                }
            }
        }
        return null;
    }

    @NotNull
    private static Icon getTestStateIcon(@NotNull PsiElement element, @NotNull Icon defaultIcon) {
        Document document;
        PsiFile containingFile;
        if (element == null) {
            TestLineMarkerContributor.$$$reportNull$$$0(2);
        }
        if (defaultIcon == null) {
            TestLineMarkerContributor.$$$reportNull$$$0(3);
        }
        try {
            containingFile = element.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            containingFile = null;
        }
        Project project = element.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document document2 = document = containingFile == null ? null : psiDocumentManager.getDocument(containingFile);
        if (document != null) {
            Map tests;
            int textOffset = element.getTextOffset();
            int lineNumber = document.getLineNumber(textOffset);
            String path = FileUtil.toSystemIndependentName((String)containingFile.getVirtualFile().getPath());
            String testLocationPrefix = "dart_location://" + path + "," + lineNumber;
            TestStateStorage storage = TestStateStorage.getInstance((Project)project);
            if (storage != null && (tests = storage.getRecentTests(1024, TestLineMarkerContributor.getSinceDate())) != null) {
                for (Map.Entry entry : tests.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(testLocationPrefix)) continue;
                    TestStateStorage.Record state = (TestStateStorage.Record)entry.getValue();
                    TestStateInfo.Magnitude magnitude = TestIconMapper.getMagnitude((int)state.magnitude);
                    if (magnitude == null) continue;
                    switch (magnitude) {
                        case IGNORED_INDEX: {
                            Icon icon = AllIcons.RunConfigurations.TestState.Yellow2;
                            if (icon == null) {
                                TestLineMarkerContributor.$$$reportNull$$$0(4);
                            }
                            return icon;
                        }
                        case ERROR_INDEX: 
                        case FAILED_INDEX: {
                            Icon icon = AllIcons.RunConfigurations.TestState.Red2;
                            if (icon == null) {
                                TestLineMarkerContributor.$$$reportNull$$$0(5);
                            }
                            return icon;
                        }
                        case PASSED_INDEX: 
                        case COMPLETE_INDEX: {
                            Icon icon = AllIcons.RunConfigurations.TestState.Green2;
                            if (icon == null) {
                                TestLineMarkerContributor.$$$reportNull$$$0(6);
                            }
                            return icon;
                        }
                    }
                }
            }
        }
        Icon icon = defaultIcon;
        if (icon == null) {
            TestLineMarkerContributor.$$$reportNull$$$0(7);
        }
        return icon;
    }

    private static Date getSinceDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConfigUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/common/TestLineMarkerContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/common/TestLineMarkerContributor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestStateIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestStateIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

