/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterBundle;
import io.flutter.run.test.TestConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterCoverageProgramRunner
extends GenericProgramRunner<RunnerSettings> {
    private static final Logger LOG = Logger.getInstance((String)FlutterCoverageProgramRunner.class.getName());
    private static final String ID = "FlutterCoverageProgramRunner";
    private ProcessHandler handler;
    private ProcessAdapter listener;

    @NotNull
    @NonNls
    public String getRunnerId() {
        return ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            FlutterCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            FlutterCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        return executorId.equals("Coverage") && profile instanceof TestConfig;
    }

    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        if (settingsProvider == null) {
            FlutterCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return new CoverageRunnerData();
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunContentDescriptor result;
        if (state == null) {
            FlutterCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            FlutterCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        if ((result = DefaultProgramRunnerKt.executeState((RunProfileState)state, (ExecutionEnvironment)env, (ProgramRunner)this)) == null) {
            return null;
        }
        this.handler = result.getProcessHandler();
        if (this.handler != null) {
            this.listener = new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> FlutterCoverageProgramRunner.this.processCoverage(env));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/run/coverage/FlutterCoverageProgramRunner$1", "processTerminated"));
                }
            };
            this.handler.addProcessListener((ProcessListener)this.listener);
        }
        return result;
    }

    private void processCoverage(ExecutionEnvironment env) {
        if (!(env.getRunProfile() instanceof TestConfig)) {
            return;
        }
        TestConfig runConfig = (TestConfig)env.getRunProfile();
        CoverageEnabledConfiguration configuration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfig);
        if (configuration.getCoverageFilePath() == null) {
            return;
        }
        Path path = Paths.get(configuration.getCoverageFilePath(), new String[0]);
        Path cov = path.getParent();
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{LocalFileSystem.getInstance().findFileByPath(cov.getParent().toString())});
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{LocalFileSystem.getInstance().findFileByPath(cov.toString())});
        if (Files.exists(path, new LinkOption[0])) {
            @Nullable RunnerSettings settings = env.getRunnerSettings();
            if (settings != null) {
                CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage((RunConfigurationBase)runConfig, settings);
                this.handler.removeProcessListener((ProcessListener)this.listener);
                this.handler = null;
                this.listener = null;
            }
        } else {
            LOG.error(FlutterBundle.message("coverage.path.not.found", path));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/coverage/FlutterCoverageProgramRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurationData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

