/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.coverage.data.ProjectData;
import io.flutter.FlutterBundle;
import io.flutter.run.coverage.FlutterCoverageEngine;
import io.flutter.run.coverage.FlutterCoverageSuite;
import io.flutter.run.coverage.LcovInfo;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterCoverageRunner
extends CoverageRunner {
    private static final String ID = "FlutterCoverageRunner";
    private static final Logger LOG = Logger.getInstance((String)FlutterCoverageRunner.class.getName());

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        if (sessionDataFile == null) {
            FlutterCoverageRunner.$$$reportNull$$$0(0);
        }
        if (!(baseCoverageSuite instanceof FlutterCoverageSuite)) {
            return null;
        }
        return FlutterCoverageRunner.doLoadCoverageData(sessionDataFile, (FlutterCoverageSuite)baseCoverageSuite);
    }

    @Nullable
    private static ProjectData doLoadCoverageData(@NotNull File sessionDataFile, @NotNull FlutterCoverageSuite coverageSuite) {
        if (sessionDataFile == null) {
            FlutterCoverageRunner.$$$reportNull$$$0(1);
        }
        if (coverageSuite == null) {
            FlutterCoverageRunner.$$$reportNull$$$0(2);
        }
        ProjectData projectData = new ProjectData();
        try {
            LcovInfo.readInto(projectData, sessionDataFile);
        }
        catch (IOException ex) {
            LOG.warn(FlutterBundle.message("coverage.data.not.read", sessionDataFile.getAbsolutePath()));
            return null;
        }
        return projectData;
    }

    @NotNull
    public String getPresentableName() {
        return "Flutter";
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDataFileExtension() {
        return "info";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            FlutterCoverageRunner.$$$reportNull$$$0(3);
        }
        return engine instanceof FlutterCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/coverage/FlutterCoverageRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadCoverageData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doLoadCoverageData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsCoverageEngine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

