/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.coverage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class LcovInfo {
    private static final Logger LOG = Logger.getInstance((String)LcovInfo.class.getName());
    private static final String FILE_LABEL = "SF:";
    private static final String DATA_LABEL = "DA:";
    private static final String END_LABEL = "end_of_record";
    private final Map<String, List<LineCount>> counts = new HashMap<String, List<LineCount>>();
    private Path currentFile = null;
    private List<LineCount> lineCounts = null;
    private final String base;

    private LcovInfo(String base) {
        this.base = base;
    }

    public static void readInto(@NotNull ProjectData data, @NotNull File file) throws IOException {
        String filePath;
        int index;
        if (data == null) {
            LcovInfo.$$$reportNull$$$0(0);
        }
        if (file == null) {
            LcovInfo.$$$reportNull$$$0(1);
        }
        if ((index = (filePath = file.getAbsolutePath()).indexOf("coverage")) < 0) {
            return;
        }
        LcovInfo lcov = new LcovInfo(filePath.substring(0, index));
        try (Stream<String> lines = Files.lines(file.toPath());){
            lines.forEach(lcov::processLine);
        }
        for (String path : lcov.counts.keySet()) {
            List<LineCount> list = lcov.counts.get(path);
            if (list == null || list.isEmpty()) continue;
            ClassData classData = data.getOrCreateClassData(path);
            classData.setSource(LcovInfo.fullPath(path));
            int max = list.get((int)(list.size() - 1)).lineNum + 1;
            LineData[] lines = new LineData[max];
            for (LineCount line : list) {
                LineData lineData = new LineData(line.lineNum, null);
                lineData.setHits(line.execCount);
                lines[line.lineNum] = lineData;
                classData.registerMethodSignature(lineData);
            }
            classData.setLines(lines);
        }
    }

    void processLine(String line) {
        if ((line = line.trim()).startsWith(DATA_LABEL)) {
            assert (this.currentFile != null);
            assert (this.lineCounts != null);
            this.addLineCount(line.substring(DATA_LABEL.length()));
        } else if (line.startsWith(FILE_LABEL)) {
            File file = new File(this.base, line.substring(FILE_LABEL.length()));
            URI normalize = file.toURI().normalize();
            this.currentFile = Paths.get(normalize);
            this.lineCounts = new ArrayList<LineCount>();
        } else if (line.equals(END_LABEL)) {
            this.storeLineCounts();
            this.currentFile = null;
            this.lineCounts = null;
        }
    }

    private void addLineCount(String data) {
        String[] parts = data.split(",");
        assert (parts.length >= 2);
        int lineNum = LcovInfo.safelyParse(parts[0]);
        int execCount = LcovInfo.safelyParse(parts[1]);
        this.lineCounts.add(new LineCount(lineNum, execCount));
    }

    private static int safelyParse(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private void storeLineCounts() {
        String path = LcovInfo.fullPath(this.currentFile.toString());
        this.counts.put(path, this.lineCounts);
    }

    private static String fullPath(String path) {
        String absPath = new File(path).getAbsolutePath();
        if (SystemInfo.isWindows) {
            absPath = absPath.replaceAll("\\\\", "/");
        }
        return absPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "io/flutter/run/coverage/LcovInfo";
        objectArray[2] = "readInto";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LineCount {
        int lineNum;
        int execCount;

        public LineCount(int num, int count) {
            this.lineNum = num;
            this.execCount = count;
        }
    }
}

