/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.jetbrains.lang.dart.ide.runner.DartRelativePathsConsoleFilter;
import io.flutter.FlutterInitializer;
import io.flutter.analytics.Analytics;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.run.daemon.DaemonApi;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.StdoutJsonParser;
import org.jetbrains.annotations.NotNull;

public class DaemonConsoleView
extends ConsoleViewImpl {
    private static final Logger LOG = Logger.getInstance(DaemonConsoleView.class);
    private final Analytics analytics;
    private final StdoutJsonParser stdoutParser;
    private boolean hasPrintedText;

    public static void install(@NotNull CommandLineState launcher, final @NotNull ExecutionEnvironment env, @NotNull VirtualFile workDir) {
        if (launcher == null) {
            DaemonConsoleView.$$$reportNull$$$0(0);
        }
        if (env == null) {
            DaemonConsoleView.$$$reportNull$$$0(1);
        }
        if (workDir == null) {
            DaemonConsoleView.$$$reportNull$$$0(2);
        }
        final GlobalSearchScope searchScope = GlobalSearchScopes.executionScope((Project)env.getProject(), (RunProfile)env.getRunProfile());
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(env.getProject(), searchScope){

            @NotNull
            protected ConsoleView createConsole() {
                return new DaemonConsoleView(env.getProject(), searchScope);
            }
        };
        builder.addFilter((Filter)new DartRelativePathsConsoleFilter(env.getProject(), workDir.getPath()));
        launcher.setConsoleBuilder((TextConsoleBuilder)builder);
    }

    public DaemonConsoleView(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            DaemonConsoleView.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            DaemonConsoleView.$$$reportNull$$$0(4);
        }
        super(project, searchScope, true, false);
        this.analytics = FlutterInitializer.getAnalytics();
        this.stdoutParser = new StdoutJsonParser();
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            DaemonConsoleView.$$$reportNull$$$0(5);
        }
        if (contentType == null) {
            DaemonConsoleView.$$$reportNull$$$0(6);
        }
        if (!FlutterModuleUtils.hasFlutterModule(this.getProject())) {
            return;
        }
        if (FlutterSettings.getInstance().isVerboseLogging()) {
            super.print(text, contentType);
            return;
        }
        if (contentType != ConsoleViewContentType.NORMAL_OUTPUT) {
            this.writeAvailableLines();
            if (WorkspaceCache.getInstance(this.getProject()).isBazel() && contentType.equals(ConsoleViewContentType.ERROR_OUTPUT) && !text.isEmpty()) {
                this.analytics.sendEvent("potential-disconnect", text);
            }
            super.print(text, contentType);
        } else {
            this.stdoutParser.appendOutput(text);
            this.writeAvailableLines();
        }
    }

    private void writeAvailableLines() {
        for (String line : this.stdoutParser.getAvailableLines()) {
            if (DaemonApi.parseAndValidateDaemonEvent(line.trim()) != null) {
                if (!FlutterSettings.getInstance().isVerboseLogging()) continue;
                LOG.info(line.trim());
                continue;
            }
            if (!this.hasPrintedText && line.equals("\n")) continue;
            this.hasPrintedText = true;
            super.print(line, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/daemon/DaemonConsoleView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

