/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.console.FlutterConsoles;
import io.flutter.run.daemon.DaemonApi;
import io.flutter.run.daemon.DaemonEvent;
import io.flutter.run.daemon.DevToolsInstance;
import io.flutter.sdk.FlutterCommand;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.JsonUtils;
import io.flutter.utils.MostlySilentColoredProcessHandler;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class DevToolsService {
    private static final Logger LOG = Logger.getInstance(DevToolsService.class);
    @NotNull
    private final Project project;
    private DaemonApi daemonApi;
    private ProcessHandler process;
    private AtomicReference<CompletableFuture<DevToolsInstance>> devToolsFutureRef;

    @NotNull
    public static DevToolsService getInstance(@NotNull Project project) {
        if (project == null) {
            DevToolsService.$$$reportNull$$$0(0);
        }
        DevToolsService devToolsService = Objects.requireNonNull((DevToolsService)project.getService(DevToolsService.class));
        if (devToolsService == null) {
            DevToolsService.$$$reportNull$$$0(1);
        }
        return devToolsService;
    }

    private DevToolsService(@NotNull Project project) {
        if (project == null) {
            DevToolsService.$$$reportNull$$$0(2);
        }
        this.devToolsFutureRef = new AtomicReference<Object>(null);
        this.project = project;
    }

    public CompletableFuture<DevToolsInstance> getDevToolsInstance() {
        if (this.devToolsFutureRef.compareAndSet(null, new CompletableFuture())) {
            this.startServer();
        }
        if (this.devToolsFutureRef.updateAndGet(future -> {
            if (future.isCompletedExceptionally()) {
                return null;
            }
            return future;
        }) == null) {
            this.devToolsFutureRef.set(new CompletableFuture());
            this.startServer();
        }
        return this.devToolsFutureRef.get();
    }

    public CompletableFuture<DevToolsInstance> getDevToolsInstanceWithForcedRestart() {
        CompletableFuture<DevToolsInstance> futureInstance = this.devToolsFutureRef.updateAndGet(future -> {
            if (future.isCompletedExceptionally() || future.isCancelled()) {
                return null;
            }
            return future;
        });
        if (futureInstance == null) {
            this.devToolsFutureRef.set(new CompletableFuture());
            this.startServer();
        } else if (!futureInstance.isDone()) {
            futureInstance.cancel(true);
            this.devToolsFutureRef.set(new CompletableFuture());
            this.startServer();
        }
        return this.devToolsFutureRef.get();
    }

    private void startServer() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.project);
            boolean dartDevToolsSupported = false;
            DartSdk dartSdk = DartSdk.getDartSdk((Project)this.project);
            if (dartSdk != null) {
                Version version = Version.parseVersion((String)dartSdk.getVersion());
                assert (version != null);
                boolean bl = dartDevToolsSupported = version.compareTo(Integer.valueOf(2), Integer.valueOf(15), Integer.valueOf(0)) >= 0;
            }
            if (dartDevToolsSupported) {
                WorkspaceCache workspaceCache = WorkspaceCache.getInstance(this.project);
                if (workspaceCache.isBazel()) {
                    this.setUpWithDart(DevToolsService.createCommand(workspaceCache.get().getRoot().getPath(), workspaceCache.get().getDevToolsScript(), (ImmutableList<String>)ImmutableList.of((Object)"--machine")));
                } else {
                    this.setUpWithDart(DevToolsService.createCommand(DartSdk.getDartSdk((Project)this.project).getHomePath(), DartSdk.getDartSdk((Project)this.project).getHomePath() + File.separatorChar + "bin" + File.separatorChar + "dart", (ImmutableList<String>)ImmutableList.of((Object)"devtools", (Object)"--machine")));
                }
            } else if (sdk != null && sdk.getVersion().useDaemonForDevTools()) {
                this.setUpWithDaemon();
            } else {
                this.setUpWithPub();
            }
        });
    }

    private void setUpWithDart(GeneralCommandLine command) {
        try {
            this.process = new MostlySilentColoredProcessHandler(command);
            this.process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    String text;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((text = event.getText().trim()).startsWith("{") && text.endsWith("}")) {
                        try {
                            JsonElement element = JsonUtils.parseString(text);
                            JsonObject obj = element.getAsJsonObject();
                            if (JsonUtils.getStringMember(obj, "event").equals("server.started")) {
                                JsonObject params = obj.getAsJsonObject("params");
                                String host = JsonUtils.getStringMember(params, "host");
                                int port = JsonUtils.getIntMember(params, "port");
                                if (port != -1) {
                                    DevToolsService.this.devToolsFutureRef.get().complete(new DevToolsInstance(host, port));
                                } else {
                                    DevToolsService.this.logExceptionAndComplete("DevTools port was invalid");
                                }
                            }
                        }
                        catch (JsonSyntaxException e) {
                            DevToolsService.this.logExceptionAndComplete((Exception)((Object)e));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "io/flutter/run/daemon/DevToolsService$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.process.startNotify();
            ProjectManager.getInstance().addProjectManagerListener(this.project, new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DevToolsService.this.devToolsFutureRef.set(null);
                    DevToolsService.this.process.destroyProcess();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/run/daemon/DevToolsService$2", "projectClosing"));
                }
            });
        }
        catch (com.intellij.execution.ExecutionException e) {
            this.logExceptionAndComplete((Exception)((Object)e));
        }
    }

    private void setUpWithDaemon() {
        try {
            GeneralCommandLine command = DevToolsService.chooseCommand(this.project);
            if (command == null) {
                this.logExceptionAndComplete("Unable to find daemon command for project");
                return;
            }
            this.process = new MostlySilentColoredProcessHandler(command);
            this.daemonApi = new DaemonApi(this.process);
            this.daemonApi.listen(this.process, new DevToolsServiceListener());
            this.daemonApi.devToolsServe().thenAccept(address -> {
                if (!this.project.isOpen()) {
                    return;
                }
                if (address == null) {
                    this.logExceptionAndComplete("DevTools address was null");
                } else {
                    this.devToolsFutureRef.get().complete(new DevToolsInstance(address.host, address.port));
                }
            });
        }
        catch (com.intellij.execution.ExecutionException e) {
            this.logExceptionAndComplete((Exception)((Object)e));
        }
        ProjectManager.getInstance().addProjectManagerListener(this.project, new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                block3: {
                    if (project == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    DevToolsService.this.devToolsFutureRef.set(null);
                    try {
                        DevToolsService.this.daemonApi.daemonShutdown().get(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOG.error("DevTools daemon did not shut down normally: " + String.valueOf(e));
                        if (DevToolsService.this.process.isProcessTerminated()) break block3;
                        DevToolsService.this.process.destroyProcess();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/run/daemon/DevToolsService$3", "projectClosing"));
            }
        });
    }

    private void setUpWithPub() {
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.project);
        if (sdk == null) {
            this.logExceptionAndComplete("Flutter SDK is null");
            return;
        }
        this.pubActivateDevTools(sdk).thenAccept(success -> {
            if (success.booleanValue()) {
                this.pubRunDevTools(sdk);
            } else {
                this.logExceptionAndComplete("pub activate of DevTools failed");
            }
        });
    }

    private void pubRunDevTools(FlutterSdk sdk) {
        FlutterCommand command = sdk.flutterPub(null, "global", "run", "devtools", "--machine", "--port=0");
        final ColoredProcessHandler handler = command.startProcessOrShowError(this.project);
        if (handler == null) {
            this.logExceptionAndComplete("Handler was null for pub global run command");
            return;
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((text = event.getText().trim()).startsWith("{") && text.endsWith("}")) {
                    try {
                        JsonElement element = JsonUtils.parseString(text);
                        JsonObject obj = element.getAsJsonObject();
                        JsonObject params = obj.getAsJsonObject("params");
                        String host = JsonUtils.getStringMember(params, "host");
                        int port = JsonUtils.getIntMember(params, "port");
                        if (port != -1) {
                            DevToolsService.this.devToolsFutureRef.get().complete(new DevToolsInstance(host, port));
                        } else {
                            DevToolsService.this.logExceptionAndComplete("DevTools port was invalid");
                            handler.destroyProcess();
                        }
                    }
                    catch (JsonSyntaxException e) {
                        DevToolsService.this.logExceptionAndComplete((Exception)((Object)e));
                        handler.destroyProcess();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/daemon/DevToolsService$4";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        handler.startNotify();
        ProjectManager.getInstance().addProjectManagerListener(this.project, new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    5.$$$reportNull$$$0(0);
                }
                DevToolsService.this.devToolsFutureRef.set(null);
                handler.destroyProcess();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/run/daemon/DevToolsService$5", "projectClosing"));
            }
        });
    }

    private CompletableFuture<Boolean> pubActivateDevTools(FlutterSdk sdk) {
        CompletableFuture<Boolean> result;
        block2: {
            FlutterCommand command = sdk.flutterPub(null, "global", "activate", "devtools");
            result = new CompletableFuture<Boolean>();
            Process process = command.start(output -> {
                if (output.getExitCode() != 0) {
                    String message = (output.getStdout() + "\n" + output.getStderr()).trim();
                    FlutterConsoles.displayMessage(this.project, null, message, true);
                }
            }, null);
            try {
                int resultCode = process.waitFor();
                result.complete(resultCode == 0);
            }
            catch (InterruptedException | RuntimeException re) {
                if (result.isDone()) break block2;
                result.complete(false);
            }
        }
        return result;
    }

    private void logExceptionAndComplete(String message) {
        this.logExceptionAndComplete(new Exception(message));
    }

    private void logExceptionAndComplete(Exception exception) {
        LOG.info((Throwable)exception);
        FlutterInitializer.getAnalytics().sendExpectedException("devtools-service", exception);
        CompletableFuture<DevToolsInstance> future = this.devToolsFutureRef.get();
        if (future != null) {
            future.completeExceptionally(exception);
        }
    }

    private static GeneralCommandLine chooseCommand(@NotNull Project project) {
        String script;
        Workspace workspace;
        if (project == null) {
            DevToolsService.$$$reportNull$$$0(3);
        }
        if ((workspace = WorkspaceCache.getInstance(project).get()) != null && (script = workspace.getDaemonScript()) != null) {
            return DevToolsService.createCommand(workspace.getRoot().getPath(), script, (ImmutableList<String>)ImmutableList.of());
        }
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
        if (sdk == null) {
            return null;
        }
        try {
            String path = FlutterSdkUtil.pathToFlutterTool(sdk.getHomePath());
            return DevToolsService.createCommand(sdk.getHomePath(), path, (ImmutableList<String>)ImmutableList.of((Object)"daemon"));
        }
        catch (com.intellij.execution.ExecutionException e) {
            FlutterUtils.warn(LOG, "Unable to calculate command to start Flutter daemon", e);
            return null;
        }
    }

    private static GeneralCommandLine createCommand(String workDir, String command, ImmutableList<String> arguments) {
        GeneralCommandLine result = new GeneralCommandLine().withWorkDirectory(workDir);
        result.setCharset(StandardCharsets.UTF_8);
        result.setExePath(FileUtil.toSystemDependentName((String)command));
        result.withEnvironment("FLUTTER_HOST", new FlutterSdkUtil().getFlutterHostEnvValue());
        for (String argument : arguments) {
            result.addParameter(argument);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/daemon/DevToolsService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/daemon/DevToolsService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chooseCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class DevToolsServiceListener
    implements DaemonEvent.Listener {
        private DevToolsServiceListener() {
        }
    }
}

