/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.android.IntelliJAndroidSdk;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.run.FlutterDevice;
import io.flutter.run.daemon.DaemonApi;
import io.flutter.run.daemon.DaemonEvent;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.MostlySilentColoredProcessHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeviceDaemon {
    private static final AtomicInteger nextDaemonId = new AtomicInteger();
    private static final int RESTART_ATTEMPTS_BEFORE_WARNING = 1;
    private final int id;
    @NotNull
    private final Command command;
    @NotNull
    private final ProcessHandler process;
    @NotNull
    private final Listener listener;
    @NotNull
    private final AtomicReference<ImmutableList<FlutterDevice>> devices;
    private static final Logger LOG = Logger.getInstance(DeviceDaemon.class);

    private DeviceDaemon(int id, @NotNull Command command, @NotNull ProcessHandler process, @NotNull Listener listener, @NotNull AtomicReference<ImmutableList<FlutterDevice>> devices) {
        if (command == null) {
            DeviceDaemon.$$$reportNull$$$0(0);
        }
        if (process == null) {
            DeviceDaemon.$$$reportNull$$$0(1);
        }
        if (listener == null) {
            DeviceDaemon.$$$reportNull$$$0(2);
        }
        if (devices == null) {
            DeviceDaemon.$$$reportNull$$$0(3);
        }
        this.id = id;
        this.command = command;
        this.process = process;
        this.listener = listener;
        this.devices = devices;
        listener.running.set(true);
    }

    boolean isRunning() {
        return !this.process.isProcessTerminating() && !this.process.isProcessTerminated();
    }

    ImmutableList<FlutterDevice> getDevices() {
        return this.devices.get();
    }

    boolean needRestart(@NotNull Command next) {
        if (next == null) {
            DeviceDaemon.$$$reportNull$$$0(4);
        }
        return !this.isRunning() || !this.command.equals(next);
    }

    void shutdown() {
        if (!this.process.isProcessTerminated()) {
            LOG.info("shutting down Flutter device daemon #" + this.id + ": " + String.valueOf(this.command));
        }
        this.listener.running.set(false);
        this.process.destroyProcess();
    }

    @Nullable
    static Command chooseCommand(@NotNull Project project) {
        String script;
        if (project == null) {
            DeviceDaemon.$$$reportNull$$$0(5);
        }
        if (!DeviceDaemon.usesFlutter(project)) {
            return null;
        }
        String androidHome = IntelliJAndroidSdk.chooseAndroidHome(project, false);
        Workspace workspace = WorkspaceCache.getInstance(project).get();
        if (workspace != null && (script = workspace.getDaemonScript()) != null) {
            return new Command(workspace.getRoot().getPath(), script, (ImmutableList<String>)ImmutableList.of(), androidHome);
        }
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
        if (sdk == null) {
            return null;
        }
        try {
            String path = FlutterSdkUtil.pathToFlutterTool(sdk.getHomePath());
            ImmutableList list = FlutterUtils.isIntegrationTestingMode() ? ImmutableList.of((Object)"--show-test-device", (Object)"daemon") : ImmutableList.of((Object)"daemon");
            return new Command(sdk.getHomePath(), path, (ImmutableList<String>)list, androidHome);
        }
        catch (ExecutionException e) {
            FlutterUtils.warn(LOG, "Unable to calculate command to watch Flutter devices", e);
            return null;
        }
    }

    private static boolean usesFlutter(@NotNull Project project) {
        if (project == null) {
            DeviceDaemon.$$$reportNull$$$0(6);
        }
        return FlutterModuleUtils.isFlutterBazelProject(project) || FlutterModuleUtils.hasFlutterModule(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/daemon/DeviceDaemon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "needRestart";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "usesFlutter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Command {
        @NotNull
        private final String workDir;
        @NotNull
        private final String command;
        @NotNull
        private final ImmutableList<String> parameters;
        @Nullable
        private final String androidHome;

        private Command(@NotNull String workDir, @NotNull String command, @NotNull ImmutableList<String> parameters, @Nullable String androidHome) {
            if (workDir == null) {
                Command.$$$reportNull$$$0(0);
            }
            if (command == null) {
                Command.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                Command.$$$reportNull$$$0(2);
            }
            this.workDir = workDir;
            this.command = command;
            this.parameters = parameters;
            this.androidHome = androidHome;
        }

        DeviceDaemon start(Supplier<Boolean> isCancelled, Runnable deviceChanged, Consumer<String> processStopped) throws ExecutionException {
            int daemonId = nextDaemonId.incrementAndGet();
            LOG.info("starting Flutter device daemon #" + daemonId + ": " + this.toString());
            MostlySilentColoredProcessHandler process = new MostlySilentColoredProcessHandler(this.toCommandLine());
            boolean succeeded = false;
            try {
                Object exitCode;
                AtomicReference<ImmutableList<FlutterDevice>> devices = new AtomicReference<ImmutableList<FlutterDevice>>(ImmutableList.of());
                DaemonApi api = new DaemonApi((ProcessHandler)process);
                Listener listener = new Listener(daemonId, api, devices, deviceChanged, processStopped);
                api.listen((ProcessHandler)process, listener);
                CompletionStage ready = listener.connected.thenCompose(ignored -> api.enableDeviceEvents());
                int attempts = 0;
                if (isCancelled.get().booleanValue()) {
                    throw new CancellationException();
                }
                if (process.isProcessTerminated()) {
                    exitCode = process.getExitCode();
                    String failureMessage = "Flutter device daemon #" + daemonId + " exited (exit code " + (Integer)exitCode + ")";
                    if (!api.getStderrTail().isEmpty()) {
                        failureMessage = failureMessage + ", stderr: " + api.getStderrTail();
                    }
                    if (++attempts <= 1) {
                        LOG.warn(failureMessage);
                    } else {
                        LOG.warn(failureMessage);
                        if (attempts == 2) {
                            FlutterMessages.showError("Flutter device daemon", failureMessage, null);
                        } else if (attempts == 5) {
                            ApplicationManager.getApplication().invokeLater(() -> new DaemonCrashReporter().show(), ModalityState.NON_MODAL);
                            DeviceDaemon deviceDaemon = null;
                            return deviceDaemon;
                        }
                    }
                }
                ready.get(attempts <= 1 ? 100L : 10000L * (long)attempts, TimeUnit.MILLISECONDS);
                succeeded = true;
                exitCode = new DeviceDaemon(daemonId, this, (ProcessHandler)process, listener, devices);
                return exitCode;
            }
            finally {
                if (!succeeded) {
                    process.destroyProcess();
                }
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Command)) {
                return false;
            }
            Command other = (Command)obj;
            return Objects.equal((Object)this.workDir, (Object)other.workDir) && Objects.equal((Object)this.command, (Object)other.command) && Objects.equal(this.parameters, other.parameters) && Objects.equal((Object)this.androidHome, (Object)other.androidHome);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.workDir, this.command, this.parameters, this.androidHome});
        }

        private GeneralCommandLine toCommandLine() {
            GeneralCommandLine result = new GeneralCommandLine().withWorkDirectory(this.workDir);
            result.setCharset(StandardCharsets.UTF_8);
            result.setExePath(FileUtil.toSystemDependentName((String)this.command));
            result.withEnvironment("FLUTTER_HOST", new FlutterSdkUtil().getFlutterHostEnvValue());
            if (this.androidHome != null) {
                result.withEnvironment("ANDROID_HOME", this.androidHome);
            }
            for (String param : this.parameters) {
                result.addParameter(param);
            }
            return result;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append(this.command);
            if (!this.parameters.isEmpty()) {
                out.append(' ');
                out.append(Joiner.on((char)' ').join(this.parameters));
            }
            return out.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workDir";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
            }
            objectArray[1] = "io/flutter/run/daemon/DeviceDaemon$Command";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Listener
    implements DaemonEvent.Listener {
        private final int daemonId;
        private final DaemonApi api;
        private final AtomicReference<ImmutableList<FlutterDevice>> devices;
        private final Runnable deviceChanged;
        private final Consumer<String> processStopped;
        private final transient CompletableFuture<Void> connected = new CompletableFuture();
        private final AtomicBoolean running = new AtomicBoolean(false);

        Listener(int daemonId, DaemonApi api, AtomicReference<ImmutableList<FlutterDevice>> devices, Runnable deviceChanged, Consumer<String> processStopped) {
            this.daemonId = daemonId;
            this.api = api;
            this.devices = devices;
            this.deviceChanged = deviceChanged;
            this.processStopped = processStopped;
        }

        @Override
        public void onDaemonConnected(DaemonEvent.DaemonConnected event) {
            this.connected.complete(null);
        }

        @Override
        public void onDaemonLogMessage(@NotNull DaemonEvent.DaemonLogMessage message) {
            if (message == null) {
                Listener.$$$reportNull$$$0(0);
            }
            LOG.info("flutter device daemon #" + this.daemonId + ": " + message.message);
        }

        @Override
        public void onDaemonShowMessage(@NotNull DaemonEvent.DaemonShowMessage event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(1);
            }
            if ("error".equals(event.level)) {
                FlutterMessages.showError(event.title, event.message, null);
            } else if ("warning".equals(event.level)) {
                FlutterMessages.showWarning(event.title, event.message, null);
            } else {
                FlutterMessages.showInfo(event.title, event.message, null);
            }
        }

        @Override
        public void onDeviceAdded(@NotNull DaemonEvent.DeviceAdded event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (event.id == null) {
                FlutterUtils.warn(LOG, "Ignored an event from a Flutter process without a device id: " + String.valueOf(event));
                return;
            }
            FlutterDevice newDevice = new FlutterDevice(event.id, event.emulatorId == null ? (event.name == null ? event.id : event.name) : (event.platformType.equals("android") ? event.emulatorId : event.name), event.platform, event.emulator, event.category, event.platformType, event.ephemeral);
            this.devices.updateAndGet(old -> Listener.addDevice(old.stream(), newDevice));
            this.deviceChanged.run();
        }

        @Override
        public void onDeviceRemoved(@NotNull DaemonEvent.DeviceRemoved event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(3);
            }
            this.devices.updateAndGet(old -> Listener.removeDevice(old.stream(), event.id));
            this.deviceChanged.run();
        }

        @Override
        public void processTerminated(int exitCode) {
            if (this.running.get()) {
                this.processStopped.accept("Daemon #" + this.daemonId + " exited. Exit code: " + exitCode + ". Stderr:\n" + this.api.getStderrTail());
            }
        }

        private static ImmutableList<FlutterDevice> addDevice(Stream<FlutterDevice> old, FlutterDevice newDevice) {
            ArrayList<FlutterDevice> changed = new ArrayList<FlutterDevice>((Collection<FlutterDevice>)Listener.removeDevice(old, newDevice.deviceId()));
            changed.add(newDevice);
            changed.sort(Comparator.comparing(FlutterDevice::deviceName));
            return ImmutableList.copyOf(changed);
        }

        private static ImmutableList<FlutterDevice> removeDevice(Stream<FlutterDevice> old, String idToRemove) {
            return ImmutableList.copyOf(old.filter(d -> !d.deviceId().equals(idToRemove)).iterator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/run/daemon/DeviceDaemon$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDaemonLogMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDaemonShowMessage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDeviceAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDeviceRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DaemonCrashReporter
    extends DialogWrapper {
        private JPanel myPanel;
        private JTextPane myTextPane;

        DaemonCrashReporter() {
            super(null, false, false);
            this.setTitle("Flutter Device Daemon Crash");
            this.myPanel = new JPanel();
            this.myTextPane = new JTextPane();
            String os = SystemInfo.getOsNameAndVersion();
            String link = "https://www.google.com/search?q=increase maximum file handles " + os;
            Messages.installHyperlinkSupport((JTextPane)this.myTextPane);
            String message = "<html><body><p>The Flutter device daemon cannot be started. <br>Please check your configuration and restart the IDE. <br><br>You may need to <a href=\"" + link + "\">increase the maximum number of file handles</a><br>available globally.</body></html>";
            this.myTextPane.setText(message);
            this.myPanel.add(this.myTextPane);
            this.init();
            this.getButton(this.getCancelAction()).setVisible(false);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel;
        }
    }
}

