/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Disposer;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.run.FlutterDevice;
import io.flutter.run.daemon.DeviceDaemon;
import io.flutter.run.daemon.DeviceSelection;
import io.flutter.sdk.AndroidEmulatorManager;
import io.flutter.sdk.FlutterSdkManager;
import io.flutter.utils.Refreshable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceService {
    @NotNull
    private final Project project;
    private final Refreshable<DeviceDaemon> deviceDaemon;
    private final AtomicReference<DeviceSelection> deviceSelection;
    private final AtomicReference<ImmutableSet<Runnable>> listeners;
    private final AtomicLong lastRestartTime;
    private boolean refreshInProgress;
    private static final Logger LOG = Logger.getInstance(DeviceService.class);

    @NotNull
    public static DeviceService getInstance(@NotNull Project project) {
        if (project == null) {
            DeviceService.$$$reportNull$$$0(0);
        }
        DeviceService deviceService = Objects.requireNonNull((DeviceService)project.getService(DeviceService.class));
        if (deviceService == null) {
            DeviceService.$$$reportNull$$$0(1);
        }
        return deviceService;
    }

    private DeviceService(@NotNull Project project) {
        if (project == null) {
            DeviceService.$$$reportNull$$$0(2);
        }
        this.deviceDaemon = new Refreshable<DeviceDaemon>(DeviceDaemon::shutdown);
        this.deviceSelection = new AtomicReference<DeviceSelection>(DeviceSelection.EMPTY);
        this.listeners = new AtomicReference<ImmutableSet>(ImmutableSet.of());
        this.lastRestartTime = new AtomicLong(0L);
        this.refreshInProgress = false;
        this.project = project;
        this.deviceDaemon.setDisposeParent((Disposable)project);
        this.deviceDaemon.subscribe(this::refreshDeviceSelection);
        this.refreshDeviceDaemon();
        FlutterSdkManager.Listener sdkListener = new FlutterSdkManager.Listener(){

            @Override
            public void flutterSdkAdded() {
                DeviceService.this.refreshDeviceDaemon();
            }

            @Override
            public void flutterSdkRemoved() {
                DeviceService.this.refreshDeviceDaemon();
            }
        };
        FlutterSdkManager.getInstance(project).addListener(sdkListener);
        Disposer.register((Disposable)project, () -> FlutterSdkManager.getInstance(project).removeListener(sdkListener));
        WorkspaceCache.getInstance(project).subscribe(this::refreshDeviceDaemon);
        ProjectRootManagerEx.getInstanceEx((Project)project).addProjectJdkListener(this::refreshDeviceDaemon);
    }

    public void addListener(@NotNull Runnable callback) {
        if (callback == null) {
            DeviceService.$$$reportNull$$$0(3);
        }
        this.listeners.updateAndGet(old -> {
            ArrayList<Runnable> changed = new ArrayList<Runnable>((Collection<Runnable>)old);
            changed.add(callback);
            return ImmutableSet.copyOf(changed);
        });
    }

    public void removeListener(@NotNull Runnable callback) {
        if (callback == null) {
            DeviceService.$$$reportNull$$$0(4);
        }
        this.listeners.updateAndGet(old -> {
            ArrayList changed = new ArrayList(old);
            changed.remove(callback);
            return ImmutableSet.copyOf(changed);
        });
    }

    public boolean isRefreshInProgress() {
        return this.refreshInProgress;
    }

    public State getStatus() {
        DeviceDaemon daemon = this.deviceDaemon.getNow();
        if (daemon != null && daemon.isRunning()) {
            return State.READY;
        }
        if (this.deviceDaemon.getState() == Refreshable.State.BUSY) {
            return State.LOADING;
        }
        return State.INACTIVE;
    }

    public Collection<FlutterDevice> getConnectedDevices() {
        return this.deviceSelection.get().getDevices();
    }

    @Nullable
    public FlutterDevice getSelectedDevice() {
        return this.deviceSelection.get().getSelection();
    }

    public void setSelectedDevice(@Nullable FlutterDevice device) {
        this.deviceSelection.updateAndGet(old -> old.withSelection(device == null ? null : device.deviceId()));
        this.fireChangeEvent();
    }

    private synchronized void refreshDeviceSelection() {
        this.deviceSelection.updateAndGet(old -> {
            DeviceDaemon daemon = this.deviceDaemon.getNow();
            ImmutableList<FlutterDevice> newDevices = daemon == null ? ImmutableList.of() : daemon.getDevices();
            return old.withDevices((List<FlutterDevice>)newDevices);
        });
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        SwingUtilities.invokeLater(() -> {
            if (this.project.isDisposed()) {
                return;
            }
            for (Runnable listener : this.listeners.get()) {
                try {
                    listener.run();
                }
                catch (Exception e) {
                    FlutterUtils.warn(LOG, "DeviceDaemon listener threw an exception", e);
                }
            }
        });
    }

    private void refreshDeviceDaemon() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            DumbService.getInstance((Project)this.project).waitForSmartMode();
            if (this.project.isDisposed()) {
                return;
            }
            this.deviceDaemon.refresh(this::chooseNextDaemon);
            this.refreshInProgress = false;
            ActivityTracker.getInstance().inc();
        });
    }

    private void daemonStopped(String details) {
        if (this.project.isDisposed()) {
            return;
        }
        DeviceDaemon current = this.deviceDaemon.getNow();
        if (current == null || current.isRunning()) {
            LOG.info("A Flutter device daemon stopped.\n" + details);
            return;
        }
        long now = System.currentTimeMillis();
        long millisSinceLastRestart = now - this.lastRestartTime.get();
        if (millisSinceLastRestart > TimeUnit.SECONDS.toMillis(20L)) {
            LOG.info("A Flutter device daemon stopped. Automatically restarting it.\n" + details);
            this.refreshDeviceDaemon();
            this.lastRestartTime.set(now);
            return;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        FlutterMessages.showWarning("Flutter daemon terminated", "Consider re-starting " + info.getVersionName() + ".", this.project);
    }

    private DeviceDaemon chooseNextDaemon(Refreshable.Request<DeviceDaemon> request) {
        DeviceDaemon.Command nextCommand = DeviceDaemon.chooseCommand(this.project);
        if (nextCommand == null) {
            return null;
        }
        DeviceDaemon previous = request.getPrevious();
        if (previous != null && !previous.needRestart(nextCommand)) {
            return previous;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            return previous;
        }
        if (request.isCancelled()) {
            return previous;
        }
        AndroidEmulatorManager emulatorManager = AndroidEmulatorManager.getInstance(this.project);
        emulatorManager.refresh();
        try {
            return nextCommand.start(request::isCancelled, this::refreshDeviceSelection, this::daemonStopped);
        }
        catch (ExecutionException executionException) {
            LOG.info("Error starting up the Flutter device daemon", (Throwable)executionException);
            return previous;
        }
    }

    public void restart() {
        if (this.project.isDisposed()) {
            return;
        }
        this.refreshInProgress = true;
        JobScheduler.getScheduler().schedule(this::shutDown, 0L, TimeUnit.SECONDS);
        JobScheduler.getScheduler().schedule(this::refreshDeviceDaemon, 4L, TimeUnit.SECONDS);
    }

    private void shutDown() {
        this.deviceDaemon.refresh(this::shutDownDaemon);
    }

    private DeviceDaemon shutDownDaemon(Refreshable.Request<DeviceDaemon> request) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/daemon/DeviceService";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/daemon/DeviceService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum State {
        INACTIVE,
        LOADING,
        READY;

    }
}

