/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonObject;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.ObservatoryConnector;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.logging.FlutterConsoleLogManager;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.run.FlutterDebugProcess;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.DaemonApi;
import io.flutter.run.daemon.FlutterAppDaemonEventListener;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.MostlySilentColoredProcessHandler;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.UrlUtils;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.DisplayRefreshRateManager;
import io.flutter.vmService.ServiceExtensions;
import io.flutter.vmService.VMServiceManager;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterApp
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FlutterApp.class);
    private static final Key<FlutterApp> FLUTTER_APP_KEY = new Key("FLUTTER_APP_KEY");
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @NotNull
    private final RunMode myMode;
    @NotNull
    private final FlutterDevice myDevice;
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final ExecutionEnvironment myExecutionEnvironment;
    @NotNull
    private final DaemonApi myDaemonApi;
    @NotNull
    private final GeneralCommandLine myCommand;
    @Nullable
    private String myAppId;
    @Nullable
    private String myWsUrl;
    @Nullable
    private String myBaseUri;
    @Nullable
    private ConsoleView myConsole;
    private FlutterConsoleLogManager myFlutterConsoleLogManager;
    @Nullable
    private String myLaunchMode;
    @Nullable
    private List<PubRoot> myPubRoots;
    private int reloadCount;
    private int userReloadCount;
    private int restartCount;
    private long maxFileTimestamp;
    @Nullable
    private Runnable myResume;
    private final AtomicReference<State> myState;
    private final EventDispatcher<FlutterAppListener> listenersDispatcher;
    private final ObservatoryConnector myConnector;
    @Nullable
    private FlutterDebugProcess myFlutterDebugProcess;
    @Nullable
    private VmService myVmService;
    @Nullable
    private VMServiceManager myVMServiceManager;
    private static final Key<FlutterApp> APP_KEY = Key.create((String)"FlutterApp");

    public static void addToEnvironment(@NotNull ExecutionEnvironment env, @NotNull FlutterApp app) {
        if (env == null) {
            FlutterApp.$$$reportNull$$$0(0);
        }
        if (app == null) {
            FlutterApp.$$$reportNull$$$0(1);
        }
        env.putUserData(APP_KEY, (Object)app);
    }

    @Nullable
    public static FlutterApp fromEnv(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            FlutterApp.$$$reportNull$$$0(2);
        }
        return (FlutterApp)env.getUserData(APP_KEY);
    }

    FlutterApp(@NotNull Project project, @Nullable Module module, @NotNull RunMode mode, @NotNull FlutterDevice device, @NotNull ProcessHandler processHandler, @NotNull ExecutionEnvironment executionEnvironment, @NotNull DaemonApi daemonApi, @NotNull GeneralCommandLine command) {
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(3);
        }
        if (mode == null) {
            FlutterApp.$$$reportNull$$$0(4);
        }
        if (device == null) {
            FlutterApp.$$$reportNull$$$0(5);
        }
        if (processHandler == null) {
            FlutterApp.$$$reportNull$$$0(6);
        }
        if (executionEnvironment == null) {
            FlutterApp.$$$reportNull$$$0(7);
        }
        if (daemonApi == null) {
            FlutterApp.$$$reportNull$$$0(8);
        }
        if (command == null) {
            FlutterApp.$$$reportNull$$$0(9);
        }
        this.myState = new AtomicReference<State>(State.STARTING);
        this.listenersDispatcher = EventDispatcher.create(FlutterAppListener.class);
        this.myProject = project;
        this.myModule = module;
        this.myMode = mode;
        this.myDevice = device;
        this.myProcessHandler = processHandler;
        this.myProcessHandler.putUserData(FLUTTER_APP_KEY, (Object)this);
        this.myExecutionEnvironment = executionEnvironment;
        this.myDaemonApi = daemonApi;
        this.myCommand = command;
        this.maxFileTimestamp = System.currentTimeMillis();
        this.myConnector = new ObservatoryConnector(){

            @Override
            @Nullable
            public String getWebSocketUrl() {
                if (FlutterApp.this.getState() != State.STARTED) {
                    return null;
                }
                return FlutterApp.this.myWsUrl;
            }

            @Override
            @Nullable
            public String getBrowserUrl() {
                Object url = FlutterApp.this.myWsUrl;
                if (url == null) {
                    return null;
                }
                if (((String)url).startsWith("ws:")) {
                    url = "http:" + ((String)url).substring(3);
                }
                if (((String)url).endsWith("/ws")) {
                    url = ((String)url).substring(0, ((String)url).length() - 3);
                }
                return url;
            }

            @Override
            public String getRemoteBaseUrl() {
                return FlutterApp.this.myBaseUri;
            }

            @Override
            public void onDebuggerPaused(@NotNull Runnable resume) {
                if (resume == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterApp.this.myResume = resume;
            }

            @Override
            public void onDebuggerResumed() {
                FlutterApp.this.myResume = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resume", "io/flutter/run/daemon/FlutterApp$1", "onDebuggerPaused"));
            }
        };
    }

    @NotNull
    public GeneralCommandLine getCommand() {
        GeneralCommandLine generalCommandLine = this.myCommand;
        if (generalCommandLine == null) {
            FlutterApp.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    @Nullable
    public static FlutterApp fromProcess(@NotNull ProcessHandler process) {
        if (process == null) {
            FlutterApp.$$$reportNull$$$0(11);
        }
        return (FlutterApp)process.getUserData(FLUTTER_APP_KEY);
    }

    @Nullable
    public static FlutterApp firstFromProjectProcess(@NotNull Project project) {
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(12);
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        for (RunContentDescriptor descriptor : runningProcesses) {
            FlutterApp app;
            ProcessHandler process = descriptor.getProcessHandler();
            if (process == null || (app = FlutterApp.fromProcess(process)) == null) continue;
            return app;
        }
        return null;
    }

    @NotNull
    public static List<FlutterApp> allFromProjectProcess(@NotNull Project project) {
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(13);
        }
        ArrayList<FlutterApp> allRunningApps = new ArrayList<FlutterApp>();
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        for (RunContentDescriptor descriptor : runningProcesses) {
            FlutterApp app;
            ProcessHandler process = descriptor.getProcessHandler();
            if (process == null || (app = FlutterApp.fromProcess(process)) == null) continue;
            allRunningApps.add(app);
        }
        ArrayList<FlutterApp> arrayList = allRunningApps;
        if (arrayList == null) {
            FlutterApp.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static FlutterApp start(@NotNull ExecutionEnvironment env, final @NotNull Project project, @Nullable Module module, final @NotNull RunMode mode, @NotNull FlutterDevice device, @NotNull GeneralCommandLine command, @Nullable String analyticsStart, final @Nullable String analyticsStop) throws ExecutionException {
        if (env == null) {
            FlutterApp.$$$reportNull$$$0(15);
        }
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            FlutterApp.$$$reportNull$$$0(17);
        }
        if (device == null) {
            FlutterApp.$$$reportNull$$$0(18);
        }
        if (command == null) {
            FlutterApp.$$$reportNull$$$0(19);
        }
        LOG.info(analyticsStart + " " + project.getName() + " (" + mode.mode() + ")");
        LOG.info(command.toString());
        Consumer<String> onTextAvailable = null;
        if (WorkspaceCache.getInstance(project).isBazel()) {
            Workspace workspace = WorkspaceCache.getInstance(project).get();
            assert (workspace != null);
            String configWarningPrefix = workspace.getConfigWarningPrefix();
            if (configWarningPrefix != null) {
                onTextAvailable = text -> {
                    if (text.startsWith(configWarningPrefix)) {
                        FlutterMessages.showWarning("Configuration warning", UrlUtils.generateHtmlFragmentWithHrefTags(text.substring(configWarningPrefix.length())), null);
                    }
                };
            }
        }
        MostlySilentColoredProcessHandler process = new MostlySilentColoredProcessHandler(command, onTextAvailable);
        Disposer.register((Disposable)project, () -> ((ProcessHandler)process).destroyProcess());
        if (analyticsStart != null) {
            FlutterInitializer.sendAnalyticsAction(analyticsStart);
        }
        DaemonApi api = new DaemonApi((ProcessHandler)process);
        final FlutterApp app = new FlutterApp(project, module, mode, device, (ProcessHandler)process, env, api, command);
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.info(analyticsStop + " " + project.getName() + " (" + mode.mode() + ")");
                if (analyticsStop != null) {
                    FlutterInitializer.sendAnalyticsAction(analyticsStop);
                }
                String workflowType = app.reloadCount > 0 ? "reload" : (app.restartCount > 0 ? "restart" : "none");
                FlutterInitializer.getAnalytics().sendEvent("workflow", workflowType);
                int reloadfraction = 0;
                if (app.reloadCount + app.restartCount > 0) {
                    double fraction = (double)app.reloadCount * 100.0 / (double)(app.reloadCount + app.restartCount);
                    reloadfraction = (int)Math.round(fraction);
                }
                FlutterInitializer.getAnalytics().sendEventMetric("workflow", "reloadFraction", reloadfraction);
                Disposer.dispose((Disposable)app);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/run/daemon/FlutterApp$2", "processTerminated"));
            }
        });
        api.listen((ProcessHandler)process, new FlutterAppDaemonEventListener(app, project));
        FlutterApp flutterApp = app;
        if (flutterApp == null) {
            FlutterApp.$$$reportNull$$$0(20);
        }
        return flutterApp;
    }

    @NotNull
    public RunMode getMode() {
        RunMode runMode = this.myMode;
        if (runMode == null) {
            FlutterApp.$$$reportNull$$$0(21);
        }
        return runMode;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            FlutterApp.$$$reportNull$$$0(22);
        }
        return processHandler;
    }

    @NotNull
    public ObservatoryConnector getConnector() {
        ObservatoryConnector observatoryConnector = this.myConnector;
        if (observatoryConnector == null) {
            FlutterApp.$$$reportNull$$$0(23);
        }
        return observatoryConnector;
    }

    public boolean appSupportsHotReload() {
        if (this.myVMServiceManager != null && this.myVMServiceManager.hasAnyRegisteredServices()) {
            return this.myVMServiceManager.hasRegisteredService("reloadSources");
        }
        return true;
    }

    public State getState() {
        return this.myState.get();
    }

    public boolean isStarted() {
        State state = this.myState.get();
        return state != State.STARTING && state != State.TERMINATED;
    }

    public boolean isReloading() {
        return this.myState.get() == State.RELOADING || this.myState.get() == State.RESTARTING;
    }

    public boolean isConnected() {
        return this.myState.get() != State.TERMINATING && this.myState.get() != State.TERMINATED;
    }

    void setAppId(@NotNull String id) {
        if (id == null) {
            FlutterApp.$$$reportNull$$$0(24);
        }
        this.myAppId = id;
    }

    void setWsUrl(@NotNull String url) {
        if (url == null) {
            FlutterApp.$$$reportNull$$$0(25);
        }
        this.myWsUrl = url;
    }

    void setBaseUri(@NotNull String uri) {
        if (uri == null) {
            FlutterApp.$$$reportNull$$$0(26);
        }
        this.myBaseUri = uri;
    }

    void setLaunchMode(@Nullable String launchMode) {
        this.myLaunchMode = launchMode;
    }

    public CompletableFuture<DaemonApi.RestartResult> performRestartApp(@NotNull String reason) {
        if (reason == null) {
            FlutterApp.$$$reportNull$$$0(27);
        }
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot restart Flutter app because app id is not set");
            CompletableFuture<DaemonApi.RestartResult> result2 = new CompletableFuture<DaemonApi.RestartResult>();
            result2.completeExceptionally(new IllegalStateException("cannot restart Flutter app because app id is not set"));
            return result2;
        }
        ++this.restartCount;
        this.userReloadCount = 0;
        LocalHistory.getInstance().putSystemLabel(this.getProject(), "Flutter hot restart");
        this.maxFileTimestamp = System.currentTimeMillis();
        this.changeState(State.RESTARTING);
        CompletableFuture<DaemonApi.RestartResult> future = this.myDaemonApi.restartApp(this.myAppId, true, false, reason);
        future.thenAccept(result -> this.changeState(State.STARTED));
        future.thenRun(this::notifyAppRestarted);
        return future;
    }

    private void notifyAppReloaded() {
        ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).notifyAppReloaded();
    }

    private void notifyAppRestarted() {
        ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).notifyAppRestarted();
    }

    public boolean isSameModule(@Nullable Module other) {
        return Objects.equals(this.myModule, other);
    }

    public boolean isLatestVersionRunning(VirtualFile file) {
        return file != null && file.getTimeStamp() <= this.maxFileTimestamp;
    }

    public State transitionStartingHotReload() {
        State newState = State.RELOADING;
        State oldState = this.myState.getAndSet(newState);
        if (oldState != newState) {
            ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).stateChanged(newState);
        }
        return oldState;
    }

    public void cancelHotReloadState(@Nullable State previousState) {
        if (previousState != null) {
            this.changeState(previousState);
        }
    }

    public CompletableFuture<DaemonApi.RestartResult> performHotReload(boolean pauseAfterRestart, @NotNull String reason) {
        if (reason == null) {
            FlutterApp.$$$reportNull$$$0(28);
        }
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot reload Flutter app because app id is not set");
            if (this.getState() == State.RELOADING) {
                this.changeState(State.STARTED);
            }
            CompletableFuture<DaemonApi.RestartResult> result2 = new CompletableFuture<DaemonApi.RestartResult>();
            result2.completeExceptionally(new IllegalStateException("cannot reload Flutter app because app id is not set"));
            return result2;
        }
        ++this.reloadCount;
        ++this.userReloadCount;
        LocalHistory.getInstance().putSystemLabel(this.getProject(), "hot reload #" + this.userReloadCount);
        this.maxFileTimestamp = System.currentTimeMillis();
        this.changeState(State.RELOADING);
        CompletableFuture<DaemonApi.RestartResult> future = this.myDaemonApi.restartApp(this.myAppId, false, pauseAfterRestart, reason);
        future.thenAccept(result -> this.changeState(State.STARTED));
        future.thenRun(this::notifyAppReloaded);
        return future;
    }

    public CompletableFuture<DaemonApi.DevToolsAddress> serveDevTools() {
        return this.myDaemonApi.devToolsServe();
    }

    public CompletableFuture<String> togglePlatform() {
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot invoke togglePlatform on Flutter app because app id is not set");
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<JsonObject> result = this.callServiceExtension(ServiceExtensions.togglePlatformMode.getExtension());
        return result.thenApply(obj -> obj.get("value").getAsString());
    }

    public CompletableFuture<String> togglePlatform(String platform) {
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot invoke togglePlatform on Flutter app because app id is not set");
            return CompletableFuture.completedFuture(null);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", platform);
        return this.callServiceExtension(ServiceExtensions.togglePlatformMode.getExtension(), params).thenApply(obj -> obj != null ? obj.get("value").getAsString() : null);
    }

    public CompletableFuture<JsonObject> callServiceExtension(String methodName) {
        return this.callServiceExtension(methodName, new HashMap<String, Object>());
    }

    public CompletableFuture<JsonObject> callServiceExtension(String methodName, Map<String, Object> params) {
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot invoke " + methodName + " on Flutter app because app id is not set");
            return CompletableFuture.completedFuture(null);
        }
        if (this.isFlutterIsolateSuspended()) {
            return this.whenFlutterIsolateResumed().thenComposeAsync(ignored -> this.myDaemonApi.callAppServiceExtension(this.myAppId, methodName, params));
        }
        return this.myDaemonApi.callAppServiceExtension(this.myAppId, methodName, params);
    }

    public CompletableFuture<Boolean> callBooleanExtension(String methodName, boolean enabled) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enabled", enabled);
        return this.callServiceExtension(methodName, params).thenApply(obj -> obj == null ? null : Boolean.valueOf(obj.get("enabled").getAsBoolean()));
    }

    public CompletableFuture<Boolean> maybeCallBooleanExtension(String methodName, boolean enabled) {
        if (this.getVMServiceManager() != null && this.getVMServiceManager().hasServiceExtensionNow(methodName)) {
            return this.callBooleanExtension(methodName, enabled);
        }
        return CompletableFuture.completedFuture(false);
    }

    @Nullable
    public StreamSubscription<Boolean> hasServiceExtension(String name, Consumer<Boolean> onData) {
        if (this.getVMServiceManager() == null) {
            return null;
        }
        return this.getVMServiceManager().hasServiceExtension(name, onData);
    }

    public void hasServiceExtension(String name, Consumer<Boolean> onData, Disposable parentDisposable) {
        if (this.getVMServiceManager() != null) {
            this.getVMServiceManager().hasServiceExtension(name, onData, parentDisposable);
        }
    }

    public void setConsole(@Nullable ConsoleView console) {
        this.myConsole = console;
    }

    @Nullable
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    boolean changeState(@NotNull State newState) {
        State oldState;
        if (newState == null) {
            FlutterApp.$$$reportNull$$$0(29);
        }
        if ((oldState = this.myState.getAndSet(newState)) == newState) {
            return false;
        }
        ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).stateChanged(newState);
        return true;
    }

    public Future shutdownAsync() {
        String appId;
        FutureTask<Object> done = new FutureTask<Object>(() -> null);
        if (!this.changeState(State.TERMINATING)) {
            done.run();
            return done;
        }
        if (this.myResume != null) {
            this.myResume.run();
        }
        if ((appId = this.myAppId) == null) {
            this.myProcessHandler.destroyProcess();
            done.run();
            return done;
        }
        AppExecutorUtil.getAppExecutorService().submit(() -> {
            CompletableFuture<Boolean> stopDone = "attach".equals(this.myLaunchMode) ? this.myDaemonApi.detachApp(appId) : this.myDaemonApi.stopApp(appId);
            Stopwatch watch = Stopwatch.createStarted();
            while (watch.elapsed(TimeUnit.SECONDS) < 10L && this.getState() == State.TERMINATING) {
                try {
                    stopDone.get(100L, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (TimeoutException timeoutException) {
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            this.myProcessHandler.destroyProcess();
            this.myDaemonApi.cancelPending();
            done.run();
        });
        return done;
    }

    public void addStateListener(@NotNull FlutterAppListener listener) {
        if (listener == null) {
            FlutterApp.$$$reportNull$$$0(30);
        }
        this.listenersDispatcher.addListener((EventListener)listener);
        listener.stateChanged(this.myState.get());
    }

    public void removeStateListener(@NotNull FlutterAppListener listener) {
        if (listener == null) {
            FlutterApp.$$$reportNull$$$0(31);
        }
        this.listenersDispatcher.removeListener((EventListener)listener);
    }

    public FlutterLaunchMode getLaunchMode() {
        return FlutterLaunchMode.fromEnv(this.myExecutionEnvironment);
    }

    public boolean isSessionActive() {
        FlutterDebugProcess debugProcess = this.getFlutterDebugProcess();
        return this.isStarted() && debugProcess != null && debugProcess.getVmConnected() && !debugProcess.getSession().isStopped();
    }

    @NotNull
    public FlutterDevice device() {
        FlutterDevice flutterDevice = this.myDevice;
        if (flutterDevice == null) {
            FlutterApp.$$$reportNull$$$0(32);
        }
        return flutterDevice;
    }

    @Nullable
    public String deviceId() {
        return this.myDevice.deviceId();
    }

    public void setFlutterDebugProcess(FlutterDebugProcess flutterDebugProcess) {
        this.myFlutterDebugProcess = flutterDebugProcess;
    }

    public FlutterDebugProcess getFlutterDebugProcess() {
        return this.myFlutterDebugProcess;
    }

    public void setVmServices(@NotNull VmService vmService, VMServiceManager vmServiceManager) {
        if (vmService == null) {
            FlutterApp.$$$reportNull$$$0(33);
        }
        this.myVmService = vmService;
        this.myVMServiceManager = vmServiceManager;
        this.myVmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                if (StringUtil.equals((CharSequence)streamId, (CharSequence)"Extension") && StringUtil.equals((CharSequence)"Flutter.Frame", (CharSequence)event.getExtensionKind())) {
                    ((FlutterAppListener)FlutterApp.this.listenersDispatcher.getMulticaster()).notifyFrameRendered();
                }
            }
        });
        ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).notifyVmServiceAvailable(vmService);
        this.getFlutterConsoleLogManager();
    }

    @Nullable
    public VmService getVmService() {
        return this.myVmService;
    }

    @Nullable
    public VMServiceManager getVMServiceManager() {
        return this.myVMServiceManager;
    }

    @Nullable
    public DisplayRefreshRateManager getDisplayRefreshRateManager() {
        return this.myVMServiceManager != null ? this.myVMServiceManager.displayRefreshRateManager : null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(34);
        }
        return project;
    }

    @NotNull
    public List<PubRoot> getPubRoots() {
        if (this.myPubRoots == null) {
            this.myPubRoots = PubRoots.forProject(this.myProject);
        }
        List<PubRoot> list = this.myPubRoots;
        if (list == null) {
            FlutterApp.$$$reportNull$$$0(35);
        }
        return list;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    public FlutterConsoleLogManager getFlutterConsoleLogManager() {
        if (this.myFlutterConsoleLogManager == null) {
            assert (this.getConsole() != null);
            this.myFlutterConsoleLogManager = new FlutterConsoleLogManager(this.getConsole(), this);
            if (FlutterSettings.getInstance().isShowStructuredErrors()) {
                this.hasServiceExtension(ServiceExtensions.toggleShowStructuredErrors.getExtension(), present -> {
                    if (present.booleanValue()) {
                        this.callBooleanExtension(ServiceExtensions.toggleShowStructuredErrors.getExtension(), true);
                    }
                });
            }
        }
        return this.myFlutterConsoleLogManager;
    }

    public String toString() {
        return String.valueOf(this.myExecutionEnvironment) + ":" + this.deviceId();
    }

    public boolean isFlutterIsolateSuspended() {
        if (!this.isSessionActive() || this.myVMServiceManager.getCurrentFlutterIsolateRaw() == null) {
            return false;
        }
        return this.getFlutterDebugProcess().isIsolateSuspended(this.myVMServiceManager.getCurrentFlutterIsolateRaw().getId());
    }

    private CompletableFuture<?> whenFlutterIsolateResumed() {
        if (!this.isFlutterIsolateSuspended()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getFlutterDebugProcess().whenIsolateResumed(this.myVMServiceManager.getCurrentFlutterIsolateRaw().getId());
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 20, 21, 22, 23, 32, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonApi";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/daemon/FlutterApp";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/daemon/FlutterApp";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "allFromProjectProcess";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnector";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "device";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPubRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromEnv";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 32: 
            case 34: 
            case 35: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fromProcess";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "firstFromProjectProcess";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "allFromProjectProcess";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setAppId";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setWsUrl";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setBaseUri";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "performRestartApp";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "performHotReload";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "changeState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addStateListener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeStateListener";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setVmServices";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 20, 21, 22, 23, 32, 34, 35 -> new IllegalStateException(string);
        };
    }

    public static enum State {
        STARTING,
        STARTED,
        RELOADING,
        RESTARTING,
        TERMINATING,
        TERMINATED;

    }

    public static interface FlutterAppListener
    extends EventListener {
        default public void stateChanged(State newState) {
        }

        default public void notifyAppReloaded() {
        }

        default public void notifyAppRestarted() {
        }

        default public void notifyFrameRendered() {
        }

        default public void notifyVmServiceAvailable(VmService vmService) {
        }
    }
}

