/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.common.base.Stopwatch;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.run.daemon.DaemonEvent;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.ProgressHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class FlutterAppDaemonEventListener
implements DaemonEvent.Listener {
    private static final Logger LOG = Logger.getInstance(FlutterAppDaemonEventListener.class);
    @NotNull
    private final FlutterApp app;
    @NotNull
    private final ProgressHelper progress;
    private final AtomicReference<Stopwatch> stopwatch;

    FlutterAppDaemonEventListener(@NotNull FlutterApp app, @NotNull Project project) {
        if (app == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(1);
        }
        this.stopwatch = new AtomicReference();
        this.app = app;
        this.progress = new ProgressHelper(project);
    }

    @Override
    public void processWillTerminate() {
        this.progress.cancel();
        try {
            this.app.shutdownAsync().get(100L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOG.info("app shutdown took longer than 100ms");
        }
        catch (Exception e) {
            FlutterUtils.warn(LOG, "exception while shutting down Flutter App", e);
        }
    }

    @Override
    public void processTerminated(int exitCode) {
        this.progress.cancel();
        this.app.changeState(FlutterApp.State.TERMINATED);
    }

    @Override
    public void onDaemonLog(@NotNull DaemonEvent.DaemonLog message) {
        ConsoleView console;
        if (message == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(2);
        }
        if ((console = this.app.getConsole()) == null) {
            return;
        }
        if (message.log != null) {
            console.print(message.log + "\n", message.error ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    @Override
    public void onDaemonLogMessage(@NotNull DaemonEvent.DaemonLogMessage message) {
        if (message == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(3);
        }
        LOG.info("flutter app: " + message.message);
    }

    @Override
    public void onAppStarting(DaemonEvent.AppStarting event) {
        this.app.setAppId(event.appId);
        this.app.setLaunchMode(event.launchMode);
    }

    @Override
    public void onAppDebugPort(@NotNull DaemonEvent.AppDebugPort debugInfo) {
        String uri;
        if (debugInfo == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(4);
        }
        this.app.setWsUrl(debugInfo.wsUri);
        ConsoleView console = this.app.getConsole();
        if (console != null) {
            console.print("Debug service listening on " + debugInfo.wsUri + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        if ((uri = debugInfo.baseUri) != null) {
            if (uri.startsWith("file:")) {
                try {
                    uri = new URL(uri).getPath();
                    if (uri.endsWith(File.separator)) {
                        uri = uri.substring(0, uri.length() - 1);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.app.setBaseUri(uri);
        }
    }

    @Override
    public void onAppStarted(DaemonEvent.AppStarted started) {
        this.app.changeState(FlutterApp.State.STARTED);
    }

    @Override
    public void onAppLog(@NotNull DaemonEvent.AppLog message) {
        ConsoleView console;
        if (message == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(5);
        }
        if ((console = this.app.getConsole()) == null) {
            return;
        }
        console.print(message.log + "\n", message.error ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
    }

    @Override
    public void onAppProgressStarting(@NotNull DaemonEvent.AppProgress event) {
        if (event == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(6);
        }
        this.progress.start(event.message);
        if (event.getType().startsWith("hot.")) {
            if (this.app.getConsole() != null && !FlutterSettings.getInstance().isVerboseLogging() && !FlutterSettings.getInstance().isPerserveLogsDuringHotReloadAndRestart()) {
                this.app.getConsole().clear();
            }
            this.stopwatch.set(Stopwatch.createStarted());
        }
        if (this.app.getConsole() != null) {
            this.app.getConsole().print(event.message + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    @Override
    public void onAppProgressFinished(@NotNull DaemonEvent.AppProgress event) {
        if (event == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(7);
        }
        this.progress.done();
        Stopwatch watch = this.stopwatch.getAndSet(null);
        if (watch != null) {
            watch.stop();
            switch (event.getType()) {
                case "hot.reload": {
                    this.reportElapsed(watch, "Reloaded", "reload");
                    break;
                }
                case "hot.restart": {
                    this.reportElapsed(watch, "Restarted", "restart");
                }
            }
        }
    }

    private void reportElapsed(@NotNull Stopwatch watch, String verb, String analyticsName) {
        if (watch == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(8);
        }
        long elapsedMs = watch.elapsed(TimeUnit.MILLISECONDS);
        FlutterInitializer.getAnalytics().sendTiming("run", analyticsName, elapsedMs);
    }

    @Override
    public void onAppStopped(@NotNull DaemonEvent.AppStopped stopped) {
        if (stopped == null) {
            FlutterAppDaemonEventListener.$$$reportNull$$$0(9);
        }
        if (stopped.error != null && this.app.getConsole() != null) {
            this.app.getConsole().print("Finished with error: " + stopped.error + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        this.progress.cancel();
        this.app.getProcessHandler().destroyProcess();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopped";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/daemon/FlutterAppDaemonEventListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onDaemonLog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onDaemonLogMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onAppDebugPort";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onAppLog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onAppProgressStarting";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onAppProgressFinished";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "reportElapsed";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "onAppStopped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

