/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.test.DartTestEventsConverterZ;
import java.text.ParseException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterTestEventsConverter
extends DartTestEventsConverterZ {
    public static final String SYNTHETIC_WIDGET_GROUP_NAME = "-";

    public FlutterTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull DartUrlResolver urlResolver) {
        if (testFrameworkName == null) {
            FlutterTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            FlutterTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (urlResolver == null) {
            FlutterTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties, urlResolver);
    }

    private static boolean isSyntheticWidgetTestGroup(@Nullable DartTestEventsConverterZ.Item item) {
        return item instanceof DartTestEventsConverterZ.Group && Objects.equals(item.getUrl(), "package:flutter_test/src/widget_tester.dart") && FlutterTestEventsConverter.isSyntheticWidgetGroupName(item.getName());
    }

    private static boolean isSyntheticWidgetGroupName(@Nullable String name) {
        return name != null && name.endsWith(SYNTHETIC_WIDGET_GROUP_NAME);
    }

    @Nullable
    private static JsonElement getValue(@NotNull JsonElement element, @NotNull String member) {
        if (element == null) {
            FlutterTestEventsConverter.$$$reportNull$$$0(3);
        }
        if (member == null) {
            FlutterTestEventsConverter.$$$reportNull$$$0(4);
        }
        if (!(element instanceof JsonObject)) {
            return null;
        }
        JsonObject object = (JsonObject)element;
        return object.has(member) ? object.get(member) : null;
    }

    @Override
    protected boolean process(@NotNull JsonArray array) {
        JsonElement uri;
        JsonElement params;
        JsonElement element;
        JsonElement event;
        if (array == null) {
            FlutterTestEventsConverter.$$$reportNull$$$0(5);
        }
        return array.size() == 1 && (event = FlutterTestEventsConverter.getValue(element = array.get(0), "event")) != null && Objects.equals(event.getAsString(), "test.startedProcess") && (params = FlutterTestEventsConverter.getValue(element, "params")) != null && (uri = FlutterTestEventsConverter.getValue(params, "observatoryUri")) != null;
    }

    @Override
    protected void preprocessTestStart(@NotNull DartTestEventsConverterZ.Test test) {
        if (test == null) {
            FlutterTestEventsConverter.$$$reportNull$$$0(6);
        }
        DartTestEventsConverterZ.Item item = test;
        while (item != null) {
            if (FlutterTestEventsConverter.isSyntheticWidgetTestGroup(item.myParent)) {
                item.myParent = item.myParent.myParent;
                item.myUrl = item.getSuite().myUrl;
                int groupNameIndex = item.myName.lastIndexOf(SYNTHETIC_WIDGET_GROUP_NAME);
                if (groupNameIndex != -1) {
                    StringBuilder sb = new StringBuilder(item.myName);
                    sb.replace(groupNameIndex, groupNameIndex + SYNTHETIC_WIDGET_GROUP_NAME.length() + 1, "");
                    item.myName = sb.toString();
                }
            }
            item = item.myParent;
        }
    }

    @Override
    protected boolean handleGroup(@NotNull DartTestEventsConverterZ.Group group) throws ParseException {
        if (group == null) {
            FlutterTestEventsConverter.$$$reportNull$$$0(7);
        }
        return FlutterTestEventsConverter.isSyntheticWidgetTestGroup(group) || super.handleGroup(group);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/test/FlutterTestEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessTestStart";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

