/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.FlutterUtils;
import io.flutter.ObservatoryConnector;
import io.flutter.run.FlutterPositionMapper;
import io.flutter.run.common.CommonTestConfigUtils;
import io.flutter.run.test.TestConfig;
import io.flutter.run.test.TestDebugProcess;
import io.flutter.run.test.TestFields;
import io.flutter.run.test.TestLaunchState;
import io.flutter.sdk.FlutterSdk;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.JsonUtils;
import io.flutter.utils.StdoutJsonParser;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.VmServiceConsumers;
import java.io.IOException;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.VM;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterTestRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance(FlutterTestRunner.class);

    @NotNull
    public String getRunnerId() {
        return "FlutterDebugTestRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            FlutterTestRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            FlutterTestRunner.$$$reportNull$$$0(1);
        }
        if (!"Debug".equals(executorId) && !"Run".equals(executorId) || !(profile instanceof TestConfig)) {
            return false;
        }
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(((TestConfig)profile).getProject());
        if (sdk == null || !sdk.getVersion().flutterTestSupportsMachineMode()) {
            return false;
        }
        TestConfig config = (TestConfig)profile;
        return config.getFields().getScope() != TestFields.Scope.DIRECTORY;
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            FlutterTestRunner.$$$reportNull$$$0(2);
        }
        if (env == null) {
            FlutterTestRunner.$$$reportNull$$$0(3);
        }
        if (env.getExecutor().getId().equals("Run")) {
            return this.run((TestLaunchState)state, env);
        }
        return this.runInDebugger((TestLaunchState)state, env);
    }

    protected RunContentDescriptor run(final @NotNull TestLaunchState launcher, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (launcher == null) {
            FlutterTestRunner.$$$reportNull$$$0(4);
        }
        if (env == null) {
            FlutterTestRunner.$$$reportNull$$$0(5);
        }
        ExecutionResult executionResult = launcher.execute(env.getExecutor(), (ProgramRunner)this);
        Connector connector = new Connector(executionResult.getProcessHandler());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            VmService vmService;
            String url = connector.getWebSocketUrl();
            while (url == null) {
                if (launcher.isTerminated()) {
                    return;
                }
                TimeoutUtil.sleep((long)100L);
                url = connector.getWebSocketUrl();
            }
            if (launcher.isTerminated()) {
                return;
            }
            try {
                vmService = VmService.connect(url);
            }
            catch (IOException | RuntimeException e) {
                if (!launcher.isTerminated()) {
                    launcher.notifyTextAvailable("Failed to connect to the VM service at: " + url + "\n" + String.valueOf(e) + "\n", ProcessOutputTypes.STDERR);
                }
                return;
            }
            vmService.streamListen("Debug", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
            vmService.addVmServiceListener(new VmServiceListenerAdapter(){

                @Override
                public void received(String streamId, Event event) {
                    if (EventKind.PauseStart.equals((Object)event.getKind())) {
                        FlutterTestRunner.this.resumePausedAtStartIsolate(launcher, vmService, event.getIsolate());
                    }
                }
            });
            vmService.getVM(new VMConsumer(){

                @Override
                public void received(VM response) {
                    ElementList<IsolateRef> isolates = response.getIsolates();
                    for (IsolateRef isolateRef : isolates) {
                        FlutterTestRunner.this.resumePausedAtStartIsolate(launcher, vmService, isolateRef);
                    }
                }

                @Override
                public void onError(RPCError error) {
                    if (!launcher.isTerminated()) {
                        launcher.notifyTextAvailable("Error connecting to VM: " + error.getCode() + " " + error.getMessage() + "\n", ProcessOutputTypes.STDERR);
                    }
                }
            });
        });
        return new RunContentBuilder(executionResult, env).showRunContent(env.getContentToReuse());
    }

    private void resumePausedAtStartIsolate(final @NotNull TestLaunchState launcher, final @NotNull VmService vmService, final @NotNull IsolateRef isolateRef) {
        if (launcher == null) {
            FlutterTestRunner.$$$reportNull$$$0(6);
        }
        if (vmService == null) {
            FlutterTestRunner.$$$reportNull$$$0(7);
        }
        if (isolateRef == null) {
            FlutterTestRunner.$$$reportNull$$$0(8);
        }
        if (isolateRef.getIsSystemIsolate()) {
            return;
        }
        vmService.getIsolate(isolateRef.getId(), new VmServiceConsumers.GetIsolateConsumerWrapper(){

            @Override
            public void received(Isolate isolate) {
                Event event = isolate.getPauseEvent();
                EventKind eventKind = event.getKind();
                if (eventKind == EventKind.PauseStart) {
                    vmService.resume(isolateRef.getId(), new VmServiceConsumers.EmptyResumeConsumer(){

                        @Override
                        public void onError(RPCError error) {
                            if (!launcher.isTerminated()) {
                                launcher.notifyTextAvailable("Error resuming isolate " + isolateRef.getId() + ": " + error.getCode() + " " + error.getMessage() + "\n", ProcessOutputTypes.STDERR);
                            }
                        }
                    });
                }
            }
        });
    }

    protected RunContentDescriptor runInDebugger(@NotNull TestLaunchState launcher, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (launcher == null) {
            FlutterTestRunner.$$$reportNull$$$0(9);
        }
        if (env == null) {
            FlutterTestRunner.$$$reportNull$$$0(10);
        }
        final ExecutionResult executionResult = launcher.execute(env.getExecutor(), (ProgramRunner)this);
        final Connector connector = new Connector(executionResult.getProcessHandler());
        final DartUrlResolver resolver = DartUrlResolver.getInstance((Project)env.getProject(), (VirtualFile)launcher.getTestFileOrDir());
        FlutterPositionMapper.Analyzer analyzer = FlutterPositionMapper.Analyzer.create(env.getProject(), launcher.getTestFileOrDir());
        final FlutterPositionMapper mapper = new FlutterPositionMapper(env.getProject(), launcher.getPubRoot().getRoot(), resolver, analyzer);
        XDebuggerManager manager = XDebuggerManager.getInstance((Project)env.getProject());
        XDebugSession session = manager.startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    4.$$$reportNull$$$0(0);
                }
                return new TestDebugProcess(env, session, executionResult, resolver, connector, mapper);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "io/flutter/run/test/FlutterTestRunner$4", "start"));
            }
        });
        return session.getRunContentDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolateRef";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/test/FlutterTestRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resumePausedAtStartIsolate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "runInDebugger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Connector
    implements ObservatoryConnector {
        private final StdoutJsonParser stdoutParser = new StdoutJsonParser();
        private final ProcessListener listener;
        private String observatoryUri;

        public Connector(final ProcessHandler handler) {
            this.listener = new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!outputType.equals((Object)ProcessOutputTypes.STDOUT)) {
                        return;
                    }
                    String text = event.getText();
                    if (FlutterSettings.getInstance().isVerboseLogging()) {
                        LOG.info("[<-- " + text.trim() + "]");
                    }
                    stdoutParser.appendOutput(text);
                    for (String line : stdoutParser.getAvailableLines()) {
                        if (!line.startsWith("[{")) continue;
                        line = line.trim();
                        String json = line.substring(1, line.length() - 1);
                        this.dispatchJson(json);
                    }
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    handler.removeProcessListener(listener);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "io/flutter/run/test/FlutterTestRunner$Connector$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            handler.addProcessListener(this.listener);
        }

        @Override
        @Nullable
        public String getWebSocketUrl() {
            if (this.observatoryUri == null || !this.observatoryUri.startsWith("http:")) {
                return null;
            }
            return CommonTestConfigUtils.convertHttpServiceProtocolToWs(this.observatoryUri);
        }

        @Override
        @Nullable
        public String getBrowserUrl() {
            return this.observatoryUri;
        }

        @Override
        @Nullable
        public String getRemoteBaseUrl() {
            return null;
        }

        @Override
        public void onDebuggerPaused(@NotNull Runnable resume) {
            if (resume == null) {
                Connector.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void onDebuggerResumed() {
        }

        private void dispatchJson(String json) {
            JsonPrimitive primUri;
            JsonObject obj;
            try {
                JsonElement elem = JsonUtils.parseString(json);
                obj = elem.getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                FlutterUtils.warn(LOG, "Unable to parse JSON from Flutter test", e);
                return;
            }
            JsonPrimitive primId = obj.getAsJsonPrimitive("id");
            if (primId != null) {
                LOG.info("Ignored JSON from Flutter test: " + json);
                return;
            }
            JsonPrimitive primEvent = obj.getAsJsonPrimitive("event");
            if (primEvent == null) {
                FlutterUtils.warn(LOG, "Missing event field in JSON from Flutter test: " + String.valueOf(obj));
                return;
            }
            String eventName = primEvent.getAsString();
            if (eventName == null) {
                FlutterUtils.warn(LOG, "Unexpected event field in JSON from Flutter test: " + String.valueOf(obj));
                return;
            }
            JsonObject params = obj.getAsJsonObject("params");
            if (params == null) {
                FlutterUtils.warn(LOG, "Missing parameters in event from Flutter test: " + String.valueOf(obj));
                return;
            }
            if (eventName.equals("test.startedProcess") && (primUri = params.getAsJsonPrimitive("observatoryUri")) != null) {
                this.observatoryUri = primUri.getAsString();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resume", "io/flutter/run/test/FlutterTestRunner$Connector", "onDebuggerPaused"));
        }
    }
}

