/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.ide.runner.server.ui.DartCommandLineConfigurationEditorForm;
import io.flutter.run.test.TestConfig;
import io.flutter.run.test.TestFields;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class TestForm
extends SettingsEditor<TestConfig> {
    private JPanel form;
    private JComboBox<TestFields.Scope> scope;
    private JLabel testDirLabel;
    private TextFieldWithBrowseButton testDir;
    private JLabel testDirHintLabel;
    private JLabel testFileLabel;
    private TextFieldWithBrowseButton testFile;
    private JLabel testFileHintLabel;
    private JLabel testNameLabel;
    private JTextField testName;
    private JLabel testNameHintLabel;
    private ExpandableTextField additionalArgs;
    private TestFields.Scope displayedScope;

    TestForm(@NotNull Project project) {
        if (project == null) {
            TestForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.scope.setModel(new DefaultComboBoxModel<TestFields.Scope>(new TestFields.Scope[]{TestFields.Scope.DIRECTORY, TestFields.Scope.FILE, TestFields.Scope.NAME}));
        this.scope.addActionListener(e -> {
            TestFields.Scope next = this.getScope();
            this.updateFields(next);
            this.render(next);
        });
        this.scope.setRenderer((ListCellRenderer<TestFields.Scope>)new ListCellRendererWrapper<TestFields.Scope>(){

            public void customize(JList list, TestFields.Scope value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        DartCommandLineConfigurationEditorForm.initDartFileTextWithBrowse((Project)project, (TextFieldWithBrowseButton)this.testFile);
        this.testDir.addBrowseFolderListener("Test Directory", null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.form;
        if (jPanel == null) {
            TestForm.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void resetEditorFrom(@NotNull TestConfig config) {
        if (config == null) {
            TestForm.$$$reportNull$$$0(2);
        }
        TestFields fields = config.getFields();
        TestFields.Scope next = fields.getScope();
        this.scope.setSelectedItem((Object)next);
        switch (next) {
            case NAME: {
                this.testName.setText(fields.getTestName());
            }
            case FILE: {
                this.testFile.setText(fields.getTestFile());
                break;
            }
            case DIRECTORY: {
                this.testDir.setText(fields.getTestDir());
            }
        }
        this.additionalArgs.setText(fields.getAdditionalArgs());
        this.render(next);
    }

    protected void applyEditorTo(@NotNull TestConfig config) throws ConfigurationException {
        if (config == null) {
            TestForm.$$$reportNull$$$0(3);
        }
        TestFields fields = switch (this.getScope()) {
            case TestFields.Scope.NAME -> TestFields.forTestName(this.testName.getText(), this.testFile.getText());
            case TestFields.Scope.FILE -> TestFields.forFile(this.testFile.getText());
            case TestFields.Scope.DIRECTORY -> TestFields.forDir(this.testDir.getText());
            default -> throw new ConfigurationException("unexpected scope: " + String.valueOf(this.scope.getSelectedItem()));
        };
        fields.setAdditionalArgs(this.additionalArgs.getText().trim());
        config.setFields(fields);
    }

    @NotNull
    private TestFields.Scope getScope() {
        Object item = this.scope.getSelectedItem();
        assert (item != null);
        TestFields.Scope scope = (TestFields.Scope)((Object)item);
        if (scope == null) {
            TestForm.$$$reportNull$$$0(4);
        }
        return scope;
    }

    private void updateFields(TestFields.Scope next) {
        if (next == TestFields.Scope.DIRECTORY && this.displayedScope != TestFields.Scope.DIRECTORY) {
            String sep = String.valueOf(File.separatorChar);
            String path = this.testFile.getText();
            if (path.contains(sep) && path.endsWith(".dart")) {
                this.testDir.setText(path.substring(0, path.lastIndexOf(sep) + 1));
            } else if (this.testDir.getText().isEmpty()) {
                this.testDir.setText(path);
            }
        } else if (next != TestFields.Scope.DIRECTORY && this.displayedScope == TestFields.Scope.DIRECTORY && this.testFile.getText().isEmpty()) {
            this.testFile.setText(this.testDir.getText());
        }
    }

    private void render(TestFields.Scope next) {
        this.testDirLabel.setVisible(next == TestFields.Scope.DIRECTORY);
        this.testDirHintLabel.setVisible(next == TestFields.Scope.DIRECTORY);
        this.testDir.setVisible(next == TestFields.Scope.DIRECTORY);
        this.testFileLabel.setVisible(next != TestFields.Scope.DIRECTORY);
        this.testFileHintLabel.setVisible(next != TestFields.Scope.DIRECTORY);
        this.testFile.setVisible(next != TestFields.Scope.DIRECTORY);
        this.testNameLabel.setVisible(next == TestFields.Scope.NAME);
        this.testNameHintLabel.setVisible(next == TestFields.Scope.NAME);
        this.testName.setVisible(next == TestFields.Scope.NAME);
        this.displayedScope = next;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ExpandableTextField expandableTextField;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JTextField jTextField;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel5;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.form = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.testFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.testFileLabel = jLabel6 = new JLabel();
        jLabel6.setText("Test file:");
        jLabel6.setDisplayedMnemonic('F');
        jLabel6.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.scope = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Test scope:");
        jLabel7.setDisplayedMnemonic('S');
        jLabel7.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(110, -1), null));
        this.testDirLabel = jLabel5 = new JLabel();
        jLabel5.setText("Test directory:");
        jLabel5.setDisplayedMnemonic('D');
        jLabel5.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.testDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.testNameLabel = jLabel4 = new JLabel();
        jLabel4.setText("Test name:");
        jLabel4.setDisplayedMnemonic('N');
        jLabel4.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.testName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        ((Component)jLabel8).setEnabled(false);
        jLabel8.setText("Scope of the test: either file, directory, or tests in a file and filtered by name.");
        jPanel.add((Component)jLabel8, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.testFileHintLabel = jLabel3 = new JLabel();
        ((Component)jLabel3).setEnabled(false);
        jLabel3.setText("The entry-point for the test (e.g. 'test/simple_test.dart').");
        jPanel.add((Component)jLabel3, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.testDirHintLabel = jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(false);
        jLabel2.setText("The directory scoping the run tests (e.g. '/.../test/').");
        jPanel.add((Component)jLabel2, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.testNameHintLabel = jLabel = new JLabel();
        ((Component)jLabel).setEnabled(false);
        jLabel.setText("Some pattern to match test names by.");
        jPanel.add((Component)jLabel, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Additional args:");
        jPanel.add((Component)jLabel9, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.additionalArgs = expandableTextField = new ExpandableTextField();
        jPanel.add((Component)expandableTextField, new GridConstraints(8, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel10 = new JLabel();
        ((Component)jLabel10).setEnabled(false);
        jLabel10.setText("Additional arguments to pass to the test runner.");
        jPanel.add((Component)jLabel10, new GridConstraints(9, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel7.setLabelFor(jComboBox);
        jLabel4.setLabelFor(jTextField);
        jLabel9.setLabelFor((Component)expandableTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.form;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/test/TestForm";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/test/TestForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

