/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.test;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.DartRelativePathsConsoleFilter;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.FlutterBundle;
import io.flutter.pub.PubRoot;
import io.flutter.run.common.ConsoleProps;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.DaemonConsoleView;
import io.flutter.run.test.TestConfig;
import io.flutter.run.test.TestFields;
import io.flutter.sdk.FlutterCommandStartResult;
import io.flutter.sdk.FlutterSdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TestLaunchState
extends CommandLineState {
    @NotNull
    private final TestConfig config;
    @NotNull
    private final TestFields fields;
    @NotNull
    private final VirtualFile testFileOrDir;
    @NotNull
    private final PubRoot pubRoot;
    private final boolean testConsoleEnabled;
    private ProcessHandler processHandler;

    private TestLaunchState(@NotNull ExecutionEnvironment env, @NotNull TestConfig config, @NotNull VirtualFile testFileOrDir, @NotNull PubRoot pubRoot, boolean testConsoleEnabled) {
        if (env == null) {
            TestLaunchState.$$$reportNull$$$0(0);
        }
        if (config == null) {
            TestLaunchState.$$$reportNull$$$0(1);
        }
        if (testFileOrDir == null) {
            TestLaunchState.$$$reportNull$$$0(2);
        }
        if (pubRoot == null) {
            TestLaunchState.$$$reportNull$$$0(3);
        }
        super(env);
        this.config = config;
        this.fields = config.getFields();
        this.testFileOrDir = testFileOrDir;
        this.pubRoot = pubRoot;
        this.testConsoleEnabled = testConsoleEnabled;
    }

    static TestLaunchState create(@NotNull ExecutionEnvironment env, @NotNull TestConfig config) throws ExecutionException {
        if (env == null) {
            TestLaunchState.$$$reportNull$$$0(4);
        }
        if (config == null) {
            TestLaunchState.$$$reportNull$$$0(5);
        }
        TestFields fields = config.getFields();
        try {
            fields.checkRunnable(env.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile fileOrDir = fields.getFileOrDir();
        assert (fileOrDir != null);
        PubRoot pubRoot = fields.getPubRoot(env.getProject());
        assert (pubRoot != null);
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(env.getProject());
        assert (sdk != null);
        boolean testConsoleEnabled = sdk.getVersion().flutterTestSupportsMachineMode();
        TestLaunchState launcher = new TestLaunchState(env, config, fileOrDir, pubRoot, testConsoleEnabled);
        DaemonConsoleView.install(launcher, env, pubRoot.getRoot());
        return launcher;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        RunMode mode = RunMode.fromEnv(this.getEnvironment());
        FlutterCommandStartResult result = this.fields.run(this.getEnvironment().getProject(), mode);
        switch (result.status) {
            case OK: {
                assert (result.processHandler != null);
                this.processHandler = result.processHandler;
                ColoredProcessHandler coloredProcessHandler = result.processHandler;
                if (coloredProcessHandler == null) {
                    TestLaunchState.$$$reportNull$$$0(6);
                }
                return coloredProcessHandler;
            }
            case EXCEPTION: {
                assert (result.exception != null);
                throw new ExecutionException(FlutterBundle.message("flutter.command.exception.message" + result.exception.getMessage(), new Object[0]));
            }
        }
        throw new ExecutionException("Unexpected state");
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            TestLaunchState.$$$reportNull$$$0(7);
        }
        if (!this.testConsoleEnabled) {
            return super.createConsole(executor);
        }
        Project project = this.getEnvironment().getProject();
        DartUrlResolver resolver = DartUrlResolver.getInstance((Project)project, (VirtualFile)this.testFileOrDir);
        ConsoleProps props = ConsoleProps.forPub(this.config, executor, resolver);
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole((String)ConsoleProps.pubFrameworkName, (TestConsoleProperties)props);
        Module module = ModuleUtil.findModuleForFile((VirtualFile)this.testFileOrDir, (Project)project);
        console.addMessageFilter((Filter)new DartConsoleFilter(project, this.getTestFileOrDir()));
        String baseDir = this.getBaseDir();
        if (baseDir != null) {
            console.addMessageFilter((Filter)new DartRelativePathsConsoleFilter(project, baseDir));
        }
        console.addMessageFilter((Filter)new UrlFilter());
        return console;
    }

    @Nullable
    private String getBaseDir() {
        PubRoot root = this.config.getFields().getPubRoot(this.config.getProject());
        if (root != null) {
            return root.getPath();
        }
        VirtualFile baseDir = this.config.getProject().getBaseDir();
        return baseDir == null ? null : baseDir.getPath();
    }

    @NotNull
    VirtualFile getTestFileOrDir() {
        VirtualFile virtualFile = this.testFileOrDir;
        if (virtualFile == null) {
            TestLaunchState.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @NotNull
    PubRoot getPubRoot() {
        PubRoot pubRoot = this.pubRoot;
        if (pubRoot == null) {
            TestLaunchState.$$$reportNull$$$0(9);
        }
        return pubRoot;
    }

    public boolean isTerminated() {
        return this.processHandler != null && this.processHandler.isProcessTerminated();
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
        if (text == null) {
            TestLaunchState.$$$reportNull$$$0(10);
        }
        if (outputType == null) {
            TestLaunchState.$$$reportNull$$$0(11);
        }
        if (this.processHandler != null) {
            this.processHandler.notifyTextAvailable(text, outputType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFileOrDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubRoot";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/test/TestLaunchState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/test/TestLaunchState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFileOrDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPubRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyTextAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

