/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.samples;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.psi.DartComponent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartDocumentUtils {
    private DartDocumentUtils() {
    }

    @NotNull
    public static List<String> getDartdocFor(@NotNull Document document, @NotNull DartComponent component) {
        String text;
        int line;
        if (document == null) {
            DartDocumentUtils.$$$reportNull$$$0(0);
        }
        if (component == null) {
            DartDocumentUtils.$$$reportNull$$$0(1);
        }
        ArrayList<String> lines = new ArrayList<String>();
        int startLine = document.getLineNumber(component.getTextOffset());
        for (line = startLine - 1; line >= 0; --line) {
            text = StringUtil.trimLeading((String)DartDocumentUtils.getLine(document, line));
            if (text.isEmpty() || text.startsWith("@")) {
                continue;
            }
            if (text.startsWith("///")) {
                lines.add(text);
                --line;
                break;
            }
            ArrayList<String> arrayList = lines;
            if (arrayList == null) {
                DartDocumentUtils.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        while (line >= 0 && (text = StringUtil.trimLeading((String)DartDocumentUtils.getLine(document, line))).startsWith("///")) {
            lines.add(0, text);
            --line;
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            DartDocumentUtils.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static String getLine(Document document, int line) {
        return document.getText(new TextRange(document.getLineStartOffset(line - 1), document.getLineEndOffset(line - 1)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/samples/DartDocumentUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/samples/DartDocumentUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDartdocFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDartdocFor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

