/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.samples;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import io.flutter.samples.DartDocumentUtils;
import io.flutter.samples.FlutterSample;
import io.flutter.samples.FlutterSampleActionsPanel;
import io.flutter.sdk.FlutterSdk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSampleNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"flutter.sample");
    @NotNull
    final Project project;
    private static final Pattern DARTPAD_TOOL_PATTERN = Pattern.compile("\\{@tool.*\\sdartpad.*}");

    public FlutterSampleNotificationProvider(@NotNull Project project) {
        if (project == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(4);
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
        if (sdk == null) {
            return null;
        }
        String flutterPackagePath = sdk.getHomePath() + "/packages/flutter/lib/src/";
        String filePath = file.getPath();
        if (!filePath.startsWith(flutterPackagePath)) {
            return null;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null || !psiFile.isValid()) {
            return null;
        }
        List samples = (List)ApplicationManager.getApplication().runReadAction(() -> this.getSamplesFromDoc(flutterPackagePath, document, filePath));
        return samples.isEmpty() ? null : new FlutterSampleActionsPanel(samples);
    }

    private List<FlutterSample> getSamplesFromDoc(String flutterPackagePath, Document document, String filePath) {
        ArrayList<FlutterSample> samples = new ArrayList<FlutterSample>();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(document);
        assert (psiFile != null);
        DartClass[] classes = (DartClass[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, DartClass.class);
        if (classes == null) {
            return Collections.emptyList();
        }
        for (DartClass declaration : classes) {
            List<String> dartdoc;
            String name = declaration.getName();
            if (name == null || name.startsWith("_") || !FlutterSampleNotificationProvider.containsDartdocFlutterSample(dartdoc = DartDocumentUtils.getDartdocFor(document, (DartComponent)declaration))) continue;
            assert (declaration.getName() != null);
            String libraryName = filePath.substring(flutterPackagePath.length());
            int index = libraryName.indexOf(47);
            if (index == -1) continue;
            libraryName = libraryName.substring(0, index);
            FlutterSample sample = new FlutterSample(libraryName, declaration.getName());
            samples.add(sample);
        }
        return samples;
    }

    @VisibleForTesting
    public static boolean containsDartdocFlutterSample(@NotNull List<String> lines) {
        if (lines == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(5);
        }
        if (lines.isEmpty()) {
            return false;
        }
        for (String line : lines) {
            if (!DARTPAD_TOOL_PATTERN.matcher(line).find()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/samples/FlutterSampleNotificationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/samples/FlutterSampleNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsDartdocFlutterSample";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

