/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.flutter.FlutterUtils;
import io.flutter.android.AndroidEmulator;
import io.flutter.android.AndroidSdk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class AndroidEmulatorManager {
    private static final Logger LOG = Logger.getInstance(AndroidEmulatorManager.class);
    @NotNull
    private final Project project;
    private final AtomicReference<ImmutableSet<Runnable>> listeners;
    private List<AndroidEmulator> cachedEmulators;
    private CompletableFuture<List<AndroidEmulator>> inProgressRefresh;

    @NotNull
    public static AndroidEmulatorManager getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidEmulatorManager.$$$reportNull$$$0(0);
        }
        AndroidEmulatorManager androidEmulatorManager = Objects.requireNonNull((AndroidEmulatorManager)project.getService(AndroidEmulatorManager.class));
        if (androidEmulatorManager == null) {
            AndroidEmulatorManager.$$$reportNull$$$0(1);
        }
        return androidEmulatorManager;
    }

    private AndroidEmulatorManager(@NotNull Project project) {
        if (project == null) {
            AndroidEmulatorManager.$$$reportNull$$$0(2);
        }
        this.listeners = new AtomicReference<ImmutableSet>(ImmutableSet.of());
        this.cachedEmulators = new ArrayList<AndroidEmulator>();
        this.project = project;
    }

    public void addListener(@NotNull Runnable callback) {
        if (callback == null) {
            AndroidEmulatorManager.$$$reportNull$$$0(3);
        }
        this.listeners.updateAndGet(old -> {
            ArrayList<Runnable> changed = new ArrayList<Runnable>((Collection<Runnable>)old);
            changed.add(callback);
            return ImmutableSet.copyOf(changed);
        });
    }

    public void removeListener(@NotNull Runnable callback) {
        if (callback == null) {
            AndroidEmulatorManager.$$$reportNull$$$0(4);
        }
        this.listeners.updateAndGet(old -> {
            ArrayList changed = new ArrayList(old);
            changed.remove(callback);
            return ImmutableSet.copyOf(changed);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<AndroidEmulator>> refresh() {
        AndroidEmulatorManager androidEmulatorManager = this;
        synchronized (androidEmulatorManager) {
            if (this.inProgressRefresh != null) {
                return this.inProgressRefresh;
            }
        }
        CompletableFuture<List<AndroidEmulator>> future = new CompletableFuture<List<AndroidEmulator>>();
        AndroidEmulatorManager androidEmulatorManager2 = this;
        synchronized (androidEmulatorManager2) {
            this.inProgressRefresh = future;
        }
        AppExecutorUtil.getAppExecutorService().submit(() -> {
            AndroidSdk sdk = AndroidSdk.createFromProject(this.project);
            if (sdk == null) {
                future.complete(Collections.emptyList());
            } else {
                List<AndroidEmulator> emulators = sdk.getEmulators();
                emulators.sort((emulator1, emulator2) -> emulator1.getName().compareToIgnoreCase(emulator2.getName()));
                future.complete(emulators);
            }
        });
        future.thenAccept(emulators -> {
            this.fireChangeEvent((List<AndroidEmulator>)emulators, this.cachedEmulators);
            AndroidEmulatorManager androidEmulatorManager = this;
            synchronized (androidEmulatorManager) {
                this.inProgressRefresh = null;
            }
        });
        return future;
    }

    public List<AndroidEmulator> getCachedEmulators() {
        return this.cachedEmulators;
    }

    private void fireChangeEvent(List<AndroidEmulator> newEmulators, List<AndroidEmulator> oldEmulators) {
        if (this.project.isDisposed()) {
            return;
        }
        if (this.cachedEmulators.equals(newEmulators)) {
            return;
        }
        this.cachedEmulators = newEmulators;
        for (Runnable listener : this.listeners.get()) {
            try {
                listener.run();
            }
            catch (Exception e) {
                FlutterUtils.warn(LOG, "AndroidEmulatorManager listener threw an exception", e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/AndroidEmulatorManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/AndroidEmulatorManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

