/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterMessages;
import io.flutter.android.IntelliJAndroidSdk;
import io.flutter.console.FlutterConsoles;
import io.flutter.dart.DartPlugin;
import io.flutter.sdk.FlutterCommandStartResult;
import io.flutter.sdk.FlutterCommandStartResultStatus;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.MostlySilentColoredProcessHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterCommand {
    private static final Logger LOG = Logger.getInstance(FlutterCommand.class);
    private static final Set<Type> pubRelatedCommands = new HashSet<Type>(Arrays.asList(Type.PUB_GET, Type.PUB_UPGRADE, Type.PUB_OUTDATED, Type.UPGRADE));
    @NotNull
    protected final FlutterSdk sdk;
    @Nullable
    protected final VirtualFile workDir;
    @NotNull
    private final Type type;
    @NotNull
    protected final List<String> args;

    FlutterCommand(@NotNull FlutterSdk sdk, @Nullable VirtualFile workDir, @NotNull Type type, String ... args) {
        if (sdk == null) {
            FlutterCommand.$$$reportNull$$$0(0);
        }
        if (type == null) {
            FlutterCommand.$$$reportNull$$$0(1);
        }
        this.sdk = sdk;
        this.workDir = workDir;
        this.type = type;
        this.args = ImmutableList.copyOf((Object[])args);
    }

    public String getDisplayCommand() {
        ArrayList<String> words = new ArrayList<String>();
        words.add("flutter");
        words.addAll((Collection<String>)this.type.subCommand);
        words.addAll(this.args);
        return String.join((CharSequence)" ", words);
    }

    protected boolean isPubRelatedCommand() {
        return pubRelatedCommands.contains((Object)this.type);
    }

    public Process start(final @Nullable Consumer<ProcessOutput> onDone, @Nullable ProcessListener processListener) {
        ColoredProcessHandler handler = this.startProcessOrShowError(null);
        if (handler == null) {
            return null;
        }
        if (processListener != null) {
            handler.addProcessListener(processListener);
        }
        if (onDone != null) {
            CapturingProcessAdapter listener = new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.processTerminated(event);
                    onDone.accept(this.getOutput());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/sdk/FlutterCommand$1", "processTerminated"));
                }
            };
            handler.addProcessListener((ProcessListener)listener);
        }
        handler.startNotify();
        return handler.getProcess();
    }

    public ColoredProcessHandler startInConsole(@NotNull Project project) {
        ColoredProcessHandler handler;
        if (project == null) {
            FlutterCommand.$$$reportNull$$$0(2);
        }
        if ((handler = this.startProcessOrShowError(project)) != null) {
            FlutterConsoles.displayProcessLater(handler, project, null, () -> ((ColoredProcessHandler)handler).startNotify());
        }
        return handler;
    }

    public Process startInModuleConsole(@NotNull Module module, final @Nullable Runnable onDone, @Nullable ProcessListener processListener) {
        ColoredProcessHandler handler;
        if (module == null) {
            FlutterCommand.$$$reportNull$$$0(3);
        }
        if ((handler = this.startProcessOrShowError(module.getProject())) == null) {
            return null;
        }
        if (processListener != null) {
            handler.addProcessListener(processListener);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (onDone != null) {
                    onDone.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/sdk/FlutterCommand$2", "processTerminated"));
            }
        });
        FlutterConsoles.displayProcessLater(handler, module.getProject(), module, () -> ((ColoredProcessHandler)handler).startNotify());
        return handler.getProcess();
    }

    public String toString() {
        return "FlutterCommand(" + this.getDisplayCommand() + ")";
    }

    @Nullable
    public ColoredProcessHandler startProcess(boolean sendAnalytics) {
        try {
            GeneralCommandLine commandLine = this.createGeneralCommandLine(null);
            LOG.info(commandLine.toString());
            ColoredProcessHandler handler = new ColoredProcessHandler(commandLine);
            if (sendAnalytics) {
                this.type.sendAnalyticsEvent();
            }
            return handler;
        }
        catch (ExecutionException e) {
            FlutterMessages.showError(this.type.title, FlutterBundle.message("flutter.command.exception.message", e.getMessage()), null);
            return null;
        }
    }

    @NotNull
    public FlutterCommandStartResult startProcess(@Nullable Project project) {
        if (this.isPubRelatedCommand()) {
            DartPlugin.setPubActionInProgress(true);
        }
        try {
            GeneralCommandLine commandLine = this.createGeneralCommandLine(project);
            LOG.info(commandLine.toString());
            MostlySilentColoredProcessHandler handler = new MostlySilentColoredProcessHandler(commandLine);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (FlutterCommand.this.isPubRelatedCommand()) {
                        DartPlugin.setPubActionInProgress(false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/sdk/FlutterCommand$3", "processTerminated"));
                }
            });
            this.type.sendAnalyticsEvent();
            return new FlutterCommandStartResult(handler);
        }
        catch (ExecutionException e) {
            if (this.isPubRelatedCommand()) {
                DartPlugin.setPubActionInProgress(false);
            }
            return new FlutterCommandStartResult(e);
        }
    }

    @Nullable
    public ColoredProcessHandler startProcessOrShowError(@Nullable Project project) {
        FlutterCommandStartResult result = this.startProcess(project);
        if (result.status == FlutterCommandStartResultStatus.EXCEPTION && result.exception != null) {
            FlutterMessages.showError(this.type.title, FlutterBundle.message("flutter.command.exception.message", result.exception.getMessage()), project);
        }
        return result.processHandler;
    }

    @NotNull
    public GeneralCommandLine createGeneralCommandLine(@Nullable Project project) {
        GeneralCommandLine line = new GeneralCommandLine();
        line.setCharset(StandardCharsets.UTF_8);
        line.withEnvironment("FLUTTER_HOST", new FlutterSdkUtil().getFlutterHostEnvValue());
        String androidHome = IntelliJAndroidSdk.chooseAndroidHome(project, false);
        if (androidHome != null) {
            line.withEnvironment("ANDROID_HOME", androidHome);
        }
        line.setExePath(FileUtil.toSystemDependentName((String)(this.sdk.getHomePath() + "/bin/" + FlutterSdkUtil.flutterScriptName())));
        if (this.workDir != null) {
            line.setWorkDirectory(this.workDir.getPath());
        }
        if (!this.isDoctorCommand()) {
            line.addParameter("--no-color");
        }
        line.addParameters(this.type.subCommand);
        line.addParameters(this.args);
        GeneralCommandLine generalCommandLine = line;
        if (generalCommandLine == null) {
            FlutterCommand.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    private boolean isDoctorCommand() {
        return this.type == Type.DOCTOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneralCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startInConsole";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startInModuleConsole";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    static enum Type {
        ATTACH("Flutter attach", "attach"),
        BUILD("Flutter build", "build"),
        CHANNEL("Flutter channel", "channel"),
        CLEAN("Flutter clean", "clean"),
        CONFIG("Flutter config", "config"),
        CREATE("Flutter create", "create"),
        DOCTOR("Flutter doctor", "doctor", "--verbose"),
        PUB_GET("Flutter pub get", "pub", "get"),
        PUB_UPGRADE("Flutter pub upgrade", "pub", "upgrade"),
        PUB_OUTDATED("Flutter pub outdated", "pub", "outdated"),
        PUB("Flutter pub", "pub"),
        RUN("Flutter run", "run"),
        UPGRADE("Flutter upgrade", "upgrade"),
        VERSION("Flutter version", "--version"),
        TEST("Flutter test", "test");

        public final String title;
        final ImmutableList<String> subCommand;

        private Type(String title, String ... subCommand) {
            this.title = title;
            this.subCommand = ImmutableList.copyOf((Object[])subCommand);
        }

        void sendAnalyticsEvent() {
            String action = String.join((CharSequence)"_", this.subCommand).replaceAll("-", "");
            FlutterInitializer.getAnalytics().sendEvent("flutter", action);
        }
    }
}

