/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.openapi.util.text.StringUtil;
import io.flutter.module.FlutterProjectType;
import io.flutter.module.settings.InitializeOnceBoolValueProperty;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterCreateAdditionalSettings {
    @Nullable
    private Boolean includeDriverTest;
    @Nullable
    private FlutterProjectType type;
    @Nullable
    private String description;
    @Nullable
    private String org;
    @Nullable
    private Boolean swift;
    @Nullable
    private Boolean kotlin;
    @Nullable
    private Boolean offlineMode;
    @Nullable
    private String projectName;
    @NotNull
    private final InitializeOnceBoolValueProperty platformAndroid = new InitializeOnceBoolValueProperty();
    @NotNull
    private final InitializeOnceBoolValueProperty platformIos = new InitializeOnceBoolValueProperty();
    @NotNull
    private final InitializeOnceBoolValueProperty platformWeb = new InitializeOnceBoolValueProperty();
    @NotNull
    private final InitializeOnceBoolValueProperty platformLinux = new InitializeOnceBoolValueProperty();
    @NotNull
    private final InitializeOnceBoolValueProperty platformMacos = new InitializeOnceBoolValueProperty();
    @NotNull
    private final InitializeOnceBoolValueProperty platformWindows = new InitializeOnceBoolValueProperty();

    public FlutterCreateAdditionalSettings() {
        this.type = FlutterProjectType.APP;
        this.description = "";
        this.org = "";
    }

    private FlutterCreateAdditionalSettings(@Nullable Boolean includeDriverTest, @Nullable FlutterProjectType type, @Nullable String description, @Nullable String org, @Nullable Boolean swift, @Nullable Boolean kotlin, @Nullable Boolean offlineMode, @Nullable Boolean platformAndroid, @Nullable Boolean platformIos, @Nullable Boolean platformWeb, @Nullable Boolean platformLinux, @Nullable Boolean platformMacos, @Nullable Boolean platformWindows) {
        this.includeDriverTest = includeDriverTest;
        this.type = type;
        this.description = description;
        this.org = org;
        this.swift = swift;
        this.kotlin = kotlin;
        this.offlineMode = offlineMode;
        this.platformAndroid.set(Boolean.TRUE.equals(platformAndroid));
        this.platformIos.set(Boolean.TRUE.equals(platformIos));
        this.platformWeb.set(Boolean.TRUE.equals(platformWeb));
        this.platformLinux.set(Boolean.TRUE.equals(platformLinux));
        this.platformMacos.set(Boolean.TRUE.equals(platformMacos));
        this.platformWindows.set(Boolean.TRUE.equals(platformWindows));
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(@Nullable String projectName) {
        this.projectName = projectName;
    }

    public void setType(@Nullable FlutterProjectType value) {
        this.type = value;
    }

    @Nullable
    public String getOrg() {
        return this.org;
    }

    public void setOrg(@Nullable String value) {
        this.org = value;
    }

    public void setSwift(boolean value) {
        this.swift = value;
    }

    public void setKotlin(boolean value) {
        this.kotlin = value;
    }

    @NonNls
    public List<String> getArgs() {
        int lastComma;
        ArrayList<String> args = new ArrayList<String>();
        if (Boolean.TRUE.equals(this.offlineMode)) {
            args.add("--offline");
        }
        if (Boolean.TRUE.equals(this.includeDriverTest)) {
            args.add("--with-driver-test");
        }
        if (this.type != null) {
            if (this.type != FlutterProjectType.EMPTY_PROJECT) {
                args.add("--template");
            }
            args.add(this.type.arg);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.description)) {
            args.add("--description");
            args.add(this.description);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.org)) {
            args.add("--org");
            args.add(this.org);
        }
        if (this.swift == null || Boolean.FALSE.equals(this.swift)) {
            args.add("--ios-language");
            args.add("objc");
        }
        if (this.kotlin == null || Boolean.FALSE.equals(this.kotlin)) {
            args.add("--android-language");
            args.add("java");
        }
        StringBuilder platforms = new StringBuilder();
        if (this.platformAndroid.get().booleanValue()) {
            platforms.append("android,");
        }
        if (this.platformIos.get().booleanValue()) {
            platforms.append("ios,");
        }
        if (this.platformWeb.get().booleanValue()) {
            platforms.append("web,");
        }
        if (this.platformLinux.get().booleanValue()) {
            platforms.append("linux,");
        }
        if (this.platformMacos.get().booleanValue()) {
            platforms.append("macos,");
        }
        if (this.platformWindows.get().booleanValue()) {
            platforms.append("windows,");
        }
        if (this.type.requiresPlatform && platforms.isEmpty()) {
            platforms.append("android,ios,");
        }
        if ((lastComma = platforms.lastIndexOf(",")) > 0) {
            platforms.deleteCharAt(lastComma);
            String platformsArg = platforms.toString();
            args.add("--platforms");
            args.add(platformsArg);
        }
        return args;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String value) {
        this.description = value;
    }

    @Nullable
    public Boolean getKotlin() {
        return this.kotlin;
    }

    @Nullable
    public Boolean getSwift() {
        return this.swift;
    }

    @Nullable
    public Boolean getPlatformAndroid() {
        return this.platformAndroid.get();
    }

    @Nullable
    public Boolean getPlatformIos() {
        return this.platformIos.get();
    }

    @Nullable
    public Boolean getPlatformWeb() {
        return this.platformWeb.get();
    }

    @Nullable
    public Boolean getPlatformLinux() {
        return this.platformLinux.get();
    }

    @Nullable
    public Boolean getPlatformMacos() {
        return this.platformMacos.get();
    }

    @Nullable
    public Boolean getPlatformWindows() {
        return this.platformWindows.get();
    }

    @Nullable
    public FlutterProjectType getType() {
        return this.type;
    }

    public boolean isSomePlatformSelected() {
        return this.platformAndroid.get() != false || this.platformIos.get() != false || this.platformLinux.get() != false || this.platformMacos.get() != false || this.platformWeb.get() != false || this.platformWindows.get() != false;
    }

    public InitializeOnceBoolValueProperty getPlatformAndroidProperty() {
        return this.platformAndroid;
    }

    public InitializeOnceBoolValueProperty getPlatformIosProperty() {
        return this.platformIos;
    }

    public InitializeOnceBoolValueProperty getPlatformWebProperty() {
        return this.platformWeb;
    }

    public InitializeOnceBoolValueProperty getPlatformLinuxProperty() {
        return this.platformLinux;
    }

    public InitializeOnceBoolValueProperty getPlatformMacosProperty() {
        return this.platformMacos;
    }

    public InitializeOnceBoolValueProperty getPlatformWindowsProperty() {
        return this.platformWindows;
    }

    public static class Builder {
        @Nullable
        private Boolean includeDriverTest;
        @NotNull
        private FlutterProjectType type = FlutterProjectType.APP;
        @Nullable
        private String description;
        @Nullable
        private String org;
        @Nullable
        private Boolean swift;
        @Nullable
        private Boolean kotlin;
        @Nullable
        private Boolean offlineMode;
        @Nullable
        private Boolean platformAndroid;
        @Nullable
        private Boolean platformIos;
        @Nullable
        private Boolean platformWeb;
        @Nullable
        private Boolean platformLinux;
        @Nullable
        private Boolean platformMacos;
        @Nullable
        private Boolean platformWindows;

        public Builder setIncludeDriverTest(@Nullable Boolean includeDriverTest) {
            this.includeDriverTest = includeDriverTest;
            return this;
        }

        public Builder setType(@Nullable FlutterProjectType type) {
            this.type = type;
            return this;
        }

        public Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder setOrg(@Nullable String org) {
            this.org = org;
            return this;
        }

        public Builder setSwift(@Nullable Boolean swift) {
            this.swift = swift;
            return this;
        }

        public Builder setKotlin(@Nullable Boolean kotlin) {
            this.kotlin = kotlin;
            return this;
        }

        public Builder setPlatformAndroid(@Nullable Boolean platformAndroid) {
            this.platformAndroid = platformAndroid;
            return this;
        }

        public Builder setPlatformIos(@Nullable Boolean platformIos) {
            this.platformIos = platformIos;
            return this;
        }

        public Builder setPlatformWeb(@Nullable Boolean platformWeb) {
            this.platformWeb = platformWeb;
            return this;
        }

        public Builder setPlatformLinux(@Nullable Boolean platformLinux) {
            this.platformLinux = platformLinux;
            return this;
        }

        public Builder setPlatformMacos(@Nullable Boolean platformMacos) {
            this.platformMacos = platformMacos;
            return this;
        }

        public Builder setPlatformWindows(@Nullable Boolean platformWindows) {
            this.platformWindows = platformWindows;
            return this;
        }

        public Builder setOffline(@Nullable Boolean offlineMode) {
            this.offlineMode = offlineMode;
            return this;
        }

        public FlutterCreateAdditionalSettings build() {
            return new FlutterCreateAdditionalSettings(this.includeDriverTest, this.type, this.description, this.org, this.swift, this.kotlin, this.offlineMode, this.platformAndroid, this.platformIos, this.platformWeb, this.platformLinux, this.platformMacos, this.platformWindows);
        }
    }
}

