/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ui.EdtInvocationManager;
import com.jetbrains.lang.dart.sdk.DartSdk;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.light.LightGitUtilKt;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.dart.DartPlugin;
import io.flutter.module.FlutterProjectType;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.common.RunMode;
import io.flutter.run.test.TestFields;
import io.flutter.sdk.FlutterCommand;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdkChannel;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.sdk.FlutterSdkVersion;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.JsonUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSdk {
    public static final String FLUTTER_SDK_GLOBAL_LIB_NAME = "Flutter SDK";
    public static final String DART_SDK_SUFFIX = "/bin/cache/dart-sdk";
    public static final String LINUX_DART_SUFFIX = "/google-dartlang";
    public static final String LOCAL_DART_SUFFIX = "/google-dartlang-local";
    public static final String MAC_DART_SUFFIX = "/dart_lang/macos_sdk";
    private static final String DART_CORE_SUFFIX = "/bin/cache/dart-sdk/lib/core";
    private static final Logger LOG = Logger.getInstance(FlutterSdk.class);
    private static final Map<String, FlutterSdk> projectSdkCache = new HashMap<String, FlutterSdk>();
    @NotNull
    private final VirtualFile myHome;
    @NotNull
    private final FlutterSdkVersion myVersion;
    private final Map<String, String> cachedConfigValues;
    @NonNls
    private static final String[] PLATFORMS = new String[]{"enable-android", "enable-ios", "enable-web", "enable-linux-desktop", "enable-macos-desktop", "enable-windows-desktop"};

    private FlutterSdk(@NotNull VirtualFile home, @NotNull FlutterSdkVersion version) {
        if (home == null) {
            FlutterSdk.$$$reportNull$$$0(0);
        }
        if (version == null) {
            FlutterSdk.$$$reportNull$$$0(1);
        }
        this.cachedConfigValues = new HashMap<String, String>();
        this.myHome = home;
        this.myVersion = version;
    }

    public boolean isOlderThanToolsStamp(@NotNull VirtualFile gen) {
        VirtualFile bin;
        if (gen == null) {
            FlutterSdk.$$$reportNull$$$0(2);
        }
        if ((bin = this.myHome.findChild("bin")) == null) {
            return false;
        }
        VirtualFile cache = bin.findChild("cache");
        if (cache == null) {
            return false;
        }
        VirtualFile stamp = cache.findChild("flutter_tools.stamp");
        if (stamp == null) {
            return false;
        }
        try {
            FileTime genFile = Files.getLastModifiedTime(Paths.get(gen.getPath(), new String[0]), new LinkOption[0]);
            FileTime stampFile = Files.getLastModifiedTime(Paths.get(stamp.getPath(), new String[0]), new LinkOption[0]);
            return genFile.compareTo(stampFile) > 0;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Nullable
    public static FlutterSdk getFlutterSdk(@NotNull Project project) {
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return null;
        }
        DartSdk dartSdk = DartPlugin.getDartSdk(project);
        if (dartSdk == null) {
            return null;
        }
        String dartPath = dartSdk.getHomePath();
        if (!dartPath.endsWith(DART_SDK_SUFFIX)) {
            return null;
        }
        String sdkPath = dartPath.substring(0, dartPath.length() - DART_SDK_SUFFIX.length());
        return FlutterSdk.forPath(sdkPath);
    }

    @Nullable
    public static FlutterSdk getIncomplete(@NotNull Project project) {
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            return null;
        }
        Library lib = FlutterSdk.getDartSdkLibrary(project);
        if (lib == null) {
            return null;
        }
        return FlutterSdk.getFlutterFromDartSdkLibrary(lib);
    }

    @Nullable
    public static FlutterSdk forPath(@NotNull String path) {
        VirtualFile home;
        if (path == null) {
            FlutterSdk.$$$reportNull$$$0(5);
        }
        if ((home = LocalFileSystem.getInstance().findFileByPath(path)) == null || !FlutterSdkUtil.isFlutterSdkHome(path)) {
            return null;
        }
        return FlutterSdk.saveSdkInCache(home);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static FlutterSdk saveSdkInCache(VirtualFile home) {
        String cacheKey = home.getCanonicalPath();
        Map<String, FlutterSdk> map = projectSdkCache;
        synchronized (map) {
            if (!projectSdkCache.containsKey(cacheKey)) {
                projectSdkCache.put(cacheKey, new FlutterSdk(home, FlutterSdkVersion.readFromSdk(home)));
            }
        }
        FlutterSdk flutterSdk = projectSdkCache.get(cacheKey);
        if (flutterSdk == null) {
            FlutterSdk.$$$reportNull$$$0(6);
        }
        return flutterSdk;
    }

    @Nullable
    private static Library getDartSdkLibrary(@NotNull Project project) {
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(7);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        for (Library lib : libraryTable.getLibraries()) {
            if (!"Dart SDK".equals(lib.getName())) continue;
            return lib;
        }
        return null;
    }

    @Nullable
    private static FlutterSdk getFlutterFromDartSdkLibrary(Library lib) {
        String[] urls;
        for (String url : urls = lib.getUrls(OrderRootType.CLASSES)) {
            if (!url.endsWith(DART_CORE_SUFFIX)) continue;
            String flutterUrl = url.substring(0, url.length() - DART_CORE_SUFFIX.length());
            VirtualFile home = VirtualFileManager.getInstance().findFileByUrl(flutterUrl);
            return home == null ? null : FlutterSdk.saveSdkInCache(home);
        }
        return null;
    }

    public FlutterCommand flutterVersion() {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.VERSION, new String[0]);
    }

    public FlutterCommand flutterUpgrade() {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.UPGRADE, new String[0]);
    }

    public FlutterCommand flutterClean(@NotNull PubRoot root) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(8);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.CLEAN, new String[0]);
    }

    public FlutterCommand flutterDoctor() {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.DOCTOR, new String[0]);
    }

    @NonNls
    public FlutterCommand flutterCreate(@NotNull VirtualFile appDir, @Nullable FlutterCreateAdditionalSettings additionalSettings) {
        if (appDir == null) {
            FlutterSdk.$$$reportNull$$$0(9);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (additionalSettings != null) {
            String projectName;
            args.addAll(additionalSettings.getArgs());
            if (FlutterProjectType.PLUGIN.equals((Object)additionalSettings.getType()) && this.getVersion().flutterCreateSupportsPlatforms() && !args.contains("--platforms")) {
                args.add("--platforms");
                args.add("android,ios");
            }
            if (this.getVersion().stableChannelSupportsPlatforms() && (projectName = additionalSettings.getProjectName()) != null) {
                args.add("--project-name");
                args.add(projectName);
            }
        }
        args.add(appDir.getName());
        String[] vargs = args.toArray(new String[0]);
        return new FlutterCommand(this, appDir.getParent(), FlutterCommand.Type.CREATE, vargs);
    }

    public FlutterCommand flutterPackagesGet(@NotNull PubRoot root) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(10);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.PUB_GET, new String[0]);
    }

    public FlutterCommand flutterPackagesUpgrade(@NotNull PubRoot root) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(11);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.PUB_UPGRADE, new String[0]);
    }

    public FlutterCommand flutterPackagesOutdated(@NotNull PubRoot root) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(12);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.PUB_OUTDATED, new String[0]);
    }

    public FlutterCommand flutterPub(@Nullable PubRoot root, String ... args) {
        return new FlutterCommand(this, root == null ? null : root.getRoot(), FlutterCommand.Type.PUB, args);
    }

    public FlutterCommand flutterBuild(@NotNull PubRoot root, String ... additionalArgs) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(13);
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.BUILD, additionalArgs);
    }

    public FlutterCommand flutterConfig(String ... additionalArgs) {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.CONFIG, additionalArgs);
    }

    public FlutterCommand flutterChannel() {
        return new FlutterCommand(this, this.getHome(), FlutterCommand.Type.CHANNEL, new String[0]);
    }

    public FlutterCommand flutterRun(@NotNull PubRoot root, @NotNull VirtualFile main, @NotNull FlutterDevice device, @NotNull RunMode mode, @NotNull FlutterLaunchMode flutterLaunchMode, @NotNull Project project, String ... additionalArgs) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(14);
        }
        if (main == null) {
            FlutterSdk.$$$reportNull$$$0(15);
        }
        if (device == null) {
            FlutterSdk.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            FlutterSdk.$$$reportNull$$$0(17);
        }
        if (flutterLaunchMode == null) {
            FlutterSdk.$$$reportNull$$$0(18);
        }
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(19);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("--machine");
        if (FlutterSettings.getInstance().isVerboseLogging()) {
            args.add("--verbose");
        }
        if (flutterLaunchMode == FlutterLaunchMode.DEBUG && this.getVersion().isTrackWidgetCreationRecommended() && Arrays.stream(additionalArgs).noneMatch(s -> s.contains("track-widget-creation"))) {
            args.add("--track-widget-creation");
        }
        args.add("--device-id=" + device.deviceId());
        if (mode == RunMode.DEBUG || mode == RunMode.RUN && !device.deviceId().equals("web-server")) {
            args.add("--start-paused");
        }
        if (flutterLaunchMode == FlutterLaunchMode.PROFILE) {
            args.add("--profile");
        } else if (flutterLaunchMode == FlutterLaunchMode.RELEASE) {
            args.add("--release");
        }
        args.addAll(Arrays.asList(additionalArgs));
        String mainPath = root.getRelativePath(main);
        if (mainPath == null) {
            throw new IllegalArgumentException("main isn't within the pub root: " + main.getPath());
        }
        args.add(FileUtil.toSystemDependentName((String)mainPath));
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.RUN, args.toArray(new String[0]));
    }

    public FlutterCommand flutterAttach(@NotNull PubRoot root, @NotNull VirtualFile main, @Nullable FlutterDevice device, @NotNull FlutterLaunchMode flutterLaunchMode, String ... additionalArgs) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(20);
        }
        if (main == null) {
            FlutterSdk.$$$reportNull$$$0(21);
        }
        if (flutterLaunchMode == null) {
            FlutterSdk.$$$reportNull$$$0(22);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("--machine");
        if (FlutterSettings.getInstance().isVerboseLogging()) {
            args.add("--verbose");
        }
        if (flutterLaunchMode == FlutterLaunchMode.PROFILE) {
            args.add("--profile");
        } else if (flutterLaunchMode == FlutterLaunchMode.RELEASE) {
            args.add("--release");
        }
        if (device != null) {
            args.add("--device-id=" + device.deviceId());
        }
        args.addAll(Arrays.asList(additionalArgs));
        String mainPath = root.getRelativePath(main);
        if (mainPath == null) {
            throw new IllegalArgumentException("main isn't within the pub root: " + main.getPath());
        }
        args.add(FileUtil.toSystemDependentName((String)mainPath));
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.ATTACH, args.toArray(new String[0]));
    }

    public FlutterCommand flutterRunOnTester(@NotNull PubRoot root, @NotNull String mainPath) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(23);
        }
        if (mainPath == null) {
            FlutterSdk.$$$reportNull$$$0(24);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--machine");
        args.add("--device-id=flutter-tester");
        args.add(mainPath);
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.RUN, args.toArray(new String[0]));
    }

    public FlutterCommand flutterTest(@NotNull PubRoot root, @NotNull VirtualFile fileOrDir, @Nullable String testNameSubstring, @NotNull RunMode mode, @Nullable String additionalArgs, TestFields.Scope scope, boolean useRegexp) {
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(25);
        }
        if (fileOrDir == null) {
            FlutterSdk.$$$reportNull$$$0(26);
        }
        if (mode == null) {
            FlutterSdk.$$$reportNull$$$0(27);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        if (this.myVersion.flutterTestSupportsMachineMode()) {
            args.add("--machine");
        }
        if (mode == RunMode.DEBUG && !this.myVersion.flutterTestSupportsMachineMode()) {
            throw new IllegalStateException("Flutter SDK is too old to debug tests");
        }
        if (mode == RunMode.DEBUG || mode == RunMode.RUN && !scope.equals((Object)TestFields.Scope.DIRECTORY)) {
            args.add("--start-paused");
        }
        if (FlutterSettings.getInstance().isVerboseLogging()) {
            args.add("--verbose");
        }
        if (testNameSubstring != null) {
            if (!this.myVersion.flutterTestSupportsFiltering()) {
                throw new IllegalStateException("Flutter SDK is too old to select tests by name");
            }
            if (useRegexp) {
                args.add("--name");
                args.add(StringUtil.escapeToRegexp((String)testNameSubstring) + "(\\s*\\(variant: .*\\))?$");
            } else {
                args.add("--plain-name");
                args.add(testNameSubstring);
            }
        }
        if (additionalArgs != null && !additionalArgs.trim().isEmpty()) {
            args.addAll(Arrays.asList(additionalArgs.trim().split(" ")));
        }
        if (mode == RunMode.COVERAGE && !args.contains("--coverage")) {
            args.add("--coverage");
        }
        if (!root.getRoot().equals(fileOrDir)) {
            String mainPath = root.getRelativePath(fileOrDir);
            if (mainPath == null) {
                throw new IllegalArgumentException("main isn't within the pub root: " + fileOrDir.getPath());
            }
            args.add(FileUtil.toSystemDependentName((String)mainPath));
        }
        return new FlutterCommand(this, root.getRoot(), FlutterCommand.Type.TEST, args.toArray(new String[0]));
    }

    @Nullable
    public PubRoot createFiles(@NotNull VirtualFile baseDir, @Nullable Module module, @Nullable ProcessListener listener, @Nullable FlutterCreateAdditionalSettings additionalSettings) {
        Process process;
        if (baseDir == null) {
            FlutterSdk.$$$reportNull$$$0(28);
        }
        if ((process = module == null ? this.flutterCreate(baseDir, additionalSettings).start(null, listener) : this.flutterCreate(baseDir, additionalSettings).startInModuleConsole(module, null, listener)) == null) {
            return null;
        }
        try {
            if (process.waitFor() != 0) {
                return null;
            }
        }
        catch (InterruptedException e) {
            FlutterUtils.warn(LOG, e);
            return null;
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
        } else {
            baseDir.refresh(false, true);
        }
        return PubRoot.forDirectory(baseDir);
    }

    public Process startPubGet(@NotNull PubRoot root, @NotNull Project project) {
        Module module;
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(29);
        }
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(30);
        }
        if ((module = root.getModule(project)) == null) {
            return null;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.flutterPackagesGet(root).startInModuleConsole(module, root::refresh, null);
    }

    public Process startPubUpgrade(@NotNull PubRoot root, @NotNull Project project) {
        Module module;
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(31);
        }
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(32);
        }
        if ((module = root.getModule(project)) == null) {
            return null;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.flutterPackagesUpgrade(root).startInModuleConsole(module, root::refresh, null);
    }

    public Process startPubOutdated(@NotNull PubRoot root, @NotNull Project project) {
        Module module;
        if (root == null) {
            FlutterSdk.$$$reportNull$$$0(33);
        }
        if (project == null) {
            FlutterSdk.$$$reportNull$$$0(34);
        }
        if ((module = root.getModule(project)) == null) {
            return null;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.flutterPackagesOutdated(root).startInModuleConsole(module, root::refresh, null);
    }

    @NotNull
    public VirtualFile getHome() {
        VirtualFile virtualFile = this.myHome;
        if (virtualFile == null) {
            FlutterSdk.$$$reportNull$$$0(35);
        }
        return virtualFile;
    }

    @NotNull
    public String getHomePath() {
        String string = this.myHome.getPath();
        if (string == null) {
            FlutterSdk.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public FlutterSdkVersion getVersion() {
        FlutterSdkVersion flutterSdkVersion = this.myVersion;
        if (flutterSdkVersion == null) {
            FlutterSdk.$$$reportNull$$$0(37);
        }
        return flutterSdkVersion;
    }

    @Nullable
    public String getDartSdkPath() {
        return FlutterSdkUtil.pathToDartSdk(this.getHomePath());
    }

    @Nullable
    @NonNls
    public FlutterSdkChannel queryFlutterChannel(boolean useCachedValue) {
        String branch;
        String channel;
        if (useCachedValue && (channel = this.cachedConfigValues.get("channel")) != null) {
            return FlutterSdkChannel.fromText(channel);
        }
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(this.getHomePath());
        assert (dir != null);
        try {
            branch = LightGitUtilKt.getLocation((VirtualFile)dir, (GitExecutable)GitExecutableManager.getInstance().getExecutable((Project)null));
        }
        catch (VcsException e) {
            String stdout = this.returnOutputOfQuery(this.flutterChannel());
            branch = stdout == null ? "unknown" : FlutterSdkChannel.parseChannel(stdout);
        }
        this.cachedConfigValues.put("channel", branch);
        return FlutterSdkChannel.fromText(branch);
    }

    @NotNull
    @NonNls
    public Set<String> queryConfiguredPlatforms(boolean useCachedValue) {
        JsonElement elem;
        HashSet<String> platforms;
        block17: {
            platforms = new HashSet<String>();
            platforms.add("enable-android");
            platforms.add("enable-ios");
            if (useCachedValue) {
                for (String key : PLATFORMS) {
                    String value = this.cachedConfigValues.get(key);
                    if ("true".equals(value)) {
                        platforms.add(key);
                        continue;
                    }
                    if (!"false".equals(value)) continue;
                    platforms.remove(key);
                }
                HashSet<String> hashSet = platforms;
                if (hashSet == null) {
                    FlutterSdk.$$$reportNull$$$0(38);
                }
                return hashSet;
            }
            String stdout = this.returnOutputOfQuery(this.flutterConfig("--machine"));
            if (stdout == null) {
                HashSet<String> hashSet = platforms;
                if (hashSet == null) {
                    FlutterSdk.$$$reportNull$$$0(39);
                }
                return hashSet;
            }
            int startJsonIndex = stdout.indexOf(123);
            if (startJsonIndex == -1) {
                HashSet<String> hashSet = platforms;
                if (hashSet == null) {
                    FlutterSdk.$$$reportNull$$$0(40);
                }
                return hashSet;
            }
            elem = JsonUtils.parseString(stdout.substring(startJsonIndex));
            if (!elem.isJsonNull()) break block17;
            FlutterUtils.warn(LOG, FlutterBundle.message("flutter.sdk.invalid.json.error", new Object[0]));
            HashSet<String> hashSet = platforms;
            if (hashSet == null) {
                FlutterSdk.$$$reportNull$$$0(41);
            }
            return hashSet;
        }
        try {
            JsonObject obj = elem.getAsJsonObject();
            for (String key : PLATFORMS) {
                JsonPrimitive primitive = obj.getAsJsonPrimitive(key);
                if (primitive == null) continue;
                if ("true".equals(primitive.getAsString())) {
                    platforms.add(key);
                } else if ("false".equals(primitive.getAsString())) {
                    platforms.remove(key);
                }
                this.cachedConfigValues.put(key, primitive.getAsString());
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        HashSet<String> hashSet = platforms;
        if (hashSet == null) {
            FlutterSdk.$$$reportNull$$$0(42);
        }
        return hashSet;
    }

    @Nullable
    public String queryFlutterConfig(String key, boolean useCachedValue) {
        if (useCachedValue && this.cachedConfigValues.containsKey(key)) {
            return this.cachedConfigValues.get(key);
        }
        String stdout = this.returnOutputOfQuery(this.flutterConfig("--machine"));
        if (stdout != null) {
            try {
                JsonElement elem = JsonUtils.parseString(stdout.substring(stdout.indexOf(123)));
                if (elem.isJsonNull()) {
                    FlutterUtils.warn(LOG, FlutterBundle.message("flutter.sdk.invalid.json.error", new Object[0]));
                    return null;
                }
                JsonObject obj = elem.getAsJsonObject();
                for (String jsonKey : JsonUtils.getKeySet(obj)) {
                    JsonElement element = obj.get(jsonKey);
                    if (element == null || element.isJsonNull()) continue;
                    JsonPrimitive primitive = (JsonPrimitive)element;
                    this.cachedConfigValues.put(jsonKey, primitive.getAsString());
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private String returnOutputOfQuery(@NotNull FlutterCommand command) {
        ColoredProcessHandler process;
        if (command == null) {
            FlutterSdk.$$$reportNull$$$0(43);
        }
        if ((process = command.startProcess(false)) == null) {
            return null;
        }
        final StringBuilder stdout = new StringBuilder();
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    stdout.append(event.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/sdk/FlutterSdk$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LOG.info("Calling " + command.getDisplayCommand());
        long start = System.currentTimeMillis();
        process.startNotify();
        if (process.waitFor(5000L)) {
            long duration = System.currentTimeMillis() - start;
            LOG.info(command.getDisplayCommand() + ": " + duration + "ms");
            Integer code = process.getExitCode();
            if (code != null && code == 0) {
                return stdout.toString();
            }
            LOG.info("Exit code from " + command.getDisplayCommand() + ": " + code);
        } else {
            LOG.info("Timeout when calling " + command.getDisplayCommand());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 35, 36, 37, 38, 39, 40, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gen";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 19: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSdk";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 25: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appDir";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterLaunchMode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "saveSdkInCache";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getHome";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "queryConfiguredPlatforms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isOlderThanToolsStamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFlutterSdk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIncomplete";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forPath";
                break;
            }
            case 6: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDartSdkLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "flutterClean";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "flutterCreate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "flutterPackagesGet";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "flutterPackagesUpgrade";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "flutterPackagesOutdated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "flutterBuild";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "flutterRun";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "flutterAttach";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "flutterRunOnTester";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "flutterTest";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createFiles";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "startPubGet";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "startPubUpgrade";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "startPubOutdated";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "returnOutputOfQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 35, 36, 37, 38, 39, 40, 41, 42 -> new IllegalStateException(string);
        };
    }
}

