/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import java.util.EventListener;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class FlutterSdkManager {
    private final EventDispatcher<Listener> myListenerDispatcher;
    private boolean isFlutterConfigured;
    @NotNull
    private final Project myProject;

    @NotNull
    public static FlutterSdkManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterSdkManager.$$$reportNull$$$0(0);
        }
        FlutterSdkManager flutterSdkManager = Objects.requireNonNull((FlutterSdkManager)project.getService(FlutterSdkManager.class));
        if (flutterSdkManager == null) {
            FlutterSdkManager.$$$reportNull$$$0(1);
        }
        return flutterSdkManager;
    }

    private FlutterSdkManager(@NotNull Project project) {
        if (project == null) {
            FlutterSdkManager.$$$reportNull$$$0(2);
        }
        this.myListenerDispatcher = EventDispatcher.create(Listener.class);
        this.myProject = project;
        LibraryTableListener libraryTableListener = new LibraryTableListener();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        libraryTable.addListener((LibraryTable.Listener)libraryTableListener);
        ScheduledFuture<?> timer = JobScheduler.getScheduler().scheduleWithFixedDelay(this::checkForFlutterSdkChange, 1L, 1L, TimeUnit.SECONDS);
        Disposer.register((Disposable)project, () -> {
            LibraryTablesRegistrar.getInstance().getLibraryTable(project).removeListener((LibraryTable.Listener)libraryTableListener);
            timer.cancel(false);
        });
        ProjectManager.getInstance().addProjectManagerListener(this.myProject, new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterSdkManager.this.checkForFlutterSdkChange();
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                FlutterSdkManager.this.checkForFlutterSdkChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "io/flutter/sdk/FlutterSdkManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.isFlutterConfigured = this.isFlutterSdkSetAndNeeded();
    }

    public void checkForFlutterSdkChange() {
        if (!this.isFlutterConfigured && this.isFlutterSdkSetAndNeeded()) {
            this.isFlutterConfigured = true;
            ((Listener)this.myListenerDispatcher.getMulticaster()).flutterSdkAdded();
        } else if (this.isFlutterConfigured && !this.isFlutterSdkSetAndNeeded()) {
            this.isFlutterConfigured = false;
            ((Listener)this.myListenerDispatcher.getMulticaster()).flutterSdkRemoved();
        }
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            FlutterSdkManager.$$$reportNull$$$0(3);
        }
        this.myListenerDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            FlutterSdkManager.$$$reportNull$$$0(4);
        }
        this.myListenerDispatcher.removeListener((EventListener)listener);
    }

    private boolean isFlutterSdkSetAndNeeded() {
        return FlutterSdk.getFlutterSdk(this.myProject) != null && FlutterSdkUtil.hasFlutterModules(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSdkManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSdkManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        default public void flutterSdkAdded() {
        }

        default public void flutterSdkRemoved() {
        }
    }

    private final class LibraryTableListener
    implements LibraryTable.Listener {
        private LibraryTableListener() {
        }

        public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                LibraryTableListener.$$$reportNull$$$0(0);
            }
            FlutterSdkManager.this.checkForFlutterSdkChange();
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                LibraryTableListener.$$$reportNull$$$0(1);
            }
            FlutterSdkManager.this.checkForFlutterSdkChange();
        }

        public void beforeLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                LibraryTableListener.$$$reportNull$$$0(2);
            }
        }

        public void afterLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                LibraryTableListener.$$$reportNull$$$0(3);
            }
            FlutterSdkManager.this.checkForFlutterSdkChange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibrary";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/sdk/FlutterSdkManager$LibraryTableListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRenamed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeLibraryRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

