/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.lang.dart.sdk.DartSdkUpdateOption;
import io.flutter.FlutterBundle;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkManager;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.JsonUtils;
import io.flutter.utils.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSdkUtil {
    public static final String FLUTTER_HOST_ENV = "FLUTTER_HOST";
    private static final String FLUTTER_SDK_KNOWN_PATHS = "FLUTTER_SDK_KNOWN_PATHS";
    private static final Logger LOG = Logger.getInstance(FlutterSdkUtil.class);
    private static final String FLUTTER_SNAP_SDK_PATH = "/snap/flutter/common/flutter";

    public String getFlutterHostEnvValue() {
        String clientId = ApplicationNamesInfo.getInstance().getFullProductName().replaceAll(" ", "-");
        String existingVar = System.getenv(FLUTTER_HOST_ENV);
        return existingVar == null ? clientId : existingVar + ":" + clientId;
    }

    public static void updateKnownSdkPaths(@NotNull String newSdkPath) {
        if (newSdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(0);
        }
        FlutterSdkUtil.updateKnownPaths(FLUTTER_SDK_KNOWN_PATHS, newSdkPath);
    }

    private static void updateKnownPaths(@NotNull String propertyKey, @NotNull String newPath) {
        if (propertyKey == null) {
            FlutterSdkUtil.$$$reportNull$$$0(1);
        }
        if (newPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(2);
        }
        LinkedHashSet<String> allPaths = new LinkedHashSet<String>();
        allPaths.add(newPath);
        PropertiesComponent props = PropertiesComponent.getInstance();
        String[] oldPaths = props.getValues(propertyKey);
        if (oldPaths != null) {
            allPaths.addAll(Arrays.asList(oldPaths));
        }
        if (allPaths.isEmpty()) {
            props.unsetValue(propertyKey);
        } else {
            props.setValues(propertyKey, ArrayUtil.toStringArray(allPaths));
        }
    }

    public static void addKnownSDKPathsToCombo(@NotNull JComboBox combo) {
        String[] knownPaths;
        if (combo == null) {
            FlutterSdkUtil.$$$reportNull$$$0(3);
        }
        LinkedHashSet<String> pathsToShow = new LinkedHashSet<String>();
        String currentPath = combo.getEditor().getItem().toString().trim();
        if (!currentPath.isEmpty()) {
            pathsToShow.add(currentPath);
        }
        for (String path : knownPaths = FlutterSdkUtil.getKnownFlutterSdkPaths()) {
            if (FlutterSdk.forPath(path) == null) continue;
            pathsToShow.add(FileUtil.toSystemDependentName((String)path));
        }
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(pathsToShow)));
        if (combo.getSelectedIndex() == -1 && combo.getItemCount() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    @NotNull
    public static String[] getKnownFlutterSdkPaths() {
        File snapSdkPath;
        String fromUserPath;
        HashSet<String> paths = new HashSet<String>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
            if (flutterSdk == null) continue;
            paths.add(flutterSdk.getHomePath());
        }
        String[] knownPaths = PropertiesComponent.getInstance().getValues(FLUTTER_SDK_KNOWN_PATHS);
        if (knownPaths != null) {
            paths.addAll(Arrays.asList(knownPaths));
        }
        if ((fromUserPath = FlutterSdkUtil.locateSdkFromPath()) != null) {
            paths.add(fromUserPath);
        }
        if ((snapSdkPath = new File(System.getenv("HOME") + FLUTTER_SNAP_SDK_PATH)).exists()) {
            paths.add(snapSdkPath.getAbsolutePath());
        }
        String[] stringArray = paths.toArray(new String[0]);
        if (stringArray == null) {
            FlutterSdkUtil.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @NotNull
    public static String pathToFlutterTool(@NotNull String sdkPath) throws ExecutionException {
        String path;
        if (sdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(5);
        }
        if ((path = FlutterSdkUtil.findDescendant(sdkPath, "/bin/" + FlutterSdkUtil.flutterScriptName())) == null) {
            throw new ExecutionException("Flutter SDK is not configured");
        }
        String string = path;
        if (string == null) {
            FlutterSdkUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String flutterScriptName() {
        return SystemInfo.isWindows ? "flutter.bat" : "flutter";
    }

    @Nullable
    public static String pathToDartSdk(@NotNull String flutterSdkPath) {
        if (flutterSdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(7);
        }
        return FlutterSdkUtil.findDescendant(flutterSdkPath, "/bin/cache/dart-sdk");
    }

    @Nullable
    private static String findDescendant(@NotNull String flutterSdkPath, @NotNull String path) {
        VirtualFile file;
        if (flutterSdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(8);
        }
        if (path == null) {
            FlutterSdkUtil.$$$reportNull$$$0(9);
        }
        if ((file = LocalFileSystem.getInstance().refreshAndFindFileByPath(flutterSdkPath + path)) == null || !file.exists()) {
            return null;
        }
        return file.getPath();
    }

    public static boolean isFlutterSdkHome(@NotNull String path) {
        if (path == null) {
            FlutterSdkUtil.$$$reportNull$$$0(10);
        }
        File flutterPubspecFile = new File(path + "/packages/flutter/pubspec.yaml");
        File flutterToolFile = new File(path + "/bin/flutter");
        File dartLibFolder = new File(path + "/bin/cache/dart-sdk/lib");
        return flutterPubspecFile.isFile() && flutterToolFile.isFile() && dartLibFolder.isDirectory();
    }

    private static boolean isFlutterSdkHomeWithoutDartSdk(@NotNull String path) {
        if (path == null) {
            FlutterSdkUtil.$$$reportNull$$$0(11);
        }
        File flutterPubspecFile = new File(path + "/packages/flutter/pubspec.yaml");
        File flutterToolFile = new File(path + "/bin/flutter");
        File dartLibFolder = new File(path + "/bin/cache/dart-sdk/lib");
        return flutterPubspecFile.isFile() && flutterToolFile.isFile() && !dartLibFolder.isDirectory();
    }

    public static boolean hasFlutterModules() {
        return Arrays.stream(ProjectManager.getInstance().getOpenProjects()).anyMatch(FlutterModuleUtils::hasFlutterModule);
    }

    public static boolean hasFlutterModules(@NotNull Project project) {
        if (project == null) {
            FlutterSdkUtil.$$$reportNull$$$0(12);
        }
        return FlutterModuleUtils.hasFlutterModule(project);
    }

    @Nullable
    public static String getErrorMessageIfWrongSdkRootPath(@NotNull String sdkRootPath) {
        if (sdkRootPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(13);
        }
        if (sdkRootPath.isEmpty()) {
            return null;
        }
        File sdkRoot = new File(sdkRootPath);
        if (!sdkRoot.isDirectory()) {
            return FlutterBundle.message("error.folder.specified.as.sdk.not.exists", new Object[0]);
        }
        if (FlutterSdkUtil.isFlutterSdkHomeWithoutDartSdk(sdkRootPath)) {
            return FlutterBundle.message("error.flutter.sdk.without.dart.sdk", new Object[0]);
        }
        if (!FlutterSdkUtil.isFlutterSdkHome(sdkRootPath)) {
            return FlutterBundle.message("error.sdk.not.found.in.specified.location", new Object[0]);
        }
        return null;
    }

    public static void setFlutterSdkPath(@NotNull Project project, @NotNull String flutterSdkPath) {
        if (project == null) {
            FlutterSdkUtil.$$$reportNull$$$0(14);
        }
        if (flutterSdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(15);
        }
        String dartSdk = flutterSdkPath + "/bin/cache/dart-sdk";
        ApplicationManager.getApplication().runWriteAction(() -> DartPlugin.ensureDartSdkConfigured(project, dartSdk));
        DartSdkUpdateOption.setDartSdkUpdateOption((DartSdkUpdateOption)DartSdkUpdateOption.DoNotCheck);
        FlutterSdkUtil.updateKnownSdkPaths(flutterSdkPath);
        FlutterSdkManager.getInstance(project).checkForFlutterSdkChange();
    }

    public static void enableDartSdk(@NotNull Project project) {
        if (project == null) {
            FlutterSdkUtil.$$$reportNull$$$0(16);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (module == null || PubRoots.forModule(module).isEmpty()) continue;
            DartPlugin.enableDartSdk(module);
        }
    }

    @Nullable
    public static String guessFlutterSdkFromPackagesFile(@NotNull Module module) {
        if (module == null) {
            FlutterSdkUtil.$$$reportNull$$$0(17);
        }
        JsonArray packages = FlutterSdkUtil.getPackagesFromPackageConfig(PubRoots.forModule(module));
        for (int i = 0; i < packages.size(); ++i) {
            String path;
            String uri;
            JsonObject pack = packages.get(i).getAsJsonObject();
            if (!"flutter".equals(JsonUtils.getStringMember(pack, "name")) || (uri = JsonUtils.getStringMember(pack, "rootUri")) == null || (path = FlutterSdkUtil.extractSdkPathFromUri(uri, false)) == null) continue;
            return path;
        }
        for (PubRoot pubRoot : PubRoots.forModule(module)) {
            VirtualFile packagesFile = pubRoot.getPackagesFile();
            if (packagesFile == null) continue;
            try {
                String contents = new String(packagesFile.contentsToByteArray(true));
                return FlutterSdkUtil.parseFlutterSdkPath(contents);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @Nullable
    public static String getPathToCupertinoIconsPackage(@NotNull Project project) {
        if (project == null) {
            FlutterSdkUtil.$$$reportNull$$$0(18);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return "testData/sdk";
        }
        JsonArray packages = FlutterSdkUtil.getPackagesFromPackageConfig(PubRoots.forProject(project));
        for (int i = 0; i < packages.size(); ++i) {
            String uri;
            JsonObject pack = packages.get(i).getAsJsonObject();
            if (!"cupertino_icons".equals(JsonUtils.getStringMember(pack, "name")) || (uri = JsonUtils.getStringMember(pack, "rootUri")) == null) continue;
            try {
                return new URI(uri).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static JsonArray getPackagesFromPackageConfig(@NotNull List<PubRoot> pubRoots) {
        if (pubRoots == null) {
            FlutterSdkUtil.$$$reportNull$$$0(19);
        }
        JsonArray entries = new JsonArray();
        for (PubRoot pubRoot : pubRoots) {
            VirtualFile configFile = pubRoot.getPackageConfigFile();
            if (configFile == null) continue;
            try {
                JsonArray packages;
                JsonObject json;
                String contents = new String(configFile.contentsToByteArray(true));
                JsonElement element = new JsonParser().parse(contents);
                if (element == null || JsonUtils.getIntMember(json = element.getAsJsonObject(), "configVersion") < 2 || (packages = json.getAsJsonArray("packages")) == null || packages.isEmpty()) continue;
                entries.addAll(packages);
            }
            catch (IOException iOException) {}
        }
        return entries;
    }

    @VisibleForTesting
    public static String parseFlutterSdkPath(String packagesFileContent) {
        for (String line : packagesFileContent.split("\n")) {
            String urlString;
            String path;
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String flutterPrefix = "flutter:";
            if (!line.startsWith("flutter:") || (path = FlutterSdkUtil.extractSdkPathFromUri(urlString = line.substring("flutter:".length()), true)) == null) continue;
            return path;
        }
        return null;
    }

    private static String extractSdkPathFromUri(String urlString, boolean isLibIncluded) {
        if (urlString.startsWith("file:")) {
            Url url = Urls.parseEncoded((String)urlString);
            if (url == null) {
                return null;
            }
            String path = url.getPath();
            File file = new File(url.getPath());
            file = file.getParentFile().getParentFile();
            if (isLibIncluded) {
                file = file.getParentFile();
            }
            return file.getPath();
        }
        return null;
    }

    @Nullable
    public static String locateSdkFromPath() {
        String flutterBinPath = SystemUtils.which("flutter");
        if (flutterBinPath == null) {
            return null;
        }
        File flutterBinFile = new File(flutterBinPath);
        return flutterBinFile.getParentFile().getParentFile().getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdkPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSdkUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterSdkPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRootPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSdkUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownFlutterSdkPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToFlutterTool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateKnownSdkPaths";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateKnownPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addKnownSDKPathsToCombo";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pathToFlutterTool";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pathToDartSdk";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDescendant";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFlutterSdkHome";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFlutterSdkHomeWithoutDartSdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasFlutterModules";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageIfWrongSdkRootPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setFlutterSdkPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "enableDartSdk";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "guessFlutterSdkFromPackagesFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPathToCupertinoIconsPackage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesFromPackageConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

