/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSdkVersion
implements Comparable<FlutterSdkVersion> {
    @VisibleForTesting
    public static final FlutterSdkVersion DISTRIBUTED_ICONS = new FlutterSdkVersion("3.1.0");
    private static final FlutterSdkVersion MIN_SUPPORTED_SDK = new FlutterSdkVersion("0.0.12");
    private static final FlutterSdkVersion MIN_SAFE_TRACK_WIDGET_CREATION_SDK = new FlutterSdkVersion("0.10.2");
    private static final FlutterSdkVersion MIN_DART_DEFINE_SDK = new FlutterSdkVersion("1.12.0");
    private static final FlutterSdkVersion MIN_PUB_OUTDATED_SDK = new FlutterSdkVersion("1.16.4");
    private static final FlutterSdkVersion MIN_CREATE_PLATFORMS_SDK = new FlutterSdkVersion("1.20.0");
    private static final FlutterSdkVersion MIN_XCODE_CONFIG_ONLY = new FlutterSdkVersion("1.22.0-12.0.pre");
    private static final FlutterSdkVersion MAX_STABLE_NO_PLATFORMS_SDK = new FlutterSdkVersion("1.22.6");
    @NotNull
    private static final FlutterSdkVersion MIN_PASS_DEVTOOLS_SDK = new FlutterSdkVersion("1.26.0-11.0.pre");
    @NotNull
    private static final FlutterSdkVersion MIN_OPTIONAL_PASS_DEVTOOLS_SDK = new FlutterSdkVersion("2.7.0-3.0.pre");
    @NotNull
    private static final FlutterSdkVersion MIN_USE_DAEMON_FOR_DEVTOOLS = new FlutterSdkVersion("1.26.0-11.0.pre");
    private static final FlutterSdkVersion MIN_SKELETON_TEMPLATE = new FlutterSdkVersion("2.5.0");
    private static final FlutterSdkVersion MIN_PLUGIN_FFI_TEMPLATE = new FlutterSdkVersion("3.0.0");
    private static final FlutterSdkVersion MIN_EMPTY_PROJECT = new FlutterSdkVersion("3.6.0-0.1.pre");
    @NotNull
    private static final FlutterSdkVersion MIN_URI_MAPPING_FOR_WEB = new FlutterSdkVersion("2.13.0-0.1.pre");
    @NotNull
    private static final FlutterSdkVersion MIN_STABLE_WEB_PLATFORM = new FlutterSdkVersion("2.0.0");
    @NotNull
    private static final FlutterSdkVersion MIN_STABLE_WINDOWS_PLATFORM = new FlutterSdkVersion("2.10.0");
    @NotNull
    private static final FlutterSdkVersion MIN_STABLE_LINUX_PLATFORM = new FlutterSdkVersion("3.0.0");
    @NotNull
    private static final FlutterSdkVersion MIN_STABLE_MACOS_PLATFORM = new FlutterSdkVersion("3.0.0");
    @NotNull
    private static final FlutterSdkVersion MIN_SUPPORTS_DEVTOOLS_PATH_URLS = new FlutterSdkVersion("3.3.0");
    @Nullable
    private final Version version;
    @Nullable
    private final String versionText;
    @Nullable
    private final Version betaVersion;
    private final int masterVersion;

    @VisibleForTesting
    public FlutterSdkVersion(@Nullable String versionString) {
        this.versionText = versionString;
        if (versionString != null) {
            String[] split = versionString.split("-");
            this.version = Version.parseVersion((String)split[0]);
            if (split.length > 1) {
                this.betaVersion = Version.parseVersion((String)split[1]);
                String[] parts = split[1].split("\\.");
                this.masterVersion = parts.length > 3 ? Integer.parseInt(parts[3]) : 0;
            } else {
                this.betaVersion = null;
                this.masterVersion = 0;
            }
        } else {
            this.version = null;
            this.betaVersion = null;
            this.masterVersion = 0;
        }
    }

    @NotNull
    public static FlutterSdkVersion readFromSdk(@NotNull VirtualFile sdkHome) {
        if (sdkHome == null) {
            FlutterSdkVersion.$$$reportNull$$$0(0);
        }
        return FlutterSdkVersion.readFromFile(sdkHome.findChild("version"));
    }

    @NotNull
    private static FlutterSdkVersion readFromFile(@Nullable VirtualFile file) {
        if (file == null) {
            return new FlutterSdkVersion(null);
        }
        String versionString = FlutterSdkVersion.readVersionString(file);
        if (versionString == null) {
            return new FlutterSdkVersion(null);
        }
        return new FlutterSdkVersion(versionString);
    }

    private static String readVersionString(VirtualFile file) {
        try {
            String data = new String(file.contentsToByteArray(), StandardCharsets.UTF_8);
            for (String line : data.split("\n")) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                return line;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isMinRecommendedSupported() {
        assert (FlutterSdkVersion.MIN_SUPPORTED_SDK.version != null);
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_SUPPORTED_SDK.version) >= 0;
    }

    public boolean isTrackWidgetCreationRecommended() {
        assert (FlutterSdkVersion.MIN_SAFE_TRACK_WIDGET_CREATION_SDK.version != null);
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_SAFE_TRACK_WIDGET_CREATION_SDK.version) >= 0;
    }

    public boolean isDartDefineSupported() {
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_DART_DEFINE_SDK.version) >= 0;
    }

    public boolean isXcodeConfigOnlySupported() {
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_XCODE_CONFIG_ONLY.version) >= 0;
    }

    public boolean flutterCreateSupportsPlatforms() {
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_CREATE_PLATFORMS_SDK.version) >= 0;
    }

    public boolean stableChannelSupportsPlatforms() {
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MAX_STABLE_NO_PLATFORMS_SDK.version) > 0;
    }

    public boolean flutterRunSupportsDevToolsUrl() {
        return this.version != null && this.compareTo(MIN_PASS_DEVTOOLS_SDK) >= 0 && this.compareTo(MIN_OPTIONAL_PASS_DEVTOOLS_SDK) < 0;
    }

    public boolean useDaemonForDevTools() {
        return this.version != null && this.compareTo(MIN_PASS_DEVTOOLS_SDK) >= 0;
    }

    public boolean flutterTestSupportsMachineMode() {
        return this.isMinRecommendedSupported();
    }

    public boolean flutterTestSupportsFiltering() {
        return this.isMinRecommendedSupported();
    }

    public boolean isPubOutdatedSupported() {
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_PUB_OUTDATED_SDK.version) >= 0;
    }

    public boolean isSkeletonTemplateAvailable() {
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_SKELETON_TEMPLATE.version) >= 0;
    }

    public boolean isPluginFfiTemplateAvailable() {
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_PLUGIN_FFI_TEMPLATE.version) >= 0;
    }

    public boolean isEmptyProjectAvailable() {
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_EMPTY_PROJECT.version) >= 0;
    }

    public boolean isUriMappingSupportedForWeb() {
        return this.version != null && this.compareTo(MIN_URI_MAPPING_FOR_WEB) >= 0;
    }

    public boolean isWebPlatformStable() {
        return this.version != null && this.compareTo(MIN_STABLE_WEB_PLATFORM) >= 0;
    }

    public boolean isWindowsPlatformStable() {
        return this.version != null && this.compareTo(MIN_STABLE_WINDOWS_PLATFORM) >= 0;
    }

    public boolean isLinuxPlatformStable() {
        return this.version != null && this.compareTo(MIN_STABLE_LINUX_PLATFORM) >= 0;
    }

    public boolean isMacOSPlatformStable() {
        return this.version != null && this.compareTo(MIN_STABLE_MACOS_PLATFORM) >= 0;
    }

    public boolean canUseDistributedIcons() {
        return this.version != null && this.compareTo(DISTRIBUTED_ICONS) >= 0;
    }

    public boolean canUseDevToolsPathUrls() {
        return this.version != null && this.compareTo(MIN_SUPPORTS_DEVTOOLS_PATH_URLS) >= 0;
    }

    public boolean isValid() {
        return this.version != null;
    }

    public String fullVersion() {
        return this.version == null ? "unknown version" : this.version.toString();
    }

    @Nullable
    public String getVersionText() {
        return this.versionText;
    }

    public String toString() {
        return this.version == null ? "unknown version" : this.version.toCompactString();
    }

    @Override
    public int compareTo(@NotNull FlutterSdkVersion otherVersion) {
        if (otherVersion == null) {
            FlutterSdkVersion.$$$reportNull$$$0(1);
        }
        if (this.version == null) {
            return -1;
        }
        if (otherVersion.version == null) {
            return 1;
        }
        int standardComparisonResult = this.version.compareTo(otherVersion.version);
        if (standardComparisonResult != 0) {
            return standardComparisonResult;
        }
        if (this.betaVersion == null && otherVersion.betaVersion == null) {
            return 0;
        }
        if (this.betaVersion == null) {
            return 1;
        }
        if (otherVersion.betaVersion == null) {
            return -1;
        }
        int betaComparisonResult = this.betaVersion.compareTo(otherVersion.betaVersion);
        if (betaComparisonResult != 0) {
            return betaComparisonResult;
        }
        if (this.masterVersion != 0 && otherVersion.masterVersion != 0) {
            return Integer.compare(this.masterVersion, otherVersion.masterVersion);
        }
        if (this.masterVersion != 0) {
            return -1;
        }
        if (otherVersion.masterVersion != 0) {
            return 1;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherVersion";
                break;
            }
        }
        objectArray2[1] = "io/flutter/sdk/FlutterSdkVersion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readFromSdk";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

