/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actionsOnSave.ActionsOnSaveConfigurable;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PlatformIcons;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.font.FontPreviewProcessor;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.sdk.FlutterSdkVersion;
import io.flutter.settings.FlutterSettings;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSettingsConfigurable
implements SearchableConfigurable {
    public static final String FLUTTER_SETTINGS_PAGE_NAME = FlutterBundle.message("flutter.title", new Object[0]);
    private static final String FLUTTER_SETTINGS_HELP_TOPIC = "flutter.settings.help";
    private JPanel mainPanel;
    private ComboboxWithBrowseButton mySdkCombo;
    private JBLabel myVersionLabel;
    private JCheckBox myReportUsageInformationCheckBox;
    private LinkLabel<?> myPrivacyPolicy;
    private JCheckBox myHotReloadOnSaveCheckBox;
    private JCheckBox myEnableVerboseLoggingCheckBox;
    private JCheckBox myOpenInspectorOnAppLaunchCheckBox;
    private JCheckBox myFormatCodeOnSaveCheckBox;
    private JCheckBox myOrganizeImportsOnSaveCheckBox;
    private JCheckBox myShowStructuredErrors;
    private JCheckBox myIncludeAllStackTraces;
    private JCheckBox mySyncAndroidLibrariesCheckBox;
    private JCheckBox myEnableHotUiCheckBox;
    private JCheckBox myEnableBazelHotRestartCheckBox;
    private JCheckBox myShowAllRunConfigurationsInContextCheckBox;
    private JCheckBox myShowBuildMethodGuides;
    private JCheckBox myShowClosingLabels;
    private FixedSizeButton myCopyButton;
    private JTextArea myFontPackagesTextArea;
    private JCheckBox myAllowTestsInSourcesRoot;
    private ActionLink settingsLink;
    private JCheckBox myEnableLogsPreserveAfterHotReloadOrRestart;
    @NotNull
    private final Project myProject;
    private final WorkspaceCache workspaceCache;
    private boolean ignoringSdkChanges;
    private String fullVersionString;
    private FlutterSdkVersion previousSdkVersion;
    private final Semaphore lock;
    private Process updater;

    FlutterSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this.ignoringSdkChanges = false;
        this.$$$setupUI$$$();
        this.lock = new Semaphore(1, true);
        this.myProject = project;
        this.workspaceCache = WorkspaceCache.getInstance(project);
        this.init();
        this.myVersionLabel.setText(" ");
    }

    private void init() {
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.myProject);
        if (sdk != null) {
            this.previousSdkVersion = sdk.getVersion();
        }
        this.mySdkCombo.getComboBox().setEditable(true);
        this.myCopyButton.setSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.myCopyButton.setIcon(PlatformIcons.COPY_ICON);
        this.myCopyButton.addActionListener(e -> {
            if (this.fullVersionString != null) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.fullVersionString));
            }
        });
        JTextComponent sdkEditor = (JTextComponent)this.mySdkCombo.getComboBox().getEditor().getEditorComponent();
        sdkEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!FlutterSettingsConfigurable.this.ignoringSdkChanges) {
                    FlutterSettingsConfigurable.this.onVersionChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/sdk/FlutterSettingsConfigurable$1", "textChanged"));
            }
        });
        this.workspaceCache.subscribe(this::onVersionChanged);
        this.mySdkCombo.addBrowseFolderListener("Select Flutter SDK Path", null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        this.myPrivacyPolicy.setListener((linkLabel, data) -> {
            try {
                BrowserLauncher.getInstance().browse(new URI(FlutterBundle.message("flutter.analytics.privacyUrl", new Object[0])));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }, null);
        this.myFormatCodeOnSaveCheckBox.addChangeListener(e -> this.myOrganizeImportsOnSaveCheckBox.setEnabled(this.myFormatCodeOnSaveCheckBox.isSelected()));
        this.myShowStructuredErrors.addChangeListener(e -> this.myIncludeAllStackTraces.setEnabled(this.myShowStructuredErrors.isSelected()));
        this.mySyncAndroidLibrariesCheckBox.setVisible(FlutterUtils.isAndroidStudio());
        this.myEnableBazelHotRestartCheckBox.setVisible(WorkspaceCache.getInstance(this.myProject).isBazel());
    }

    private void createUIComponents() {
        this.mySdkCombo = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
        this.settingsLink = ActionsOnSaveConfigurable.createGoToActionsOnSavePageLink();
    }

    @NotNull
    public String getId() {
        return "flutter.settings";
    }

    @Nullable
    public Runnable enableSearch(String s) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.mainPanel;
    }

    public boolean isModified() {
        String sdkPathInUI;
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.myProject);
        FlutterSettings settings = FlutterSettings.getInstance();
        String sdkPathInModel = sdk == null ? "" : sdk.getHomePath();
        if (!sdkPathInModel.equals(sdkPathInUI = FileUtilRt.toSystemIndependentName((String)this.getSdkPathText()))) {
            return true;
        }
        if (FlutterInitializer.getCanReportAnalytics() != this.myReportUsageInformationCheckBox.isSelected()) {
            return true;
        }
        if (settings.isReloadOnSave() != this.myHotReloadOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isFormatCodeOnSave() != this.myFormatCodeOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isOrganizeImportsOnSave() != this.myOrganizeImportsOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isShowBuildMethodGuides() != this.myShowBuildMethodGuides.isSelected()) {
            return true;
        }
        if (settings.isShowClosingLabels() != this.myShowClosingLabels.isSelected()) {
            return true;
        }
        if (settings.isShowStructuredErrors() != this.myShowStructuredErrors.isSelected()) {
            return true;
        }
        if (settings.isIncludeAllStackTraces() != this.myIncludeAllStackTraces.isSelected()) {
            return true;
        }
        if (settings.isOpenInspectorOnAppLaunch() != this.myOpenInspectorOnAppLaunchCheckBox.isSelected()) {
            return true;
        }
        if (settings.isPerserveLogsDuringHotReloadAndRestart() != this.myEnableLogsPreserveAfterHotReloadOrRestart.isSelected()) {
            return true;
        }
        if (settings.isVerboseLogging() != this.myEnableVerboseLoggingCheckBox.isSelected()) {
            return true;
        }
        if (settings.isSyncingAndroidLibraries() != this.mySyncAndroidLibrariesCheckBox.isSelected()) {
            return true;
        }
        if (settings.isEnableHotUi() != this.myEnableHotUiCheckBox.isSelected()) {
            return true;
        }
        if (settings.isEnableBazelHotRestart() != this.myEnableBazelHotRestartCheckBox.isSelected()) {
            return true;
        }
        if (settings.isAllowTestsInSourcesRoot() != this.myAllowTestsInSourcesRoot.isSelected()) {
            return true;
        }
        if (!settings.getFontPackages().equals(this.myFontPackagesTextArea.getText())) {
            return true;
        }
        return settings.showAllRunConfigurationsInContext() != this.myShowAllRunConfigurationsInContextCheckBox.isSelected();
    }

    public void apply() throws ConfigurationException {
        if (!this.workspaceCache.isBazel()) {
            String errorMessage = FlutterSdkUtil.getErrorMessageIfWrongSdkRootPath(this.getSdkPathText());
            if (errorMessage != null) {
                throw new ConfigurationException(errorMessage);
            }
            String sdkHomePath = this.getSdkPathText();
            if (FlutterSdkUtil.isFlutterSdkHome(sdkHomePath)) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    FlutterSdkUtil.setFlutterSdkPath(this.myProject, sdkHomePath);
                    FlutterSdkUtil.enableDartSdk(this.myProject);
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        FlutterSdk sdk = FlutterSdk.forPath(sdkHomePath);
                        if (sdk != null) {
                            try {
                                this.lock.acquire();
                                sdk.queryFlutterChannel(false);
                                this.lock.release();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    });
                });
            }
        }
        FlutterInitializer.setCanReportAnalytics(this.myReportUsageInformationCheckBox.isSelected());
        FlutterSettings settings = FlutterSettings.getInstance();
        String oldFontPackages = settings.getFontPackages();
        settings.setReloadOnSave(this.myHotReloadOnSaveCheckBox.isSelected());
        settings.setFormatCodeOnSave(this.myFormatCodeOnSaveCheckBox.isSelected());
        settings.setOrganizeImportsOnSave(this.myOrganizeImportsOnSaveCheckBox.isSelected());
        settings.setShowBuildMethodGuides(this.myShowBuildMethodGuides.isSelected());
        settings.setShowClosingLabels(this.myShowClosingLabels.isSelected());
        settings.setShowStructuredErrors(this.myShowStructuredErrors.isSelected());
        settings.setIncludeAllStackTraces(this.myIncludeAllStackTraces.isSelected());
        settings.setOpenInspectorOnAppLaunch(this.myOpenInspectorOnAppLaunchCheckBox.isSelected());
        settings.setPerserveLogsDuringHotReloadAndRestart(this.myEnableLogsPreserveAfterHotReloadOrRestart.isSelected());
        settings.setVerboseLogging(this.myEnableVerboseLoggingCheckBox.isSelected());
        settings.setSyncingAndroidLibraries(this.mySyncAndroidLibrariesCheckBox.isSelected());
        settings.setEnableHotUi(this.myEnableHotUiCheckBox.isSelected());
        settings.setEnableBazelHotRestart(this.myEnableBazelHotRestartCheckBox.isSelected());
        settings.setAllowTestsInSourcesRoot(this.myAllowTestsInSourcesRoot.isSelected());
        settings.setShowAllRunConfigurationsInContext(this.myShowAllRunConfigurationsInContextCheckBox.isSelected());
        settings.setFontPackages(this.myFontPackagesTextArea.getText());
        this.reset();
        this.checkFontPackages(settings.getFontPackages(), oldFontPackages);
    }

    public void reset() {
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.myProject);
        String path = sdk != null ? sdk.getHomePath() : "";
        try {
            this.ignoringSdkChanges = true;
            FlutterSdkUtil.addKnownSDKPathsToCombo(this.mySdkCombo.getComboBox());
            this.mySdkCombo.getComboBox().getEditor().setItem(FileUtil.toSystemDependentName((String)path));
        }
        finally {
            this.ignoringSdkChanges = false;
        }
        this.onVersionChanged();
        if (sdk != null) {
            if (this.previousSdkVersion != null && this.previousSdkVersion.compareTo(sdk.getVersion()) != 0) {
                List<PubRoot> roots = PubRoots.forProject(this.myProject);
                try {
                    this.lock.acquire();
                    for (PubRoot root : roots) {
                        sdk.startPubGet(root, this.myProject);
                    }
                    this.lock.release();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.previousSdkVersion = sdk.getVersion();
            }
        } else {
            this.previousSdkVersion = null;
        }
        this.myReportUsageInformationCheckBox.setSelected(FlutterInitializer.getCanReportAnalytics());
        FlutterSettings settings = FlutterSettings.getInstance();
        this.myHotReloadOnSaveCheckBox.setSelected(settings.isReloadOnSave());
        this.myFormatCodeOnSaveCheckBox.setSelected(settings.isFormatCodeOnSave());
        this.myOrganizeImportsOnSaveCheckBox.setSelected(settings.isOrganizeImportsOnSave());
        this.myShowBuildMethodGuides.setSelected(settings.isShowBuildMethodGuides());
        this.myShowClosingLabels.setSelected(settings.isShowClosingLabels());
        this.myShowStructuredErrors.setSelected(settings.isShowStructuredErrors());
        this.myIncludeAllStackTraces.setSelected(settings.isIncludeAllStackTraces());
        this.myOpenInspectorOnAppLaunchCheckBox.setSelected(settings.isOpenInspectorOnAppLaunch());
        this.myEnableLogsPreserveAfterHotReloadOrRestart.setSelected(settings.isPerserveLogsDuringHotReloadAndRestart());
        this.myEnableVerboseLoggingCheckBox.setSelected(settings.isVerboseLogging());
        this.mySyncAndroidLibrariesCheckBox.setSelected(settings.isSyncingAndroidLibraries());
        this.myEnableHotUiCheckBox.setSelected(settings.isEnableHotUi());
        this.myEnableBazelHotRestartCheckBox.setSelected(settings.isEnableBazelHotRestart());
        this.myAllowTestsInSourcesRoot.setSelected(settings.isAllowTestsInSourcesRoot());
        this.myOrganizeImportsOnSaveCheckBox.setEnabled(this.myFormatCodeOnSaveCheckBox.isSelected());
        this.myIncludeAllStackTraces.setEnabled(this.myShowStructuredErrors.isSelected());
        this.myShowAllRunConfigurationsInContextCheckBox.setSelected(settings.showAllRunConfigurationsInContext());
        this.myFontPackagesTextArea.setText(settings.getFontPackages());
    }

    private void onVersionChanged() {
        FlutterSdk sdk;
        Workspace workspace = this.workspaceCache.get();
        if (this.workspaceCache.isBazel()) {
            if (this.mySdkCombo.isEnabled()) {
                assert (workspace != null);
                this.mySdkCombo.setEnabled(false);
                this.mySdkCombo.getComboBox().getEditor().setItem(workspace.getRoot().getPath() + "/" + workspace.getSdkHome() + " <set by bazel project>");
            }
        } else {
            this.mySdkCombo.setEnabled(true);
        }
        if ((sdk = FlutterSdk.forPath(this.getSdkPathText())) == null) {
            this.myVersionLabel.setText(" ");
            this.fullVersionString = null;
            return;
        }
        ModalityState modalityState = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                if (this.updater != null) {
                    this.updater.destroy();
                    this.lock.release();
                }
                Thread.sleep(100L);
                this.lock.acquire();
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.updater = sdk.flutterVersion().start(output -> {
                        this.fullVersionString = output.getStdout();
                        String[] lines = StringUtil.splitByLines((String)this.fullVersionString);
                        String singleLineVersion = lines.length > 0 ? lines[0] : "";
                        ApplicationManager.getApplication().invokeLater(() -> {
                            this.updater = null;
                            this.lock.release();
                            this.updateVersionTextIfCurrent(sdk, singleLineVersion);
                        }, modalityState);
                    }, null);
                }, modalityState);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    private void updateVersionTextIfCurrent(@NotNull FlutterSdk sdk, @NotNull String value) {
        FlutterSdk current;
        if (sdk == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(1);
        }
        if (value == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(2);
        }
        if ((current = FlutterSdk.forPath(this.getSdkPathText())) == null) {
            this.myVersionLabel.setText(" ");
        } else {
            this.myVersionLabel.setText(value);
        }
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return FLUTTER_SETTINGS_PAGE_NAME;
    }

    @Nullable
    public String getHelpTopic() {
        return FLUTTER_SETTINGS_HELP_TOPIC;
    }

    @NotNull
    private String getSdkPathText() {
        String string = FileUtilRt.toSystemIndependentName((String)this.mySdkCombo.getComboBox().getEditor().getItem().toString().trim());
        if (string == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void checkFontPackages(String value, String previous) {
        if (value != null) {
            String[] packages;
            for (String name : packages = value.split("[,\r\n]")) {
                String message = FontPreviewProcessor.UNSUPPORTED_PACKAGES.get(name.trim());
                if (message == null) continue;
                this.displayNotification(message);
            }
            if (!value.equals(previous)) {
                FontPreviewProcessor.reanalyze(this.myProject);
            }
        }
    }

    private void displayNotification(String message) {
        Notification notification = new Notification("Flutter Notifications", FlutterBundle.message("icon.preview.disallow.package.title", new Object[0]), message, NotificationType.INFORMATION);
        notification.setIcon(FlutterIcons.Flutter);
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
    }

    public static void openFlutterSettings(@NotNull Project project) {
        if (project == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(4);
        }
        ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"flutter.settings", (String)"");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JCheckBox jCheckBox12;
        JCheckBox jCheckBox13;
        JCheckBox jCheckBox14;
        LinkLabel linkLabel;
        JCheckBox jCheckBox15;
        JCheckBox jCheckBox16;
        FixedSizeButton fixedSizeButton;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setAutoscrolls(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 2, 1, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "SDK (current project only)", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.flutter.version"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("flutter.sdk.path.label"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySdkCombo;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myVersionLabel = jBLabel = new JBLabel();
        jBLabel.setText("placeholder for version details");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myCopyButton = fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.sdk.copy.content"));
        jPanel2.add((Component)fixedSizeButton, new GridConstraints(1, 2, 1, 1, 0, 0, 1, 3, null, null, null, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General", 0, 0, null, null));
        this.myReportUsageInformationCheckBox = jCheckBox16 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox16, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.report.google.analytics"));
        jCheckBox16.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.report.analytics.tooltip"));
        jPanel3.add((Component)jCheckBox16, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myEnableVerboseLoggingCheckBox = jCheckBox15 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox15, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.verbose.logging"));
        jCheckBox15.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.verbose.logging.tooltip"));
        jPanel3.add((Component)jCheckBox15, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myPrivacyPolicy = linkLabel = new LinkLabel();
        linkLabel.setHorizontalAlignment(2);
        linkLabel.setHorizontalTextPosition(2);
        linkLabel.setText("www.google.com/policies/privacy");
        linkLabel.setToolTipText("http://www.google.com/policies/privacy/");
        jPanel3.add((Component)linkLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myAllowTestsInSourcesRoot = jCheckBox14 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox14, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.allow.tests.in.sources"));
        jCheckBox14.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.allow.tests.tooltip"));
        jPanel3.add((Component)jCheckBox14, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "App Execution", 0, 0, null, null));
        this.myOpenInspectorOnAppLaunchCheckBox = jCheckBox13 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox13, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.open.inspector.on.launch"));
        jPanel4.add((Component)jCheckBox13, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHotReloadOnSaveCheckBox = jCheckBox12 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.hot.reload.on.save"));
        jCheckBox12.setToolTipText("On a \"Save All\" action, hot reload changes into running Flutter apps.");
        jPanel4.add((Component)jCheckBox12, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myShowStructuredErrors = jCheckBox11 = new JCheckBox();
        jCheckBox11.setText("Show structured errors for Flutter framework issues");
        jPanel4.add((Component)jCheckBox11, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableBazelHotRestartCheckBox = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.bazel.hot.restart"));
        jPanel4.add((Component)jCheckBox10, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myIncludeAllStackTraces = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Include all stack traces");
        jCheckBox9.setToolTipText("If checked, only the first exception will include a stack trace.");
        jPanel4.add((Component)jCheckBox9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 3));
        this.myEnableLogsPreserveAfterHotReloadOrRestart = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.logs.preserve.during.hot.reload.and.restart"));
        jPanel4.add((Component)jCheckBox8, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.editor"), 0, 0, null, null));
        this.myShowBuildMethodGuides = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.show.build.guides"));
        jCheckBox7.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.show.build.guides.tooltip"));
        jPanel5.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOrganizeImportsOnSaveCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.organize.imports.on.save"));
        jCheckBox6.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.organize.imports.tooltip"));
        jPanel5.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null, 2));
        this.myShowClosingLabels = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.show.closing.labels"));
        jPanel5.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myFormatCodeOnSaveCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.format.code.on.save"));
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.format.code.tooltip"));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("(For project-specific formatting, use");
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.settingsLink;
        jPanel6.add((Component)actionLink, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("instead)");
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.experiments"), 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.try.out.features.still.under.development"));
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySyncAndroidLibrariesCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.android.gradle.sync"));
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.androi.gradle.sync.tooltip"));
        jPanel7.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableHotUiCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.hot.ui"));
        jCheckBox2.setToolTipText("Experimental features to graphically edit Flutter build methods.");
        jPanel7.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowAllRunConfigurationsInContextCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.show.all.configs"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.show.all.configs.tooltip"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.font.packages"), 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        jPanel8.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myFontPackagesTextArea = jTextArea = new JTextArea();
        jTextArea.setRows(3);
        jTextArea.setToolTipText("Names of font packages to show icon previews");
        jScrollPane.setViewportView(jTextArea);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel9, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        Font font = UIManager.getFont("CheckBoxMenuItem.acceleratorFont");
        if (font != null) {
            jLabel5.setFont(font);
        }
        jLabel5.setText("Settings below apply to all projects");
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel2.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSettingsConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPathText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateVersionTextIfCurrent";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openFlutterSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

