/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import io.flutter.FlutterBundle;
import io.flutter.FlutterMessages;
import io.flutter.utils.SystemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class XcodeUtils {
    public static boolean isSimulatorRunning() {
        ProcessInfo[] processInfos;
        for (ProcessInfo info : processInfos = OSProcessUtil.getProcessList()) {
            if (!info.getExecutableName().equals("Simulator")) continue;
            return true;
        }
        return false;
    }

    public static void openSimulator(@Nullable Project project, String ... additionalArgs) {
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(additionalArgs));
        params.add("-a");
        params.add("Simulator.app");
        GeneralCommandLine cmd = new GeneralCommandLine().withExePath("open").withParameters(params);
        ((CompletableFuture)SystemUtils.execAndGetOutput(cmd).thenAccept(output -> {
            if (output.getExitCode() != 0) {
                String eventText;
                StringBuilder textBuffer = new StringBuilder();
                if (!output.getStdout().isEmpty()) {
                    textBuffer.append(output.getStdout());
                }
                if (!output.getStderr().isEmpty()) {
                    if (!textBuffer.isEmpty()) {
                        textBuffer.append("\n");
                    }
                    textBuffer.append(output.getStderr());
                }
                String msg = !(eventText = textBuffer.toString()).isEmpty() ? eventText : "Process error - exit code: (" + output.getExitCode() + ")";
                FlutterMessages.showError("Error Opening Simulator", msg, project);
            }
        })).exceptionally(throwable -> {
            FlutterMessages.showError("Error Opening Simulator", FlutterBundle.message("flutter.command.exception.message", throwable.getMessage()), project);
            return null;
        });
    }
}

