/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.settings;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EventDispatcher;
import com.jetbrains.lang.dart.analyzer.DartClosingLabelManager;
import io.flutter.analytics.Analytics;
import java.util.EventListener;

public class FlutterSettings {
    private static final String reloadOnSaveKey = "io.flutter.reloadOnSave";
    private static final String openInspectorOnAppLaunchKey = "io.flutter.openInspectorOnAppLaunch";
    private static final String perserveLogsDuringHotReloadAndRestartKey = "io.flutter.persereLogsDuringHotReloadAndRestart";
    private static final String verboseLoggingKey = "io.flutter.verboseLogging";
    private static final String formatCodeOnSaveKey = "io.flutter.formatCodeOnSave";
    private static final String organizeImportsOnSaveKey = "io.flutter.organizeImportsOnSave";
    private static final String showOnlyWidgetsKey = "io.flutter.showOnlyWidgets";
    private static final String syncAndroidLibrariesKey = "io.flutter.syncAndroidLibraries";
    private static final String showStructuredErrorsKey = "io.flutter.showStructuredErrors";
    private static final String includeAllStackTracesKey = "io.flutter.includeAllStackTraces";
    private static final String showBuildMethodGuidesKey = "io.flutter.editor.showBuildMethodGuides";
    private static final String enableHotUiKey = "io.flutter.editor.enableHotUi";
    private static final String enableBazelHotRestartKey = "io.flutter.editor.enableBazelHotRestart";
    private static final String showBazelHotRestartWarningKey = "io.flutter.showBazelHotRestartWarning";
    private static final String enableJcefBrowserKey = "io.flutter.enableJcefBrowser";
    private static final String fontPackagesKey = "io.flutter.fontPackages";
    private static final String allowTestsInSourcesRootKey = "io.flutter.allowTestsInSources";
    private static final String showBazelIosRunNotificationKey = "io.flutter.hideBazelIosRunNotification";
    private static final String changeBigSurToTrueKey = "io.flutter.setBigSurToTrueKey2";
    private static final String suggestAllRunConfigurationsFromContextKey = "suggest.all.run.configurations.from.context";
    private static FlutterSettings testInstance;
    private final EventDispatcher<Listener> dispatcher = EventDispatcher.create(Listener.class);

    @VisibleForTesting
    public static void setInstance(FlutterSettings instance) {
        testInstance = instance;
    }

    public static FlutterSettings getInstance() {
        if (testInstance != null) {
            return testInstance;
        }
        return (FlutterSettings)ServiceManager.getService(FlutterSettings.class);
    }

    protected static PropertiesComponent getPropertiesComponent() {
        return PropertiesComponent.getInstance();
    }

    public void sendSettingsToAnalytics(Analytics analytics) {
        analytics.sendEvent("settings", "ping");
        if (this.isReloadOnSave()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(reloadOnSaveKey));
        }
        if (this.isOpenInspectorOnAppLaunch()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(openInspectorOnAppLaunchKey));
        }
        if (this.isPerserveLogsDuringHotReloadAndRestart()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(perserveLogsDuringHotReloadAndRestartKey));
        }
        if (this.isFormatCodeOnSave()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(formatCodeOnSaveKey));
            if (this.isOrganizeImportsOnSave()) {
                analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(organizeImportsOnSaveKey));
            }
        }
        if (this.isShowOnlyWidgets()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showOnlyWidgetsKey));
        }
        if (this.isSyncingAndroidLibraries()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(syncAndroidLibrariesKey));
        }
        if (this.isShowBuildMethodGuides()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showBuildMethodGuidesKey));
        }
        if (this.isShowStructuredErrors()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showStructuredErrorsKey));
            if (this.isIncludeAllStackTraces()) {
                analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(includeAllStackTracesKey));
            }
        }
        if (this.showAllRunConfigurationsInContext()) {
            analytics.sendEvent("settings", "showAllRunConfigurations");
        }
        if (this.isEnableHotUi()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(enableHotUiKey));
        }
        if (this.isShowBazelHotRestartWarning()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showBazelHotRestartWarningKey));
        }
        if (this.isChangeBigSurToTrue()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(changeBigSurToTrueKey));
        }
        if (this.isAllowTestsInSourcesRoot()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(allowTestsInSourcesRootKey));
        }
        if (!this.getFontPackages().isEmpty()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(fontPackagesKey));
        }
        if (this.isShowBazelIosRunNotification()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showBazelIosRunNotificationKey));
        }
    }

    public void addListener(Listener listener) {
        this.dispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.dispatcher.removeListener((EventListener)listener);
    }

    public boolean isReloadOnSave() {
        return FlutterSettings.getPropertiesComponent().getBoolean(reloadOnSaveKey, true);
    }

    public void setReloadOnSave(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(reloadOnSaveKey, value, true);
        this.fireEvent();
    }

    public boolean isFormatCodeOnSave() {
        return FlutterSettings.getPropertiesComponent().getBoolean(formatCodeOnSaveKey, false);
    }

    public void setFormatCodeOnSave(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(formatCodeOnSaveKey, value, false);
        this.fireEvent();
    }

    public boolean isOrganizeImportsOnSave() {
        return FlutterSettings.getPropertiesComponent().getBoolean(organizeImportsOnSaveKey, false);
    }

    public void setOrganizeImportsOnSave(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(organizeImportsOnSaveKey, value, false);
        this.fireEvent();
    }

    public boolean isShowOnlyWidgets() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showOnlyWidgetsKey, false);
    }

    public void setShowOnlyWidgets(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showOnlyWidgetsKey, value, false);
        this.fireEvent();
    }

    public boolean isSyncingAndroidLibraries() {
        return FlutterSettings.getPropertiesComponent().getBoolean(syncAndroidLibrariesKey, false);
    }

    public void setSyncingAndroidLibraries(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(syncAndroidLibrariesKey, value, false);
        this.fireEvent();
    }

    public boolean isShowStructuredErrors() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showStructuredErrorsKey, true);
    }

    public void setShowStructuredErrors(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showStructuredErrorsKey, value, true);
        this.fireEvent();
    }

    public boolean isIncludeAllStackTraces() {
        return FlutterSettings.getPropertiesComponent().getBoolean(includeAllStackTracesKey, true);
    }

    public void setIncludeAllStackTraces(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(includeAllStackTracesKey, value, true);
        this.fireEvent();
    }

    public boolean isOpenInspectorOnAppLaunch() {
        return FlutterSettings.getPropertiesComponent().getBoolean(openInspectorOnAppLaunchKey, false);
    }

    public void setOpenInspectorOnAppLaunch(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(openInspectorOnAppLaunchKey, value, false);
        this.fireEvent();
    }

    public boolean isPerserveLogsDuringHotReloadAndRestart() {
        return FlutterSettings.getPropertiesComponent().getBoolean(perserveLogsDuringHotReloadAndRestartKey, false);
    }

    public void setPerserveLogsDuringHotReloadAndRestart(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(perserveLogsDuringHotReloadAndRestartKey, value, false);
        this.fireEvent();
    }

    public boolean showAllRunConfigurationsInContext() {
        return Registry.is((String)suggestAllRunConfigurationsFromContextKey, (boolean)false);
    }

    public void setShowAllRunConfigurationsInContext(boolean value) {
        Registry.get((String)suggestAllRunConfigurationsFromContextKey).setValue(value);
        this.fireEvent();
    }

    public void setEnableJcefBrowser(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(enableJcefBrowserKey, value, false);
        this.fireEvent();
    }

    public boolean isVerboseLogging() {
        return FlutterSettings.getPropertiesComponent().getBoolean(verboseLoggingKey, false);
    }

    public void setVerboseLogging(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(verboseLoggingKey, value, false);
        this.fireEvent();
    }

    public boolean isShowBuildMethodGuides() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showBuildMethodGuidesKey, true);
    }

    public void setShowBuildMethodGuides(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showBuildMethodGuidesKey, value, true);
        this.fireEvent();
    }

    public boolean isShowClosingLabels() {
        return DartClosingLabelManager.getInstance().getShowClosingLabels();
    }

    public void setShowClosingLabels(boolean value) {
        DartClosingLabelManager.getInstance().setShowClosingLabels(value);
    }

    public String getFontPackages() {
        return FlutterSettings.getPropertiesComponent().getValue(fontPackagesKey, "");
    }

    public void setFontPackages(String value) {
        FlutterSettings.getPropertiesComponent().setValue(fontPackagesKey, value == null ? "" : value);
    }

    protected void fireEvent() {
        ((Listener)this.dispatcher.getMulticaster()).settingsChanged();
    }

    private static String afterLastPeriod(String str) {
        int index = str.lastIndexOf(46);
        return index == -1 ? str : str.substring(index + 1);
    }

    public boolean isEnableHotUi() {
        return FlutterSettings.getPropertiesComponent().getBoolean(enableHotUiKey, false);
    }

    public void setEnableHotUi(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(enableHotUiKey, value, false);
        this.fireEvent();
    }

    public boolean isEnableHotUiInCodeEditor() {
        return false;
    }

    public boolean isEnableBazelHotRestart() {
        return FlutterSettings.getPropertiesComponent().getBoolean(enableBazelHotRestartKey, false);
    }

    public void setEnableBazelHotRestart(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(enableBazelHotRestartKey, value, false);
        this.fireEvent();
    }

    public boolean isShowBazelHotRestartWarning() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showBazelHotRestartWarningKey, true);
    }

    public void setShowBazelHotRestartWarning(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showBazelHotRestartWarningKey, value, true);
        this.fireEvent();
    }

    public boolean isChangeBigSurToTrue() {
        return FlutterSettings.getPropertiesComponent().getBoolean(changeBigSurToTrueKey, true);
    }

    public void setChangeBigSurToTrue(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(changeBigSurToTrueKey, value, true);
        this.fireEvent();
    }

    public boolean isAllowTestsInSourcesRoot() {
        return FlutterSettings.getPropertiesComponent().getBoolean(allowTestsInSourcesRootKey, false);
    }

    public void setAllowTestsInSourcesRoot(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(allowTestsInSourcesRootKey, value, false);
        this.fireEvent();
    }

    public boolean isShowBazelIosRunNotification() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showBazelIosRunNotificationKey, true);
    }

    public void setShowBazelIosRunNotification(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showBazelIosRunNotificationKey, value, true);
        this.fireEvent();
    }

    public static interface Listener
    extends EventListener {
        public void settingsChanged();
    }
}

