/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.survey;

import com.google.gson.JsonObject;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;

public class FlutterSurvey {
    final String uniqueId;
    final ZonedDateTime startDate;
    final ZonedDateTime endDate;
    final String title;
    final String urlPrefix;

    FlutterSurvey(String uniqueId, String startDate, String endDate, String title, String urlPrefix) {
        this.uniqueId = uniqueId;
        this.startDate = FlutterSurvey.parseDate(startDate);
        this.endDate = FlutterSurvey.parseDate(endDate);
        this.title = title;
        this.urlPrefix = urlPrefix;
    }

    private static ZonedDateTime parseDate(String date) {
        return ZonedDateTime.from(DateTimeFormatter.ISO_ZONED_DATE_TIME.parse(date));
    }

    public static FlutterSurvey fromJson(@NotNull JsonObject json) {
        if (json == null) {
            FlutterSurvey.$$$reportNull$$$0(0);
        }
        return new FlutterSurvey(json.getAsJsonPrimitive("uniqueId").getAsString(), json.getAsJsonPrimitive("startDate").getAsString(), json.getAsJsonPrimitive("endDate").getAsString(), json.getAsJsonPrimitive("title").getAsString(), json.getAsJsonPrimitive("url").getAsString());
    }

    boolean isSurveyOpen() {
        ZonedDateTime now = ZonedDateTime.now();
        return (now.isEqual(this.startDate) || now.isAfter(this.startDate)) && now.isBefore(this.endDate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "io/flutter/survey/FlutterSurvey", "fromJson"));
    }
}

