/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.survey;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.DartFileType;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.pub.PubRoot;
import io.flutter.survey.FlutterSurvey;
import io.flutter.survey.FlutterSurveyService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class FlutterSurveyNotifications {
    private static final int NOTIFICATION_DELAY_IN_SECS = 3;
    private static final String FLUTTER_LAST_SURVEY_PROMPT_KEY = "FLUTTER_LAST_SURVEY_PROMPT_KEY";
    private static final long PROMPT_INTERVAL_IN_MS = TimeUnit.HOURS.toMillis(40L);
    private static final String SURVEY_ACTION_TEXT = "Take survey";
    private static final String SURVEY_DISMISSAL_TEXT = "No thanks";
    @NotNull
    final Project myProject;

    FlutterSurveyNotifications(@NotNull Project project) {
        if (project == null) {
            FlutterSurveyNotifications.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static void init(final @NotNull Project project) {
        if (project == null) {
            FlutterSurveyNotifications.$$$reportNull$$$0(1);
        }
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.check(file);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                VirtualFile file;
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((file = event.getNewFile()) != null) {
                    this.check(file);
                }
            }

            private void check(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (PubRoot.isPubspec(file) || file.getFileType() == DartFileType.INSTANCE) {
                    new FlutterSurveyNotifications(project).checkForDisplaySurvey();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/survey/FlutterSurveyNotifications$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "check";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void checkForDisplaySurvey() {
        final FlutterSurvey survey = FlutterSurveyService.getLatestSurveyContent();
        if (survey == null) {
            return;
        }
        if (!survey.isSurveyOpen()) {
            return;
        }
        final PropertiesComponent properties = PropertiesComponent.getInstance();
        long lastPromptedMillis = properties.getLong(FLUTTER_LAST_SURVEY_PROMPT_KEY, 0L);
        if (System.currentTimeMillis() - lastPromptedMillis < PROMPT_INTERVAL_IN_MS) {
            return;
        }
        properties.setValue(FLUTTER_LAST_SURVEY_PROMPT_KEY, String.valueOf(System.currentTimeMillis()));
        if (properties.getBoolean(survey.uniqueId)) {
            return;
        }
        final boolean reportAnalytics = FlutterInitializer.getCanReportAnalytics();
        final Notification notification = new Notification("Flutter Messages", FlutterIcons.Flutter, survey.title, null, null, NotificationType.INFORMATION, null);
        notification.addAction(new AnAction(SURVEY_ACTION_TEXT){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                properties.setValue(survey.uniqueId, true);
                notification.expire();
                String url = survey.urlPrefix + "?Source=IntelliJ";
                if (reportAnalytics) {
                    FlutterInitializer.getAnalytics().sendEvent("intellij", "SurveyPromptAccepted");
                }
                BrowserUtil.browse((String)url);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/survey/FlutterSurveyNotifications$2", "actionPerformed"));
            }
        });
        notification.addAction(new AnAction(SURVEY_DISMISSAL_TEXT){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (reportAnalytics) {
                    FlutterInitializer.getAnalytics().sendEvent("intellij", "SurveyPromptDismissed");
                }
                properties.setValue(survey.uniqueId, true);
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/survey/FlutterSurveyNotifications$3", "actionPerformed"));
            }
        });
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.schedule(() -> {
            if (!this.myProject.isDisposed()) {
                if (reportAnalytics) {
                    FlutterInitializer.getAnalytics().sendEvent("intellij", "SurveyPromptShown");
                }
                Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
            }
        }, 3L, TimeUnit.SECONDS);
        scheduler.shutdown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "io/flutter/survey/FlutterSurveyNotifications";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface FlutterSurveyNotifier {
        public void prompt();
    }
}

