/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.survey;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import io.flutter.survey.FlutterSurvey;
import io.flutter.utils.JsonUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class FlutterSurveyService {
    private static final String FLUTTER_LAST_SURVEY_CONTENT_CHECK_KEY = "FLUTTER_LAST_SURVEY_CONTENT_CHECK_KEY";
    private static final long CHECK_INTERVAL_IN_MS = TimeUnit.HOURS.toMillis(40L);
    private static final String CONTENT_URL = "https://docs.flutter.dev/f/flutter-survey-metadata.json";
    private static final PropertiesComponent properties = PropertiesComponent.getInstance();
    private static final Logger LOG = Logger.getInstance(FlutterSurveyService.class);
    private static FlutterSurvey cachedSurvey;

    private static boolean timeToUpdateCachedContent() {
        long lastCheckedMillis;
        boolean timeToUpdateCache;
        long currentTimeMillis = System.currentTimeMillis();
        boolean bl = timeToUpdateCache = currentTimeMillis - (lastCheckedMillis = properties.getLong(FLUTTER_LAST_SURVEY_CONTENT_CHECK_KEY, 0L)) >= CHECK_INTERVAL_IN_MS;
        if (timeToUpdateCache) {
            properties.setValue(FLUTTER_LAST_SURVEY_CONTENT_CHECK_KEY, String.valueOf(currentTimeMillis));
            return true;
        }
        return false;
    }

    @Nullable
    static FlutterSurvey getLatestSurveyContent() {
        if (FlutterSurveyService.timeToUpdateCachedContent()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                cachedSurvey = FlutterSurveyService.fetchSurveyContent();
            });
        }
        return cachedSurvey;
    }

    @Nullable
    private static FlutterSurvey fetchSurveyContent() {
        try {
            String contents = HttpRequests.request((String)CONTENT_URL).readString();
            JsonObject json = JsonUtils.parseString(contents).getAsJsonObject();
            return FlutterSurvey.fromJson(json);
        }
        catch (JsonSyntaxException | IOException throwable) {
            return null;
        }
    }
}

