/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.toolwindow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import org.jetbrains.annotations.NotNull;

public class FlutterViewToolWindowManagerListener
implements ToolWindowManagerListener {
    private boolean inspectorIsOpen;
    private Runnable onWindowOpen;
    private Runnable onWindowFirstVisible;

    public FlutterViewToolWindowManagerListener(Project project, ToolWindow toolWindow) {
        project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)this);
        this.inspectorIsOpen = toolWindow.isShowStripeButton();
    }

    public void updateOnWindowOpen(Runnable onWindowOpen) {
        this.onWindowOpen = onWindowOpen;
    }

    public void updateOnWindowFirstVisible(Runnable onWindowFirstVisible) {
        this.onWindowFirstVisible = onWindowFirstVisible;
    }

    public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
        ToolWindow inspectorWindow;
        if (toolWindowManager == null) {
            FlutterViewToolWindowManagerListener.$$$reportNull$$$0(0);
        }
        if ((inspectorWindow = toolWindowManager.getToolWindow("Flutter Inspector")) == null) {
            return;
        }
        boolean newIsOpen = inspectorWindow.isShowStripeButton();
        if (newIsOpen != this.inspectorIsOpen) {
            this.inspectorIsOpen = newIsOpen;
            if (newIsOpen && this.onWindowOpen != null) {
                this.onWindowOpen.run();
            }
        }
        if (inspectorWindow.isVisible() && this.onWindowFirstVisible != null) {
            this.onWindowFirstVisible.run();
            this.onWindowFirstVisible = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "io/flutter/toolwindow/FlutterViewToolWindowManagerListener", "stateChanged"));
    }
}

