/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.java.IKeywordElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUtils {
    private static final Lexer JAVA_LEXER = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);
    public static final String FLUTTER_MODULE_NAME = "flutter";

    @Nullable
    public static String validateAndroidPackageName(@NotNull String name) {
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(0);
        }
        if (name.isEmpty()) {
            return "Package name is missing";
        }
        String packageManagerCheck = AndroidUtils.validateName(name, true);
        if (packageManagerCheck != null) {
            return packageManagerCheck;
        }
        int index = 0;
        while (true) {
            String error;
            int index1;
            if ((index1 = name.indexOf(46, index)) < 0) {
                index1 = name.length();
            }
            if ((error = AndroidUtils.isReservedKeyword(name.substring(index, index1))) != null) {
                return error;
            }
            if (index1 == name.length()) break;
            index = index1 + 1;
        }
        return null;
    }

    @Nullable
    public static String isReservedKeyword(@NotNull String string) {
        if (string == null) {
            AndroidUtils.$$$reportNull$$$0(1);
        }
        Lexer lexer = JAVA_LEXER;
        lexer.start((CharSequence)string);
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            if (lexer.getTokenType() instanceof IKeywordElementType) {
                return "Package names cannot contain Java keywords like '" + string + "'";
            }
            if (string.isEmpty()) {
                return "Package segments must be of non-zero length";
            }
            return string + " is not a valid identifier";
        }
        return null;
    }

    @Nullable
    private static String validateName(String name, boolean requiresSeparator) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                if (!front) continue;
                if (c == '_') {
                    return "The character '_' cannot be the first character in a package segment";
                }
                return "A digit cannot be the first character in a package segment";
            }
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "The character '" + c + "' is not allowed in Android application package names";
        }
        return hasSep || !requiresSeparator ? null : "The package must have at least one '.' separator";
    }

    public static boolean isAndroidProject(@Nullable Project project) {
        ProjectType projectType = ProjectTypeService.getProjectType((Project)project);
        return projectType != null && "Android".equals(projectType.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        objectArray2[1] = "io/flutter/utils/AndroidUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAndroidPackageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isReservedKeyword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

