/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.google.common.util.concurrent.RateLimiter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Alarm;
import java.util.concurrent.CompletableFuture;
import javax.swing.SwingUtilities;

public class AsyncRateLimiter {
    private static final Logger LOG = Logger.getInstance(AsyncRateLimiter.class);
    private final String requestScheduleLock = "requestScheduleLock";
    private final RateLimiter rateLimiter;
    private final Alarm requestScheduler;
    private final Computable<CompletableFuture<?>> callback;
    private volatile int numRequestsPending;
    private volatile int numRequestsExecuting;

    public AsyncRateLimiter(double framesPerSecond, Computable<CompletableFuture<?>> callback, Disposable parentDisposable) {
        this.callback = callback;
        this.rateLimiter = RateLimiter.create((double)framesPerSecond);
        this.requestScheduler = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRequest() {
        String string = "requestScheduleLock";
        synchronized ("requestScheduleLock") {
            boolean scheduleRequestImmediately;
            boolean bl = scheduleRequestImmediately = this.numRequestsPending == 0;
            assert (this.numRequestsPending >= 0);
            assert (this.numRequestsPending < 3);
            assert (this.numRequestsExecuting < 2);
            int numRequestsNotYetStarted = this.numRequestsPending - this.numRequestsExecuting;
            if (numRequestsNotYetStarted == 0) {
                ++this.numRequestsPending;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (scheduleRequestImmediately) {
                this.scheduleRequestHelper();
            }
            return;
        }
    }

    public void scheduleRequestHelper() {
        if (this.requestScheduler.isDisposed()) {
            return;
        }
        this.requestScheduler.addRequest(() -> {
            this.rateLimiter.acquire();
            this.performRequestOnUiThread();
        }, 0);
    }

    private void performRequestOnUiThread() {
        Runnable doRun = () -> {
            if (this.requestScheduler.isDisposed()) {
                return;
            }
            this.performRequest();
        };
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            SwingUtilities.invokeLater(doRun);
        } else {
            app.invokeLater(doRun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRequest() {
        String string = "requestScheduleLock";
        synchronized ("requestScheduleLock") {
            assert (this.numRequestsPending > 0);
            assert (this.numRequestsExecuting == 0);
            ++this.numRequestsExecuting;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                CompletableFuture requestComplete = (CompletableFuture)this.callback.compute();
                requestComplete.whenCompleteAsync((v, e) -> this.onRequestComplete());
            }
            catch (Exception e2) {
                LOG.warn((Throwable)e2);
                this.onRequestComplete();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRequestComplete() {
        String string = "requestScheduleLock";
        synchronized ("requestScheduleLock") {
            assert (this.numRequestsPending > 0);
            assert (this.numRequestsExecuting == 1);
            --this.numRequestsPending;
            --this.numRequestsExecuting;
            boolean requestsPending = this.numRequestsPending > 0;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (requestsPending) {
                this.scheduleRequestHelper();
            }
            return;
        }
    }
}

