/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;

public class AsyncUtils {
    public static <T> void whenCompleteUiThread(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action) {
        future.whenCompleteAsync((value, throwable) -> {
            if (throwable instanceof CancellationException) {
                return;
            }
            AsyncUtils.invokeLater(() -> action.accept((Object)value, (Throwable)throwable));
        });
    }

    public static void invokeLater(Runnable runnable) {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            app.invokeLater(runnable);
        }
    }

    public static void invokeAndWait(Runnable runnable) throws ProcessCanceledException {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
        } else {
            app.invokeAndWait(runnable);
        }
    }
}

