/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class ColorIconMaker {
    private final Map<Color, Icon> iconCache = new HashMap<Color, Icon>();
    private static final int iconMargin = 3;

    public Icon getCustomIcon(final Color color) {
        if (!this.iconCache.containsKey(color)) {
            Icon icon = new Icon(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    try {
                        GraphicsUtil.setupAAPainting((Graphics)g2);
                        g2.setColor((Color)JBColor.white);
                        g2.fillRect(x + 3, y + 3, this.getIconWidth() - 6, this.getIconHeight() - 6);
                        g2.setColor((Color)JBColor.gray);
                        g2.fillRect(x + 3, y + 3, this.getIconWidth() / 2 - 3, this.getIconHeight() / 2 - 3);
                        g2.fillRect(x + this.getIconWidth() / 2, y + this.getIconHeight() / 2, this.getIconWidth() / 2 - 3, this.getIconHeight() / 2 - 3);
                        g2.setColor(color);
                        g2.fillRect(x + 3, y + 3, this.getIconWidth() - 6, this.getIconHeight() - 6);
                        g2.setColor((Color)JBColor.black);
                        g2.drawRect(x + 3, y + 3, this.getIconWidth() - 6, this.getIconHeight() - 6);
                    }
                    finally {
                        g2.dispose();
                    }
                }

                @Override
                public int getIconWidth() {
                    return 22;
                }

                @Override
                public int getIconHeight() {
                    return 22;
                }
            };
            this.iconCache.put(color, icon);
        }
        return this.iconCache.get(color);
    }
}

