/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import icons.FlutterIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class CustomIconMaker {
    private static final Color normalColor = ColorUtil.fromHex((String)"231F20");
    private final Map<String, Icon> iconCache = new HashMap<String, Icon>();

    public Icon getCustomIcon(String fromText) {
        return this.getCustomIcon(fromText, IconKind.kClass, false);
    }

    public Icon getCustomIcon(String fromText, IconKind kind) {
        return this.getCustomIcon(fromText, kind, false);
    }

    public Icon getCustomIcon(String fromText, IconKind kind, boolean isAbstract) {
        if (StringUtil.isEmpty((String)fromText)) {
            return null;
        }
        final String text = fromText.toUpperCase().substring(0, 1);
        String mapKey = text + "_" + kind.name + "_" + isAbstract;
        if (!this.iconCache.containsKey(mapKey)) {
            final Icon baseIcon = isAbstract ? kind.abstractIcon : kind.icon;
            LayeredIcon icon = new LayeredIcon(new Icon[]{baseIcon, new Icon(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    try {
                        GraphicsUtil.setupAAPainting((Graphics)g2);
                        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        g2.setColor(normalColor);
                        Font font = UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.MINI, (Font)UIUtil.getTreeFont());
                        g2.setFont(font);
                        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(text, g2);
                        float offsetX = ((float)this.getIconWidth() - (float)bounds.getWidth()) / 2.0f;
                        float offsetY = (float)this.getIconHeight() - ((float)this.getIconHeight() - (float)bounds.getHeight()) / 2.0f - 2.0f;
                        g2.drawString(text, (float)x + offsetX, (float)y + offsetY);
                    }
                    finally {
                        g2.dispose();
                    }
                }

                @Override
                public int getIconWidth() {
                    return baseIcon != null ? baseIcon.getIconWidth() : 13;
                }

                @Override
                public int getIconHeight() {
                    return baseIcon != null ? baseIcon.getIconHeight() : 13;
                }
            }});
            this.iconCache.put(mapKey, (Icon)icon);
        }
        return this.iconCache.get(mapKey);
    }

    @Nullable
    public Icon fromWidgetName(String name) {
        if (name == null) {
            return null;
        }
        boolean isPrivate = name.startsWith("_");
        while (!name.isEmpty() && !Character.isAlphabetic(name.charAt(0))) {
            name = name.substring(1);
        }
        if (name.isEmpty()) {
            return null;
        }
        return this.getCustomIcon(name, isPrivate ? IconKind.kMethod : IconKind.kClass);
    }

    public Icon fromInfo(String name) {
        if (name == null) {
            return null;
        }
        if (name.isEmpty()) {
            return null;
        }
        return this.getCustomIcon(name, IconKind.kInfo);
    }

    public static enum IconKind {
        kClass("class", FlutterIcons.CustomClass, FlutterIcons.CustomClassAbstract),
        kField("fields", FlutterIcons.CustomFields),
        kInterface("interface", FlutterIcons.CustomInterface),
        kMethod("method", FlutterIcons.CustomMethod, FlutterIcons.CustomMethodAbstract),
        kProperty("property", FlutterIcons.CustomProperty),
        kInfo("info", FlutterIcons.CustomInfo);

        public final String name;
        public final Icon icon;
        public final Icon abstractIcon;

        private IconKind(String name, Icon icon) {
            this.name = name;
            this.icon = icon;
            this.abstractIcon = icon;
        }

        private IconKind(String name, Icon icon, Icon abstractIcon) {
            this.name = name;
            this.icon = icon;
            this.abstractIcon = abstractIcon;
        }
    }
}

