/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.EdtInvocationManager;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;

class EnableDartSupportForModule
implements Runnable {
    private final Module myModule;

    EnableDartSupportForModule(@NotNull Module module) {
        if (module == null) {
            EnableDartSupportForModule.$$$reportNull$$$0(0);
        }
        this.myModule = module;
    }

    @Override
    public void run() {
        Project project = this.myModule.getProject();
        EdtInvocationManager.getInstance().invokeLater(() -> ApplicationManager.getApplication().invokeLater(() -> {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (DartSdk.getDartSdk((Project)project) == null || !DartSdkLibUtil.isDartSdkEnabled((Module)this.myModule)) {
                    String sdkPath = DartSdkUtil.getFirstKnownDartSdkPath();
                    if (DartSdkUtil.isDartSdkHome((String)sdkPath)) {
                        DartSdkLibUtil.ensureDartSdkConfigured((Project)project, (String)sdkPath);
                        DartSdkLibUtil.enableDartSdk((Module)this.myModule);
                    } else {
                        FlutterModuleUtils.enableDartSDK(this.myModule);
                    }
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(() -> ApplicationManager.getApplication().runReadAction(() -> DartAnalysisServerService.getInstance((Project)project).serverReadyForRequest()));
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "io/flutter/utils/EnableDartSupportForModule", "<init>"));
    }
}

