/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.lang.UrlClassLoader;
import com.jetbrains.lang.dart.DartFileType;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    private static FileUtils fileUtils;

    public static FileUtils getInstance() {
        if (fileUtils == null) {
            fileUtils = new FileUtils();
        }
        return fileUtils;
    }

    public boolean makeDirectory(String path) {
        File directory = new File(path);
        if (!directory.exists()) {
            return directory.mkdirs();
        }
        return true;
    }

    public boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public boolean deleteFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public void loadClass(ClassLoader classLoader, String path) throws Exception {
        UrlClassLoader urlClassLoader = (UrlClassLoader)classLoader;
        File file = new File(path);
        if (!file.exists()) {
            throw new Exception("File does not exist: " + file.getAbsolutePath());
        }
        URL url = file.toURI().toURL();
        urlClassLoader.addURL(url);
    }

    public void loadPaths(ClassLoader classLoader, List<Path> paths) {
        UrlClassLoader urlClassLoader = (UrlClassLoader)classLoader;
        urlClassLoader.addFiles(paths);
    }

    public static boolean isDartFile(@NotNull VirtualFile file) {
        if (file == null) {
            FileUtils.$$$reportNull$$$0(0);
        }
        return file.getFileType().equals((Object)DartFileType.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "io/flutter/utils/FileUtils", "isDartFile"));
    }
}

