/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.util.TripleFunction;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFile;
import io.flutter.FlutterUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconPreviewGenerator {
    private static final Logger LOG = Logger.getInstance(IconPreviewGenerator.class);
    @NotNull
    final String fontFilePath;
    int iconSize;
    int fontSize;
    @NotNull
    Color fontColor;

    public IconPreviewGenerator(@NotNull String fontFilePath) {
        if (fontFilePath == null) {
            IconPreviewGenerator.$$$reportNull$$$0(0);
        }
        this.iconSize = 16;
        this.fontSize = 16;
        this.fontColor = Color.gray;
        this.fontFilePath = fontFilePath;
    }

    public IconPreviewGenerator(@NotNull String fontFilePath, int iconSize, int fontSize, @Nullable Color fontColor) {
        if (fontFilePath == null) {
            IconPreviewGenerator.$$$reportNull$$$0(1);
        }
        this(fontFilePath);
        this.iconSize = iconSize;
        this.fontSize = fontSize;
        if (fontColor != null) {
            this.fontColor = fontColor;
        }
    }

    public Icon convert(String number) {
        int codepoint;
        if (number.startsWith("0x") || number.startsWith("0X")) {
            number = number.substring(2);
            codepoint = Integer.parseInt(number, 16);
        } else {
            codepoint = Integer.parseInt(number, 10);
        }
        return this.convert(codepoint);
    }

    public Icon convert(int code) {
        return this.runInGraphicsContext((TripleFunction<BufferedImage, Graphics2D, FontRenderContext, Icon>)((TripleFunction)(image, graphics, frc) -> {
            char ch = Character.toChars(code)[0];
            String codepoint = Character.toString(ch);
            this.drawGlyph(codepoint, (Graphics2D)graphics, (FontRenderContext)frc);
            return new ImageIcon((Image)image);
        }));
    }

    public void batchConvert(@NotNull String outPath, @NotNull String path, @NotNull String suffix) {
        if (outPath == null) {
            IconPreviewGenerator.$$$reportNull$$$0(2);
        }
        if (path == null) {
            IconPreviewGenerator.$$$reportNull$$$0(3);
        }
        if (suffix == null) {
            IconPreviewGenerator.$$$reportNull$$$0(4);
        }
        Object outputPath = outPath.endsWith("/") ? outPath : outPath + "/";
        new File((String)outputPath).mkdirs();
        this.runInGraphicsContext((TripleFunction<BufferedImage, Graphics2D, FontRenderContext, Icon>)((TripleFunction)(arg_0, arg_1, arg_2) -> this.lambda$batchConvert$1(path, (String)outputPath, suffix, arg_0, arg_1, arg_2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon runInGraphicsContext(TripleFunction<BufferedImage, Graphics2D, FontRenderContext, Icon> callback) {
        Icon result = null;
        Graphics graphics = null;
        BufferedImage image = new BufferedImage(this.iconSize, this.iconSize, 6);
        try (FileInputStream inputStream = new FileInputStream(this.fontFilePath);){
            Font font = Font.createFont(0, inputStream).deriveFont(0, this.fontSize);
            graphics = image.createGraphics();
            graphics.setFont(font);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
            result = (Icon)callback.fun((Object)image, (Object)graphics, (Object)frc);
        }
        catch (FontFormatException | IOException ex) {
            FlutterUtils.warn(LOG, ex);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return result;
    }

    private void drawGlyph(String codepoint, Graphics2D graphics, FontRenderContext frc) {
        Font font = graphics.getFont();
        Rectangle2D rect = font.getStringBounds(codepoint, frc);
        LineMetrics metrics = font.getLineMetrics(codepoint, frc);
        float lineHeight = metrics.getHeight();
        float ascent = metrics.getAscent();
        float width = (float)rect.getWidth();
        float x0 = ((float)this.iconSize - width) / 2.0f;
        float y0 = ((float)this.iconSize - lineHeight) / 2.0f + ascent + (lineHeight - ascent) / 2.0f;
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, this.iconSize, this.iconSize);
        graphics.setComposite(AlphaComposite.Src);
        graphics.setColor(this.fontColor);
        graphics.drawString(codepoint, x0, y0);
    }

    @Nullable
    public static VirtualFile findAssetMapFor(@NotNull DartComponent dartClass) {
        ASTNode node;
        if (dartClass == null) {
            IconPreviewGenerator.$$$reportNull$$$0(5);
        }
        if (DartTokenTypes.CLASS_DEFINITION != (node = dartClass.getNode()).getElementType()) {
            return null;
        }
        DartFile psiElement = (DartFile)node.getPsi().getParent();
        VirtualFile file = psiElement.getVirtualFile();
        VirtualFile map = IconPreviewGenerator.findAssetMapIn(file.getParent());
        if (map != null) {
            return map;
        }
        PsiElement identifier = dartClass.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        String className = AstBufferUtil.getTextSkippingWhitespaceComments((ASTNode)identifier.getNode());
        URL resource = IconPreviewGenerator.class.getResource("/iconAssetMaps/" + className + "/asset_map.yaml");
        if (resource == null) {
            return null;
        }
        try {
            URI uri = resource.toURI();
            return LocalFileSystem.getInstance().findFileByNioFile(Paths.get(uri));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Nullable
    public static VirtualFile findAssetMapIn(@NotNull VirtualFile dartClass) {
        if (dartClass == null) {
            IconPreviewGenerator.$$$reportNull$$$0(6);
        }
        VirtualFile dir = dartClass.getParent();
        VirtualFile preview = null;
        while (dir != null && !dir.getName().equals("lib")) {
            preview = dir.findChild("ide_preview");
            if (preview == null) {
                dir = dir.getParent();
                continue;
            }
            dir = null;
        }
        if (preview == null && dir != null && dir.getName().equals("lib") && (preview = (dir = dir.getParent()).findChild("ide_preview")) == null) {
            return null;
        }
        return preview == null ? null : preview.findChild("asset_map.yaml");
    }

    private /* synthetic */ Icon lambda$batchConvert$1(String path, String outputPath, String suffix, BufferedImage image, Graphics2D graphics, FontRenderContext frc) {
        Properties fontMap = new Properties();
        File file = new File(path);
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            fontMap.load(stream);
            for (Object nextKey : fontMap.keySet()) {
                String codepoint;
                if (!(nextKey instanceof String) || !(codepoint = (String)nextKey).endsWith(".codepoint")) continue;
                String iconName = fontMap.getProperty(codepoint);
                codepoint = codepoint.substring(0, codepoint.indexOf(".codepoint"));
                int code = Integer.parseInt(codepoint, 16);
                char ch = Character.toChars(code)[0];
                codepoint = Character.toString(ch);
                this.drawGlyph(codepoint, graphics, frc);
                ImageIO.write((RenderedImage)image, "PNG", new File(outputPath + iconName + suffix + ".png"));
            }
        }
        catch (IOException ex) {
            FlutterUtils.warn(LOG, ex);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartClass";
                break;
            }
        }
        objectArray2[1] = "io/flutter/utils/IconPreviewGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "batchConvert";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findAssetMapFor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findAssetMapIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

