/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtils {
    private JsonUtils() {
    }

    @Nullable
    public static String getStringMember(@NotNull JsonObject json, @NotNull String memberName) {
        if (json == null) {
            JsonUtils.$$$reportNull$$$0(0);
        }
        if (memberName == null) {
            JsonUtils.$$$reportNull$$$0(1);
        }
        if (!json.has(memberName)) {
            return null;
        }
        JsonElement value = json.get(memberName);
        return value instanceof JsonNull ? null : value.getAsString();
    }

    public static int getIntMember(@NotNull JsonObject json, @NotNull String memberName) {
        if (json == null) {
            JsonUtils.$$$reportNull$$$0(2);
        }
        if (memberName == null) {
            JsonUtils.$$$reportNull$$$0(3);
        }
        if (!json.has(memberName)) {
            return -1;
        }
        JsonElement value = json.get(memberName);
        return value instanceof JsonNull ? -1 : value.getAsInt();
    }

    @NotNull
    public static List<String> getValues(@NotNull JsonObject json, @NotNull String member) {
        if (json == null) {
            JsonUtils.$$$reportNull$$$0(4);
        }
        if (member == null) {
            JsonUtils.$$$reportNull$$$0(5);
        }
        if (!json.has(member)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JsonUtils.$$$reportNull$$$0(6);
            }
            return list;
        }
        JsonArray rawValues = json.getAsJsonArray(member);
        ArrayList<String> values = new ArrayList<String>(rawValues.size());
        rawValues.forEach(element -> values.add(element.getAsString()));
        ArrayList<String> arrayList = values;
        if (arrayList == null) {
            JsonUtils.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static Set<String> getKeySet(JsonObject obj) {
        Set entries = obj.entrySet();
        HashSet<String> strings = new HashSet<String>(entries.size());
        for (Map.Entry entry : entries) {
            strings.add((String)entry.getKey());
        }
        return strings;
    }

    public static boolean hasJsonData(@Nullable String data) {
        return StringUtils.isNotEmpty((CharSequence)data) && !Objects.equals(data, "null");
    }

    public static JsonElement parseString(String json) throws JsonSyntaxException {
        return JsonParser.parseString((String)json);
    }

    public static JsonElement parseReader(Reader reader) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader((Reader)reader);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/utils/JsonUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/utils/JsonUtils";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringMember";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntMember";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

