/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.flutter.FlutterUtils;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Refreshable<T>
implements Closeable {
    private final Schedule schedule = new Schedule();
    private final Publisher publisher;
    private final AtomicReference<Future> backgroundTask = new AtomicReference();
    private final Set<Runnable> subscribers = new LinkedHashSet<Runnable>();
    private final Disposable disposeNode;
    private static final Logger LOG = Logger.getInstance(Refreshable.class);

    public Refreshable() {
        this(null);
    }

    public Refreshable(Consumer<T> unpublish) {
        this.publisher = new Publisher(unpublish);
        this.disposeNode = this::close;
    }

    @Nullable
    public T getNow() {
        return this.publisher.get();
    }

    public State getState() {
        return this.publisher.state.get();
    }

    @Nullable
    public T getWhenReady() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("getWhenReady shouldn't be called from Swing dispatch thread");
        }
        this.publisher.waitForFirstValue();
        Future refreshDone = this.backgroundTask.get();
        if (refreshDone == null) {
            return this.getNow();
        }
        try {
            refreshDone.get();
        }
        catch (Exception e) {
            FlutterUtils.warn(LOG, "Unexpected exception waiting for refresh task to finish", e);
        }
        return this.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(@NotNull Runnable callback) {
        if (callback == null) {
            Refreshable.$$$reportNull$$$0(0);
        }
        Set<Runnable> set = this.subscribers;
        synchronized (set) {
            if (this.publisher.isClosing()) {
                throw new IllegalStateException("Can't subscribe to closed Refreshable");
            }
            this.subscribers.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(@NotNull Runnable callback) {
        if (callback == null) {
            Refreshable.$$$reportNull$$$0(1);
        }
        Set<Runnable> set = this.subscribers;
        synchronized (set) {
            this.subscribers.remove(callback);
        }
    }

    public void refresh(@NotNull Callable<T> callback) {
        if (callback == null) {
            Refreshable.$$$reportNull$$$0(2);
        }
        this.refresh((Request x) -> callback.call());
    }

    public void refresh(@NotNull Callback<T> callback) {
        if (callback == null) {
            Refreshable.$$$reportNull$$$0(3);
        }
        if (this.publisher.isClosing()) {
            FlutterUtils.warn(LOG, "attempted to update closed Refreshable");
            return;
        }
        this.schedule.reschedule(new Request<T>(this, callback));
        FutureTask<Object> next = new FutureTask<Object>(this::runInBackground, null);
        if (this.backgroundTask.compareAndSet(null, next)) {
            SwingUtilities.invokeLater(() -> AppExecutorUtil.getAppExecutorService().submit(next));
        }
    }

    @Override
    public void close() {
        if (!this.publisher.close()) {
            return;
        }
        this.schedule.reschedule(null);
        Disposer.dispose((Disposable)this.disposeNode);
    }

    public void setDisposeParent(Disposable parent) {
        Disposer.register((Disposable)parent, (Disposable)this.disposeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInBackground() {
        try {
            this.publisher.setState(State.BUSY);
            Request request = this.schedule.next();
            while (request != null) {
                try {
                    Object value = request.callback.call(request);
                    this.publisher.reschedule(value);
                }
                catch (CancellationException value) {
                }
                catch (Exception e) {
                    if (!Objects.equal((Object)e.getMessage(), (Object)"expected failure in test")) {
                        FlutterUtils.warn(LOG, "Callback threw an exception while updating a Refreshable", e);
                    }
                }
                finally {
                    this.schedule.done(request);
                }
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        if (!this.schedule.hasNext() && this.publisher.publish()) {
                            this.publisher.fireEvent();
                        }
                    });
                }
                catch (Exception e) {
                    FlutterUtils.warn(LOG, "Unable to publish a value while updating a Refreshable", e);
                }
                request = this.schedule.next();
            }
        }
        finally {
            this.publisher.setState(State.IDLE);
            this.backgroundTask.set(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "callback";
        objectArray2[1] = "io/flutter/utils/Refreshable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribe";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unsubscribe";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "refresh";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Schedule {
        @Nullable
        private Request<T> scheduled;
        @Nullable
        private Request<T> running;
        @Nullable
        private Request<T> cancelled;

        private Schedule() {
        }

        synchronized void reschedule(@Nullable Request<T> request) {
            this.scheduled = request;
            this.cancelled = this.running;
        }

        synchronized boolean hasNext() {
            return this.scheduled != null;
        }

        @Nullable
        synchronized Request<T> next() {
            assert (this.running == null);
            this.running = this.scheduled;
            this.scheduled = null;
            return this.running;
        }

        synchronized void done(@NotNull Request<T> request) {
            if (request == null) {
                Schedule.$$$reportNull$$$0(0);
            }
            assert (this.running != null);
            this.running = null;
            this.cancelled = null;
        }

        synchronized boolean isCancelled(Request<T> callback) {
            return callback == this.cancelled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "io/flutter/utils/Refreshable$Schedule", "done"));
        }
    }

    private class Publisher {
        @NotNull
        private final Consumer<T> unpublishCallback;
        @Nullable
        private T scheduled;
        @Nullable
        private T published;
        private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
        private final FutureTask initialized = new FutureTask<Object>(() -> null);
        private boolean needToPublish;
        private boolean closing;

        Publisher(Consumer<T> unpublish) {
            if (unpublish == null) {
                unpublish = x -> {};
            }
            this.unpublishCallback = unpublish;
        }

        synchronized void reschedule(@Nullable T toPublish) {
            if (this.scheduled != null && Objects.equal(toPublish, this.scheduled)) {
                return;
            }
            Object discarded = this.unschedule();
            if (discarded != null) {
                SwingUtilities.invokeLater(() -> this.unpublish(discarded));
            }
            if (this.initialized.isDone() && Objects.equal(toPublish, this.published)) {
                this.needToPublish = false;
                return;
            }
            if (this.closing) {
                if (toPublish != null) {
                    SwingUtilities.invokeLater(() -> this.unpublish(toPublish));
                }
                return;
            }
            this.scheduled = toPublish;
            this.needToPublish = true;
        }

        private synchronized T unschedule() {
            Object old = this.scheduled;
            this.scheduled = null;
            this.needToPublish = false;
            return old;
        }

        private synchronized T getPrevious() {
            if (this.needToPublish) {
                return this.scheduled;
            }
            return this.published;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean close() {
            Object wasScheduled;
            Publisher publisher = this;
            synchronized (publisher) {
                if (this.closing) {
                    return false;
                }
                wasScheduled = this.unschedule();
                this.closing = true;
            }
            Runnable callback = () -> {
                Object wasPublished;
                this.unpublish(wasScheduled);
                Object object = this;
                synchronized (object) {
                    wasPublished = this.published;
                    this.published = null;
                }
                this.unpublish(wasPublished);
                this.setState(State.CLOSED);
                object = Refreshable.this.subscribers;
                synchronized (object) {
                    Refreshable.this.subscribers.clear();
                }
                this.initialized.run();
            };
            Application application = ApplicationManager.getApplication();
            if (application != null && !application.isUnitTestMode()) {
                application.invokeAndWait(callback);
            } else {
                SwingUtilities.invokeLater(callback);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean publish() {
            Object discarded;
            assert (SwingUtilities.isEventDispatchThread());
            Publisher publisher = this;
            synchronized (publisher) {
                if (!this.needToPublish) {
                    return false;
                }
                discarded = this.published;
                this.published = this.unschedule();
                this.needToPublish = false;
                this.initialized.run();
            }
            if (discarded != null) {
                this.unpublish(discarded);
            }
            return true;
        }

        void unpublish(@Nullable T discarded) {
            assert (SwingUtilities.isEventDispatchThread());
            if (discarded == null) {
                return;
            }
            try {
                this.unpublishCallback.accept(discarded);
            }
            catch (Exception e) {
                FlutterUtils.warn(LOG, "An unpublish callback threw an exception while updating a Refreshable", e);
            }
        }

        void setState(State newState) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doSetState(newState);
                return;
            }
            try {
                SwingUtilities.invokeAndWait(() -> this.doSetState(newState));
            }
            catch (Exception e) {
                FlutterUtils.warn(LOG, "Unable to change state of Refreshable", e);
            }
        }

        private void doSetState(State newState) {
            State oldState = this.state.getAndSet(newState);
            if (oldState == newState) {
                return;
            }
            this.fireEvent();
        }

        private void fireEvent() {
            assert (SwingUtilities.isEventDispatchThread());
            for (Runnable sub : this.getSubscribers()) {
                try {
                    sub.run();
                }
                catch (Exception e) {
                    if (Objects.equal((Object)e.getMessage(), (Object)"expected failure in test")) continue;
                    FlutterUtils.warn(LOG, "A subscriber to a Refreshable threw an exception", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<Runnable> getSubscribers() {
            Set<Runnable> set = Refreshable.this.subscribers;
            synchronized (set) {
                return ImmutableSet.copyOf(Refreshable.this.subscribers);
            }
        }

        void waitForFirstValue() {
            try {
                this.initialized.get();
            }
            catch (Exception e) {
                FlutterUtils.warn(LOG, "Unexpected exception waiting for Refreshable to initialize", e);
            }
        }

        synchronized T get() {
            return this.published;
        }

        synchronized boolean isClosing() {
            return this.closing;
        }
    }

    public static enum State {
        BUSY,
        IDLE,
        CLOSED;

    }

    public static interface Callback<T> {
        public T call(Request var1) throws Exception;
    }

    public static class Request<T> {
        private final Refreshable<T> target;
        private final Callback<T> callback;

        Request(Refreshable<T> target, Callback<T> callback) {
            this.target = target;
            this.callback = callback;
        }

        public boolean isCancelled() {
            return this.target.schedule.isCancelled(this);
        }

        public T getPrevious() {
            return this.target.publisher.getPrevious();
        }
    }
}

