/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import java.util.ArrayList;
import java.util.List;

public class StdoutJsonParser {
    private final StringBuilder buffer = new StringBuilder();
    private boolean bufferIsJson = false;
    private final List<String> lines = new ArrayList<String>();
    private boolean eatNextEol = false;
    private boolean isPotentialWindowsReturn = false;

    public void appendOutput(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.eatNextEol) {
                this.eatNextEol = false;
                if (c == '\n') continue;
                if (c == '\r' && !this.isPotentialWindowsReturn) {
                    this.eatNextEol = true;
                    this.isPotentialWindowsReturn = true;
                    continue;
                }
            }
            if (this.isPotentialWindowsReturn) {
                this.isPotentialWindowsReturn = false;
                if (c != '\n') {
                    this.flushLine();
                }
            }
            this.buffer.append(c);
            if (!this.bufferIsJson && this.buffer.length() == 2 && this.buffer.charAt(0) == '[' && c == '{') {
                this.bufferIsJson = true;
            } else if (this.bufferIsJson && c == ']' && this.possiblyTerminatesJson(this.buffer, string, i)) {
                this.flushLine();
            }
            if (c == '\n') {
                this.flushLine();
            }
            if (c != '\r') continue;
            this.isPotentialWindowsReturn = true;
        }
        if (!this.bufferIsJson) {
            this.flushLine();
        } else if (this.buffer.toString().endsWith("}]")) {
            this.eatNextEol = true;
            this.flushLine();
        }
    }

    private boolean possiblyTerminatesJson(StringBuilder output, String input, int inputIndex) {
        if (output.length() < 2 || inputIndex + 1 >= input.length()) {
            return false;
        }
        char prev = output.charAt(output.length() - 2);
        char current = output.charAt(output.length() - 1);
        char next = input.charAt(inputIndex + 1);
        return prev == '}' && current == ']' && Character.isAlphabetic(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLine() {
        if (!this.buffer.isEmpty()) {
            List<String> list = this.lines;
            synchronized (list) {
                this.lines.add(this.buffer.toString());
            }
            this.buffer.setLength(0);
        }
        this.bufferIsJson = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAvailableLines() {
        List<String> list = this.lines;
        synchronized (list) {
            ArrayList<String> copy = new ArrayList<String>(this.lines);
            this.lines.clear();
            return copy;
        }
    }
}

