/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.openapi.Disposable;
import io.flutter.utils.EventStream;
import java.util.function.Consumer;

public class StreamSubscription<T>
implements Disposable {
    private final Consumer<T> onData;
    protected final boolean onUIThread;
    private EventStream<T> owner;
    private volatile boolean disposed = false;

    protected StreamSubscription(Consumer<T> onData, boolean onUIThread, EventStream<T> owner) {
        this.onData = onData;
        this.onUIThread = onUIThread;
        this.owner = owner;
    }

    public void dispose() {
        this.disposed = true;
        if (this.owner != null) {
            this.owner.removeSubscription(this);
            this.owner = null;
        }
    }

    protected void notify(T value) {
        if (!this.disposed) {
            this.onData.accept(value);
        }
    }
}

