/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class SystemUtils {
    @Nullable
    public static String which(String toolName) {
        File gitExecutableFromPath = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? toolName + ".exe" : toolName), (String)SystemUtils.getPath(), null);
        if (gitExecutableFromPath != null) {
            return gitExecutableFromPath.getAbsolutePath();
        }
        return null;
    }

    @Nullable
    private static String getPath() {
        return PathEnvironmentVariableUtil.getPathVariableValue();
    }

    public static CompletableFuture<ProcessOutput> execAndGetOutput(GeneralCommandLine cmd) {
        CompletableFuture<ProcessOutput> future = new CompletableFuture<ProcessOutput>();
        AppExecutorUtil.getAppExecutorService().submit(() -> {
            try {
                ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
                future.complete(output);
            }
            catch (ExecutionException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }
}

