/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public abstract class TypedDataList {
    public abstract String getValue(int var1);

    public abstract int size();

    public static class Float64List
    extends TypedDataList {
        final DoubleBuffer buffer;

        public Float64List(byte[] bytes) {
            this.buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        }

        @Override
        public String getValue(int i) {
            return String.valueOf(this.buffer.get(i));
        }

        @Override
        public int size() {
            return this.buffer.capacity();
        }
    }

    public static class Float32List
    extends TypedDataList {
        final FloatBuffer buffer;

        public Float32List(byte[] bytes) {
            this.buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        }

        @Override
        public String getValue(int i) {
            return String.valueOf(this.buffer.get(i));
        }

        @Override
        public int size() {
            return this.buffer.capacity();
        }
    }

    public static class Uint64List
    extends Int64List {
        public Uint64List(byte[] bytes) {
            super(bytes);
        }

        @Override
        public String getValue(int i) {
            return "0x" + Long.toUnsignedString(this.buffer.get(i), 16);
        }
    }

    public static class Int64List
    extends TypedDataList {
        final LongBuffer buffer;

        public Int64List(byte[] bytes) {
            this.buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        }

        @Override
        public String getValue(int i) {
            return Long.toString(this.buffer.get(i));
        }

        @Override
        public int size() {
            return this.buffer.capacity();
        }
    }

    public static class Uint32List
    extends Int32List {
        public Uint32List(byte[] bytes) {
            super(bytes);
        }

        @Override
        public String getValue(int i) {
            return "0x" + Integer.toHexString(this.buffer.get(i));
        }
    }

    public static class Int32List
    extends TypedDataList {
        final IntBuffer buffer;

        public Int32List(byte[] bytes) {
            this.buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        }

        @Override
        public String getValue(int i) {
            return Integer.toString(this.buffer.get(i));
        }

        @Override
        public int size() {
            return this.buffer.capacity();
        }
    }

    public static class Uint16List
    extends Int16List {
        public Uint16List(byte[] bytes) {
            super(bytes);
        }

        @Override
        public String getValue(int i) {
            return "0x" + Integer.toHexString(this.buffer.get(i) & 0xFFFF);
        }
    }

    public static class Int16List
    extends TypedDataList {
        final ShortBuffer buffer;

        public Int16List(byte[] bytes) {
            this.buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        }

        @Override
        public String getValue(int i) {
            return Short.toString(this.buffer.get(i));
        }

        @Override
        public int size() {
            return this.buffer.capacity();
        }
    }

    public static class Uint8List
    extends Int8List {
        public Uint8List(byte[] bytes) {
            super(bytes);
        }

        @Override
        public String getValue(int i) {
            return "0x" + Integer.toHexString(this.buffer.get(i) & 0xFF);
        }
    }

    public static class Int8List
    extends TypedDataList {
        final ByteBuffer buffer;

        public Int8List(byte[] bytes) {
            this.buffer = ByteBuffer.wrap(bytes);
        }

        @Override
        public String getValue(int i) {
            return Byte.toString(this.buffer.get(i));
        }

        @Override
        public int size() {
            return this.buffer.capacity();
        }
    }
}

