/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.animation;

import io.flutter.utils.animation.Curve;

class Cubic
extends Curve {
    final double a;
    final double b;
    final double c;
    final double d;
    static final double _kCubicErrorBound = 0.001;

    Cubic(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    double evaluateCubic(double a, double b, double m) {
        return 3.0 * a * (1.0 - m) * (1.0 - m) * m + 3.0 * b * (1.0 - m) * m * m + m * m * m;
    }

    @Override
    public double transform(double t) {
        assert (t >= 0.0 && t <= 1.0);
        double start = 0.0;
        double end = 1.0;
        double midpoint;
        double estimate;
        while (!(Math.abs(t - (estimate = this.evaluateCubic(this.a, this.c, midpoint = (start + end) / 2.0))) < 0.001)) {
            if (estimate < t) {
                start = midpoint;
                continue;
            }
            end = midpoint;
        }
        return this.evaluateCubic(this.b, this.d, midpoint);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass()) + "(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ")";
    }
}

