/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.animation;

import io.flutter.utils.animation.Curve;

class ElasticOutCurve
extends Curve {
    final double period;

    public ElasticOutCurve() {
        this(0.4);
    }

    public ElasticOutCurve(double period) {
        this.period = period;
    }

    @Override
    public double transform(double t) {
        assert (t >= 0.0 && t <= 1.0);
        double s = this.period / 4.0;
        return Math.pow(2.0, -10.0 * t) * Math.sin((t - s) * (Math.PI * 2) / this.period) + 1.0;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass()) + "(" + this.period + ")";
    }
}

