/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.math;

import io.flutter.utils.math.Quaternion;
import io.flutter.utils.math.Vector2;
import io.flutter.utils.math.Vector3;
import io.flutter.utils.math.Vector4;
import java.util.Arrays;

public class Matrix4 {
    final double[] _m4storage;

    public Matrix4(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7, double arg8, double arg9, double arg10, double arg11, double arg12, double arg13, double arg14, double arg15) {
        this._m4storage = new double[16];
        this.setValues(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    Matrix4() {
        this._m4storage = new double[16];
    }

    public Matrix4(double[] storage) {
        this._m4storage = storage;
    }

    static void solve2(Matrix4 A, Vector2 x, Vector2 b) {
        double a11 = A.entry(0, 0);
        double a12 = A.entry(0, 1);
        double a21 = A.entry(1, 0);
        double a22 = A.entry(1, 1);
        double bx = b.getX() - A._m4storage[8];
        double by = b.getY() - A._m4storage[9];
        double det = a11 * a22 - a12 * a21;
        if (det != 0.0) {
            det = 1.0 / det;
        }
        x.setX(det * (a22 * bx - a12 * by));
        x.setY(det * (a11 * by - a21 * bx));
    }

    public static void solve3(Matrix4 A, Vector3 x, Vector3 b) {
        double A0x = A.entry(0, 0);
        double A0y = A.entry(1, 0);
        double A0z = A.entry(2, 0);
        double A1x = A.entry(0, 1);
        double A1y = A.entry(1, 1);
        double A1z = A.entry(2, 1);
        double A2x = A.entry(0, 2);
        double A2y = A.entry(1, 2);
        double A2z = A.entry(2, 2);
        double bx = b.getX() - A._m4storage[12];
        double by = b.getY() - A._m4storage[13];
        double bz = b.getZ() - A._m4storage[14];
        double rx = A1y * A2z - A1z * A2y;
        double ry = A1z * A2x - A1x * A2z;
        double rz = A1x * A2y - A1y * A2x;
        double det = A0x * rx + A0y * ry + A0z * rz;
        if (det != 0.0) {
            det = 1.0 / det;
        }
        double x_ = det * (bx * rx + by * ry + bz * rz);
        rx = -(A2y * bz - A2z * by);
        ry = -(A2z * bx - A2x * bz);
        rz = -(A2x * by - A2y * bx);
        double y_ = det * (A0x * rx + A0y * ry + A0z * rz);
        rx = -(by * A1z - bz * A1y);
        ry = -(bz * A1x - bx * A1z);
        rz = -(bx * A1y - by * A1x);
        double z_ = det * (A0x * rx + A0y * ry + A0z * rz);
        x.setX(x_);
        x.setY(y_);
        x.setZ(z_);
    }

    static void solve(Matrix4 A, Vector4 x, Vector4 b) {
        double a00 = A._m4storage[0];
        double a01 = A._m4storage[1];
        double a02 = A._m4storage[2];
        double a03 = A._m4storage[3];
        double a10 = A._m4storage[4];
        double a11 = A._m4storage[5];
        double a12 = A._m4storage[6];
        double a13 = A._m4storage[7];
        double a20 = A._m4storage[8];
        double a21 = A._m4storage[9];
        double a22 = A._m4storage[10];
        double a23 = A._m4storage[11];
        double a30 = A._m4storage[12];
        double a31 = A._m4storage[13];
        double a32 = A._m4storage[14];
        double a33 = A._m4storage[15];
        double b00 = a00 * a11 - a01 * a10;
        double b01 = a00 * a12 - a02 * a10;
        double b02 = a00 * a13 - a03 * a10;
        double b03 = a01 * a12 - a02 * a11;
        double b04 = a01 * a13 - a03 * a11;
        double b05 = a02 * a13 - a03 * a12;
        double b06 = a20 * a31 - a21 * a30;
        double b07 = a20 * a32 - a22 * a30;
        double b08 = a20 * a33 - a23 * a30;
        double b09 = a21 * a32 - a22 * a31;
        double b10 = a21 * a33 - a23 * a31;
        double b11 = a22 * a33 - a23 * a32;
        double bX = b.getStorage()[0];
        double bY = b.getStorage()[1];
        double bZ = b.getStorage()[2];
        double bW = b.getStorage()[3];
        double det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
        if (det != 0.0) {
            det = 1.0 / det;
        }
        x.setX(det * ((a11 * b11 - a12 * b10 + a13 * b09) * bX - (a10 * b11 - a12 * b08 + a13 * b07) * bY + (a10 * b10 - a11 * b08 + a13 * b06) * bZ - (a10 * b09 - a11 * b07 + a12 * b06) * bW));
        x.setY(det * -((a01 * b11 - a02 * b10 + a03 * b09) * bX - (a00 * b11 - a02 * b08 + a03 * b07) * bY + (a00 * b10 - a01 * b08 + a03 * b06) * bZ - (a00 * b09 - a01 * b07 + a02 * b06) * bW));
        x.setZ(det * ((a31 * b05 - a32 * b04 + a33 * b03) * bX - (a30 * b05 - a32 * b02 + a33 * b01) * bY + (a30 * b04 - a31 * b02 + a33 * b00) * bZ - (a30 * b03 - a31 * b01 + a32 * b00) * bW));
        x.setW(det * -((a21 * b05 - a22 * b04 + a23 * b03) * bX - (a20 * b05 - a22 * b02 + a23 * b01) * bY + (a20 * b04 - a21 * b02 + a23 * b00) * bZ - (a20 * b03 - a21 * b01 + a22 * b00) * bW));
    }

    static Matrix4 tryInvert(Matrix4 other) {
        Matrix4 r = new Matrix4();
        double determinant = r.copyInverse(other);
        if (determinant == 0.0) {
            return null;
        }
        return r;
    }

    public static Matrix4 fromList(double[] values) {
        Matrix4 ret = new Matrix4();
        ret.setValues(values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]);
        return ret;
    }

    public static Matrix4 zero() {
        return new Matrix4();
    }

    public static Matrix4 identity() {
        Matrix4 ret = new Matrix4();
        ret.setIdentity();
        return ret;
    }

    public static Matrix4 copy(Matrix4 other) {
        Matrix4 ret = new Matrix4();
        ret.setFrom(other);
        return ret;
    }

    public static Matrix4 inverted(Matrix4 other) {
        Matrix4 r = new Matrix4();
        double determinant = r.copyInverse(other);
        if (determinant == 0.0) {
            throw new IllegalArgumentException(String.valueOf(other) + "other Matrix cannot be inverted");
        }
        return r;
    }

    public static Matrix4 columns(Vector4 arg0, Vector4 arg1, Vector4 arg2, Vector4 arg3) {
        Matrix4 ret = new Matrix4();
        ret.setColumns(arg0, arg1, arg2, arg3);
        return ret;
    }

    public static Matrix4 outer(Vector4 u, Vector4 v) {
        Matrix4 ret = new Matrix4();
        ret.setOuter(u, v);
        return ret;
    }

    public static Matrix4 rotationX(double radians) {
        Matrix4 ret = new Matrix4();
        ret._m4storage[15] = 1.0;
        ret.setRotationX(radians);
        return ret;
    }

    public static Matrix4 rotationY(double radians) {
        Matrix4 ret = new Matrix4();
        ret._m4storage[15] = 1.0;
        ret.setRotationY(radians);
        return ret;
    }

    public static Matrix4 rotationZ(double radians) {
        Matrix4 ret = new Matrix4();
        ret._m4storage[15] = 1.0;
        ret.setRotationZ(radians);
        return ret;
    }

    public static Matrix4 translation(Vector3 translation) {
        Matrix4 ret = new Matrix4();
        ret.setIdentity();
        ret.setTranslation(translation);
        return ret;
    }

    public static Matrix4 translationValues(double x, double y, double z) {
        Matrix4 ret = new Matrix4();
        ret.setIdentity();
        ret.setTranslationRaw(x, y, z);
        return ret;
    }

    public static Matrix4 diagonal3(Vector3 scale) {
        Matrix4 m = new Matrix4();
        double[] mStorage = m._m4storage;
        double[] scaleStorage = scale._v3storage;
        mStorage[15] = 1.0;
        mStorage[10] = scaleStorage[2];
        mStorage[5] = scaleStorage[1];
        mStorage[0] = scaleStorage[0];
        return m;
    }

    public static Matrix4 diagonal3Values(double x, double y, double z) {
        Matrix4 ret = new Matrix4();
        ret._m4storage[15] = 1.0;
        ret._m4storage[10] = z;
        ret._m4storage[5] = y;
        ret._m4storage[0] = x;
        return ret;
    }

    public static Matrix4 skewX(double alpha) {
        Matrix4 m = Matrix4.identity();
        m._m4storage[4] = Math.tan(alpha);
        return m;
    }

    public static Matrix4 skewY(double beta) {
        Matrix4 m = Matrix4.identity();
        m._m4storage[1] = Math.tan(beta);
        return m;
    }

    public static Matrix4 skew(double alpha, double beta) {
        Matrix4 m = Matrix4.identity();
        m._m4storage[1] = Math.tan(beta);
        m._m4storage[4] = Math.tan(alpha);
        return m;
    }

    public static Matrix4 compose(Vector3 translation, Quaternion rotation, Vector3 scale) {
        Matrix4 matrix = new Matrix4();
        matrix.setFromTranslationRotationScale(translation, rotation, scale);
        return matrix;
    }

    double[] getStorage() {
        return this._m4storage;
    }

    public int index(int row, int col) {
        return col * 4 + row;
    }

    public double entry(int row, int col) {
        assert (row >= 0 && row < this.getDimension());
        assert (col >= 0 && col < this.getDimension());
        return this._m4storage[this.index(row, col)];
    }

    void setEntry(int row, int col, double v) {
        assert (row >= 0 && row < this.getDimension());
        assert (col >= 0 && col < this.getDimension());
        this._m4storage[this.index((int)row, (int)col)] = v;
    }

    void splatDiagonal(double arg) {
        this._m4storage[0] = arg;
        this._m4storage[5] = arg;
        this._m4storage[10] = arg;
        this._m4storage[15] = arg;
    }

    void setValues(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7, double arg8, double arg9, double arg10, double arg11, double arg12, double arg13, double arg14, double arg15) {
        this._m4storage[15] = arg15;
        this._m4storage[14] = arg14;
        this._m4storage[13] = arg13;
        this._m4storage[12] = arg12;
        this._m4storage[11] = arg11;
        this._m4storage[10] = arg10;
        this._m4storage[9] = arg9;
        this._m4storage[8] = arg8;
        this._m4storage[7] = arg7;
        this._m4storage[6] = arg6;
        this._m4storage[5] = arg5;
        this._m4storage[4] = arg4;
        this._m4storage[3] = arg3;
        this._m4storage[2] = arg2;
        this._m4storage[1] = arg1;
        this._m4storage[0] = arg0;
    }

    void setColumns(Vector4 arg0, Vector4 arg1, Vector4 arg2, Vector4 arg3) {
        double[] arg0Storage = arg0._v4storage;
        double[] arg1Storage = arg1._v4storage;
        double[] arg2Storage = arg2._v4storage;
        double[] arg3Storage = arg3._v4storage;
        this._m4storage[0] = arg0Storage[0];
        this._m4storage[1] = arg0Storage[1];
        this._m4storage[2] = arg0Storage[2];
        this._m4storage[3] = arg0Storage[3];
        this._m4storage[4] = arg1Storage[0];
        this._m4storage[5] = arg1Storage[1];
        this._m4storage[6] = arg1Storage[2];
        this._m4storage[7] = arg1Storage[3];
        this._m4storage[8] = arg2Storage[0];
        this._m4storage[9] = arg2Storage[1];
        this._m4storage[10] = arg2Storage[2];
        this._m4storage[11] = arg2Storage[3];
        this._m4storage[12] = arg3Storage[0];
        this._m4storage[13] = arg3Storage[1];
        this._m4storage[14] = arg3Storage[2];
        this._m4storage[15] = arg3Storage[3];
    }

    void setFrom(Matrix4 arg) {
        double[] argStorage = arg._m4storage;
        this._m4storage[15] = argStorage[15];
        this._m4storage[14] = argStorage[14];
        this._m4storage[13] = argStorage[13];
        this._m4storage[12] = argStorage[12];
        this._m4storage[11] = argStorage[11];
        this._m4storage[10] = argStorage[10];
        this._m4storage[9] = argStorage[9];
        this._m4storage[8] = argStorage[8];
        this._m4storage[7] = argStorage[7];
        this._m4storage[6] = argStorage[6];
        this._m4storage[5] = argStorage[5];
        this._m4storage[4] = argStorage[4];
        this._m4storage[3] = argStorage[3];
        this._m4storage[2] = argStorage[2];
        this._m4storage[1] = argStorage[1];
        this._m4storage[0] = argStorage[0];
    }

    void setFromTranslationRotation(Vector3 arg0, Quaternion arg1) {
        double[] arg1Storage = arg1._qStorage;
        double x = arg1Storage[0];
        double y = arg1Storage[1];
        double z = arg1Storage[2];
        double w = arg1Storage[3];
        double x2 = x + x;
        double y2 = y + y;
        double z2 = z + z;
        double xx = x * x2;
        double xy = x * y2;
        double xz = x * z2;
        double yy = y * y2;
        double yz = y * z2;
        double zz = z * z2;
        double wx = w * x2;
        double wy = w * y2;
        double wz = w * z2;
        double[] arg0Storage = arg0._v3storage;
        this._m4storage[0] = 1.0 - (yy + zz);
        this._m4storage[1] = xy + wz;
        this._m4storage[2] = xz - wy;
        this._m4storage[3] = 0.0;
        this._m4storage[4] = xy - wz;
        this._m4storage[5] = 1.0 - (xx + zz);
        this._m4storage[6] = yz + wx;
        this._m4storage[7] = 0.0;
        this._m4storage[8] = xz + wy;
        this._m4storage[9] = yz - wx;
        this._m4storage[10] = 1.0 - (xx + yy);
        this._m4storage[11] = 0.0;
        this._m4storage[12] = arg0Storage[0];
        this._m4storage[13] = arg0Storage[1];
        this._m4storage[14] = arg0Storage[2];
        this._m4storage[15] = 1.0;
    }

    void setFromTranslationRotationScale(Vector3 translation, Quaternion rotation, Vector3 scale) {
        this.setFromTranslationRotation(translation, rotation);
        this.scale(scale);
    }

    void setDiagonal(Vector4 arg) {
        double[] argStorage = arg._v4storage;
        this._m4storage[0] = argStorage[0];
        this._m4storage[5] = argStorage[1];
        this._m4storage[10] = argStorage[2];
        this._m4storage[15] = argStorage[3];
    }

    void setOuter(Vector4 u, Vector4 v) {
        double[] uStorage = u._v4storage;
        double[] vStorage = v._v4storage;
        this._m4storage[0] = uStorage[0] * vStorage[0];
        this._m4storage[1] = uStorage[0] * vStorage[1];
        this._m4storage[2] = uStorage[0] * vStorage[2];
        this._m4storage[3] = uStorage[0] * vStorage[3];
        this._m4storage[4] = uStorage[1] * vStorage[0];
        this._m4storage[5] = uStorage[1] * vStorage[1];
        this._m4storage[6] = uStorage[1] * vStorage[2];
        this._m4storage[7] = uStorage[1] * vStorage[3];
        this._m4storage[8] = uStorage[2] * vStorage[0];
        this._m4storage[9] = uStorage[2] * vStorage[1];
        this._m4storage[10] = uStorage[2] * vStorage[2];
        this._m4storage[11] = uStorage[2] * vStorage[3];
        this._m4storage[12] = uStorage[3] * vStorage[0];
        this._m4storage[13] = uStorage[3] * vStorage[1];
        this._m4storage[14] = uStorage[3] * vStorage[2];
        this._m4storage[15] = uStorage[3] * vStorage[3];
    }

    public String toString() {
        return "[0] " + String.valueOf(this.getRow(0)) + "\n[1] " + String.valueOf(this.getRow(1)) + "\n[2] " + String.valueOf(this.getRow(2)) + "\n[3] " + String.valueOf(this.getRow(3)) + "\n";
    }

    public int getDimension() {
        return 4;
    }

    double get(int i) {
        return this._m4storage[i];
    }

    void set(int i, double v) {
        this._m4storage[i] = v;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matrix4)) {
            return false;
        }
        Matrix4 other = (Matrix4)o;
        return this._m4storage[0] == other._m4storage[0] && this._m4storage[1] == other._m4storage[1] && this._m4storage[2] == other._m4storage[2] && this._m4storage[3] == other._m4storage[3] && this._m4storage[4] == other._m4storage[4] && this._m4storage[5] == other._m4storage[5] && this._m4storage[6] == other._m4storage[6] && this._m4storage[7] == other._m4storage[7] && this._m4storage[8] == other._m4storage[8] && this._m4storage[9] == other._m4storage[9] && this._m4storage[10] == other._m4storage[10] && this._m4storage[11] == other._m4storage[11] && this._m4storage[12] == other._m4storage[12] && this._m4storage[13] == other._m4storage[13] && this._m4storage[14] == other._m4storage[14] && this._m4storage[15] == other._m4storage[15];
    }

    public int hashCode() {
        return Arrays.hashCode(this._m4storage);
    }

    public Vector4 getRow0() {
        return this.getRow(0);
    }

    public void setRow0(Vector4 arg) {
        this.setRow(0, arg);
    }

    public Vector4 getRow1() {
        return this.getRow(1);
    }

    public void setRow1(Vector4 arg) {
        this.setRow(1, arg);
    }

    public Vector4 getRow2() {
        return this.getRow(2);
    }

    public void setRow2(Vector4 arg) {
        this.setRow(2, arg);
    }

    public Vector4 getRow3() {
        return this.getRow(3);
    }

    public void setRow3(Vector4 arg) {
        this.setRow(3, arg);
    }

    public void setRow(int row, Vector4 arg) {
        double[] argStorage = arg._v4storage;
        this._m4storage[this.index((int)row, (int)0)] = argStorage[0];
        this._m4storage[this.index((int)row, (int)1)] = argStorage[1];
        this._m4storage[this.index((int)row, (int)2)] = argStorage[2];
        this._m4storage[this.index((int)row, (int)3)] = argStorage[3];
    }

    public Vector4 getRow(int row) {
        Vector4 r = new Vector4();
        double[] rStorage = r._v4storage;
        rStorage[0] = this._m4storage[this.index(row, 0)];
        rStorage[1] = this._m4storage[this.index(row, 1)];
        rStorage[2] = this._m4storage[this.index(row, 2)];
        rStorage[3] = this._m4storage[this.index(row, 3)];
        return r;
    }

    public void setColumn(int column, Vector4 arg) {
        int entry = column * 4;
        double[] argStorage = arg._v4storage;
        this._m4storage[entry + 3] = argStorage[3];
        this._m4storage[entry + 2] = argStorage[2];
        this._m4storage[entry + 1] = argStorage[1];
        this._m4storage[entry + 0] = argStorage[0];
    }

    public Vector4 getColumn(int column) {
        Vector4 r = new Vector4();
        double[] rStorage = r._v4storage;
        int entry = column * 4;
        rStorage[3] = this._m4storage[entry + 3];
        rStorage[2] = this._m4storage[entry + 2];
        rStorage[1] = this._m4storage[entry + 1];
        rStorage[0] = this._m4storage[entry + 0];
        return r;
    }

    public Matrix4 clone() {
        return Matrix4.copy(this);
    }

    public Matrix4 copyInto(Matrix4 arg) {
        double[] argStorage = arg._m4storage;
        argStorage[0] = this._m4storage[0];
        argStorage[1] = this._m4storage[1];
        argStorage[2] = this._m4storage[2];
        argStorage[3] = this._m4storage[3];
        argStorage[4] = this._m4storage[4];
        argStorage[5] = this._m4storage[5];
        argStorage[6] = this._m4storage[6];
        argStorage[7] = this._m4storage[7];
        argStorage[8] = this._m4storage[8];
        argStorage[9] = this._m4storage[9];
        argStorage[10] = this._m4storage[10];
        argStorage[11] = this._m4storage[11];
        argStorage[12] = this._m4storage[12];
        argStorage[13] = this._m4storage[13];
        argStorage[14] = this._m4storage[14];
        argStorage[15] = this._m4storage[15];
        return arg;
    }

    public Matrix4 operatorNegate() {
        Matrix4 ret = this.clone();
        ret.negate();
        return ret;
    }

    Matrix4 operatorMultiply(double arg) {
        return this.scaled(arg);
    }

    public Vector4 operatorMultiply(Vector4 arg) {
        return this.transformed(arg);
    }

    public Vector3 operatorMultiply(Vector3 arg) {
        return this.transformed3(arg);
    }

    public Matrix4 operatorMultiply(Matrix4 arg) {
        return this.multiplied(arg);
    }

    public Matrix4 operatorAdd(Matrix4 arg) {
        Matrix4 ret = this.clone();
        ret.add(arg);
        return ret;
    }

    public Matrix4 operatorSub(Matrix4 arg) {
        Matrix4 ret = this.clone();
        ret.sub(arg);
        return ret;
    }

    public void translate(double x) {
        this.translate(x, 0.0, 0.0);
    }

    public void translate(Vector3 v) {
        this.translate(v.getX(), v.getY(), v.getZ());
    }

    public void translate(Vector4 v) {
        this.translate(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public void translate(double x, double y, double z) {
        this.translate(x, y, z, 1.0);
    }

    public void translate(double tx, double ty, double tz, double tw) {
        double t1 = this._m4storage[0] * tx + this._m4storage[4] * ty + this._m4storage[8] * tz + this._m4storage[12] * tw;
        double t2 = this._m4storage[1] * tx + this._m4storage[5] * ty + this._m4storage[9] * tz + this._m4storage[13] * tw;
        double t3 = this._m4storage[2] * tx + this._m4storage[6] * ty + this._m4storage[10] * tz + this._m4storage[14] * tw;
        double t4 = this._m4storage[3] * tx + this._m4storage[7] * ty + this._m4storage[11] * tz + this._m4storage[15] * tw;
        this._m4storage[12] = t1;
        this._m4storage[13] = t2;
        this._m4storage[14] = t3;
        this._m4storage[15] = t4;
    }

    public void leftTranslate(double x, double y, double z) {
        this.leftTranslater(x, y, z, 1.0);
    }

    public void leftTranslate(double x) {
        this.leftTranslater(x, 0.0, 0.0, 1.0);
    }

    public void leftTranslate(Vector4 v) {
        this.leftTranslater(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public void leftTranslate(Vector3 v) {
        this.leftTranslater(v.getX(), v.getY(), v.getZ(), 1.0);
    }

    void leftTranslater(double tx, double ty, double tz, double tw) {
        this._m4storage[0] = this._m4storage[0] + tx * this._m4storage[3];
        this._m4storage[1] = this._m4storage[1] + ty * this._m4storage[3];
        this._m4storage[2] = this._m4storage[2] + tz * this._m4storage[3];
        this._m4storage[3] = tw * this._m4storage[3];
        this._m4storage[4] = this._m4storage[4] + tx * this._m4storage[7];
        this._m4storage[5] = this._m4storage[5] + ty * this._m4storage[7];
        this._m4storage[6] = this._m4storage[6] + tz * this._m4storage[7];
        this._m4storage[7] = tw * this._m4storage[7];
        this._m4storage[8] = this._m4storage[8] + tx * this._m4storage[11];
        this._m4storage[9] = this._m4storage[9] + ty * this._m4storage[11];
        this._m4storage[10] = this._m4storage[10] + tz * this._m4storage[11];
        this._m4storage[11] = tw * this._m4storage[11];
        this._m4storage[12] = this._m4storage[12] + tx * this._m4storage[15];
        this._m4storage[13] = this._m4storage[13] + ty * this._m4storage[15];
        this._m4storage[14] = this._m4storage[14] + tz * this._m4storage[15];
        this._m4storage[15] = tw * this._m4storage[15];
    }

    public void rotate(Vector3 axis, double angle) {
        double len = axis.getLength();
        double[] axisStorage = axis._v3storage;
        double x = axisStorage[0] / len;
        double y = axisStorage[1] / len;
        double z = axisStorage[2] / len;
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double C = 1.0 - c;
        double m11 = x * x * C + c;
        double m12 = x * y * C - z * s;
        double m13 = x * z * C + y * s;
        double m21 = y * x * C + z * s;
        double m22 = y * y * C + c;
        double m23 = y * z * C - x * s;
        double m31 = z * x * C - y * s;
        double m32 = z * y * C + x * s;
        double m33 = z * z * C + c;
        double t1 = this._m4storage[0] * m11 + this._m4storage[4] * m21 + this._m4storage[8] * m31;
        double t2 = this._m4storage[1] * m11 + this._m4storage[5] * m21 + this._m4storage[9] * m31;
        double t3 = this._m4storage[2] * m11 + this._m4storage[6] * m21 + this._m4storage[10] * m31;
        double t4 = this._m4storage[3] * m11 + this._m4storage[7] * m21 + this._m4storage[11] * m31;
        double t5 = this._m4storage[0] * m12 + this._m4storage[4] * m22 + this._m4storage[8] * m32;
        double t6 = this._m4storage[1] * m12 + this._m4storage[5] * m22 + this._m4storage[9] * m32;
        double t7 = this._m4storage[2] * m12 + this._m4storage[6] * m22 + this._m4storage[10] * m32;
        double t8 = this._m4storage[3] * m12 + this._m4storage[7] * m22 + this._m4storage[11] * m32;
        double t9 = this._m4storage[0] * m13 + this._m4storage[4] * m23 + this._m4storage[8] * m33;
        double t10 = this._m4storage[1] * m13 + this._m4storage[5] * m23 + this._m4storage[9] * m33;
        double t11 = this._m4storage[2] * m13 + this._m4storage[6] * m23 + this._m4storage[10] * m33;
        double t12 = this._m4storage[3] * m13 + this._m4storage[7] * m23 + this._m4storage[11] * m33;
        this._m4storage[0] = t1;
        this._m4storage[1] = t2;
        this._m4storage[2] = t3;
        this._m4storage[3] = t4;
        this._m4storage[4] = t5;
        this._m4storage[5] = t6;
        this._m4storage[6] = t7;
        this._m4storage[7] = t8;
        this._m4storage[8] = t9;
        this._m4storage[9] = t10;
        this._m4storage[10] = t11;
        this._m4storage[11] = t12;
    }

    public void rotateX(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double t1 = this._m4storage[4] * cosAngle + this._m4storage[8] * sinAngle;
        double t2 = this._m4storage[5] * cosAngle + this._m4storage[9] * sinAngle;
        double t3 = this._m4storage[6] * cosAngle + this._m4storage[10] * sinAngle;
        double t4 = this._m4storage[7] * cosAngle + this._m4storage[11] * sinAngle;
        double t5 = this._m4storage[4] * -sinAngle + this._m4storage[8] * cosAngle;
        double t6 = this._m4storage[5] * -sinAngle + this._m4storage[9] * cosAngle;
        double t7 = this._m4storage[6] * -sinAngle + this._m4storage[10] * cosAngle;
        double t8 = this._m4storage[7] * -sinAngle + this._m4storage[11] * cosAngle;
        this._m4storage[4] = t1;
        this._m4storage[5] = t2;
        this._m4storage[6] = t3;
        this._m4storage[7] = t4;
        this._m4storage[8] = t5;
        this._m4storage[9] = t6;
        this._m4storage[10] = t7;
        this._m4storage[11] = t8;
    }

    public void rotateY(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double t1 = this._m4storage[0] * cosAngle + this._m4storage[8] * -sinAngle;
        double t2 = this._m4storage[1] * cosAngle + this._m4storage[9] * -sinAngle;
        double t3 = this._m4storage[2] * cosAngle + this._m4storage[10] * -sinAngle;
        double t4 = this._m4storage[3] * cosAngle + this._m4storage[11] * -sinAngle;
        double t5 = this._m4storage[0] * sinAngle + this._m4storage[8] * cosAngle;
        double t6 = this._m4storage[1] * sinAngle + this._m4storage[9] * cosAngle;
        double t7 = this._m4storage[2] * sinAngle + this._m4storage[10] * cosAngle;
        double t8 = this._m4storage[3] * sinAngle + this._m4storage[11] * cosAngle;
        this._m4storage[0] = t1;
        this._m4storage[1] = t2;
        this._m4storage[2] = t3;
        this._m4storage[3] = t4;
        this._m4storage[8] = t5;
        this._m4storage[9] = t6;
        this._m4storage[10] = t7;
        this._m4storage[11] = t8;
    }

    public void rotateZ(double angle) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double t1 = this._m4storage[0] * cosAngle + this._m4storage[4] * sinAngle;
        double t2 = this._m4storage[1] * cosAngle + this._m4storage[5] * sinAngle;
        double t3 = this._m4storage[2] * cosAngle + this._m4storage[6] * sinAngle;
        double t4 = this._m4storage[3] * cosAngle + this._m4storage[7] * sinAngle;
        double t5 = this._m4storage[0] * -sinAngle + this._m4storage[4] * cosAngle;
        double t6 = this._m4storage[1] * -sinAngle + this._m4storage[5] * cosAngle;
        double t7 = this._m4storage[2] * -sinAngle + this._m4storage[6] * cosAngle;
        double t8 = this._m4storage[3] * -sinAngle + this._m4storage[7] * cosAngle;
        this._m4storage[0] = t1;
        this._m4storage[1] = t2;
        this._m4storage[2] = t3;
        this._m4storage[3] = t4;
        this._m4storage[4] = t5;
        this._m4storage[5] = t6;
        this._m4storage[6] = t7;
        this._m4storage[7] = t8;
    }

    public void scale(double sx) {
        this.scale(sx, sx, sx);
    }

    public void scale(Vector3 v) {
        this.scale(v.getX(), v.getY(), v.getZ());
    }

    public void scale(Vector4 v) {
        this.scale(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public void scale(double sx, double sy, double sz) {
        this.scale(sx, sy, sz, 1.0);
    }

    public void scale(double sx, double sy, double sz, double sw) {
        this._m4storage[0] = this._m4storage[0] * sx;
        this._m4storage[1] = this._m4storage[1] * sx;
        this._m4storage[2] = this._m4storage[2] * sx;
        this._m4storage[3] = this._m4storage[3] * sx;
        this._m4storage[4] = this._m4storage[4] * sy;
        this._m4storage[5] = this._m4storage[5] * sy;
        this._m4storage[6] = this._m4storage[6] * sy;
        this._m4storage[7] = this._m4storage[7] * sy;
        this._m4storage[8] = this._m4storage[8] * sz;
        this._m4storage[9] = this._m4storage[9] * sz;
        this._m4storage[10] = this._m4storage[10] * sz;
        this._m4storage[11] = this._m4storage[11] * sz;
        this._m4storage[12] = this._m4storage[12] * sw;
        this._m4storage[13] = this._m4storage[13] * sw;
        this._m4storage[14] = this._m4storage[14] * sw;
        this._m4storage[15] = this._m4storage[15] * sw;
    }

    public Matrix4 scaled(double x) {
        return this.scaled(x, 1.0, 1.0);
    }

    public Matrix4 scaled(double x, double y) {
        return this.scaled(x, y, 1.0);
    }

    public Matrix4 scaled(double x, double y, double z) {
        Matrix4 ret = this.clone();
        ret.scale(x, y, z);
        return ret;
    }

    public void setZero() {
        this._m4storage[0] = 0.0;
        this._m4storage[1] = 0.0;
        this._m4storage[2] = 0.0;
        this._m4storage[3] = 0.0;
        this._m4storage[4] = 0.0;
        this._m4storage[5] = 0.0;
        this._m4storage[6] = 0.0;
        this._m4storage[7] = 0.0;
        this._m4storage[8] = 0.0;
        this._m4storage[9] = 0.0;
        this._m4storage[10] = 0.0;
        this._m4storage[11] = 0.0;
        this._m4storage[12] = 0.0;
        this._m4storage[13] = 0.0;
        this._m4storage[14] = 0.0;
        this._m4storage[15] = 0.0;
    }

    void setIdentity() {
        this._m4storage[0] = 1.0;
        this._m4storage[1] = 0.0;
        this._m4storage[2] = 0.0;
        this._m4storage[3] = 0.0;
        this._m4storage[4] = 0.0;
        this._m4storage[5] = 1.0;
        this._m4storage[6] = 0.0;
        this._m4storage[7] = 0.0;
        this._m4storage[8] = 0.0;
        this._m4storage[9] = 0.0;
        this._m4storage[10] = 1.0;
        this._m4storage[11] = 0.0;
        this._m4storage[12] = 0.0;
        this._m4storage[13] = 0.0;
        this._m4storage[14] = 0.0;
        this._m4storage[15] = 1.0;
    }

    public Matrix4 transposed() {
        Matrix4 ret = this.clone();
        ret.transpose();
        return ret;
    }

    public void transpose() {
        double temp = this._m4storage[4];
        this._m4storage[4] = this._m4storage[1];
        this._m4storage[1] = temp;
        temp = this._m4storage[8];
        this._m4storage[8] = this._m4storage[2];
        this._m4storage[2] = temp;
        temp = this._m4storage[12];
        this._m4storage[12] = this._m4storage[3];
        this._m4storage[3] = temp;
        temp = this._m4storage[9];
        this._m4storage[9] = this._m4storage[6];
        this._m4storage[6] = temp;
        temp = this._m4storage[13];
        this._m4storage[13] = this._m4storage[7];
        this._m4storage[7] = temp;
        temp = this._m4storage[14];
        this._m4storage[14] = this._m4storage[11];
        this._m4storage[11] = temp;
    }

    public Matrix4 absolute() {
        Matrix4 r = new Matrix4();
        double[] rStorage = r._m4storage;
        rStorage[0] = Math.abs(this._m4storage[0]);
        rStorage[1] = Math.abs(this._m4storage[1]);
        rStorage[2] = Math.abs(this._m4storage[2]);
        rStorage[3] = Math.abs(this._m4storage[3]);
        rStorage[4] = Math.abs(this._m4storage[4]);
        rStorage[5] = Math.abs(this._m4storage[5]);
        rStorage[6] = Math.abs(this._m4storage[6]);
        rStorage[7] = Math.abs(this._m4storage[7]);
        rStorage[8] = Math.abs(this._m4storage[8]);
        rStorage[9] = Math.abs(this._m4storage[9]);
        rStorage[10] = Math.abs(this._m4storage[10]);
        rStorage[11] = Math.abs(this._m4storage[11]);
        rStorage[12] = Math.abs(this._m4storage[12]);
        rStorage[13] = Math.abs(this._m4storage[13]);
        rStorage[14] = Math.abs(this._m4storage[14]);
        rStorage[15] = Math.abs(this._m4storage[15]);
        return r;
    }

    public double determinant() {
        double det2_01_01 = this._m4storage[0] * this._m4storage[5] - this._m4storage[1] * this._m4storage[4];
        double det2_01_02 = this._m4storage[0] * this._m4storage[6] - this._m4storage[2] * this._m4storage[4];
        double det2_01_03 = this._m4storage[0] * this._m4storage[7] - this._m4storage[3] * this._m4storage[4];
        double det2_01_12 = this._m4storage[1] * this._m4storage[6] - this._m4storage[2] * this._m4storage[5];
        double det2_01_13 = this._m4storage[1] * this._m4storage[7] - this._m4storage[3] * this._m4storage[5];
        double det2_01_23 = this._m4storage[2] * this._m4storage[7] - this._m4storage[3] * this._m4storage[6];
        double det3_201_012 = this._m4storage[8] * det2_01_12 - this._m4storage[9] * det2_01_02 + this._m4storage[10] * det2_01_01;
        double det3_201_013 = this._m4storage[8] * det2_01_13 - this._m4storage[9] * det2_01_03 + this._m4storage[11] * det2_01_01;
        double det3_201_023 = this._m4storage[8] * det2_01_23 - this._m4storage[10] * det2_01_03 + this._m4storage[11] * det2_01_02;
        double det3_201_123 = this._m4storage[9] * det2_01_23 - this._m4storage[10] * det2_01_13 + this._m4storage[11] * det2_01_12;
        return -det3_201_123 * this._m4storage[12] + det3_201_023 * this._m4storage[13] - det3_201_013 * this._m4storage[14] + det3_201_012 * this._m4storage[15];
    }

    public double dotRow(int i, Vector4 v) {
        double[] vStorage = v._v4storage;
        return this._m4storage[i] * vStorage[0] + this._m4storage[4 + i] * vStorage[1] + this._m4storage[8 + i] * vStorage[2] + this._m4storage[12 + i] * vStorage[3];
    }

    public double dotColumn(int j, Vector4 v) {
        double[] vStorage = v._v4storage;
        return this._m4storage[j * 4] * vStorage[0] + this._m4storage[j * 4 + 1] * vStorage[1] + this._m4storage[j * 4 + 2] * vStorage[2] + this._m4storage[j * 4 + 3] * vStorage[3];
    }

    public double trace() {
        double t = 0.0;
        t += this._m4storage[0];
        t += this._m4storage[5];
        t += this._m4storage[10];
        return t += this._m4storage[15];
    }

    public double infinityNorm() {
        double norm = 0.0;
        double row_norm = 0.0;
        row_norm += Math.abs(this._m4storage[0]);
        row_norm += Math.abs(this._m4storage[1]);
        row_norm += Math.abs(this._m4storage[2]);
        norm = Math.max(row_norm += Math.abs(this._m4storage[3]), norm);
        row_norm = 0.0;
        row_norm += Math.abs(this._m4storage[4]);
        row_norm += Math.abs(this._m4storage[5]);
        row_norm += Math.abs(this._m4storage[6]);
        norm = Math.max(row_norm += Math.abs(this._m4storage[7]), norm);
        row_norm = 0.0;
        row_norm += Math.abs(this._m4storage[8]);
        row_norm += Math.abs(this._m4storage[9]);
        row_norm += Math.abs(this._m4storage[10]);
        norm = Math.max(row_norm += Math.abs(this._m4storage[11]), norm);
        row_norm = 0.0;
        row_norm += Math.abs(this._m4storage[12]);
        row_norm += Math.abs(this._m4storage[13]);
        row_norm += Math.abs(this._m4storage[14]);
        norm = Math.max(row_norm += Math.abs(this._m4storage[15]), norm);
        return norm;
    }

    public double relativeError(Matrix4 correct) {
        Matrix4 diff = correct.operatorSub(this);
        double correct_norm = correct.infinityNorm();
        double diff_norm = diff.infinityNorm();
        return diff_norm / correct_norm;
    }

    public double absoluteError(Matrix4 correct) {
        double this_norm = this.infinityNorm();
        double correct_norm = correct.infinityNorm();
        double diff_norm = Math.abs(this_norm - correct_norm);
        return diff_norm;
    }

    public Vector3 getTranslation() {
        double z = this._m4storage[14];
        double y = this._m4storage[13];
        double x = this._m4storage[12];
        return new Vector3(x, y, z);
    }

    public void setTranslation(Vector3 t) {
        double[] tStorage = t._v3storage;
        double z = tStorage[2];
        double y = tStorage[1];
        double x = tStorage[0];
        this._m4storage[14] = z;
        this._m4storage[13] = y;
        this._m4storage[12] = x;
    }

    public void setTranslationRaw(double x, double y, double z) {
        this._m4storage[14] = z;
        this._m4storage[13] = y;
        this._m4storage[12] = x;
    }

    public double getMaxScaleOnAxis() {
        double scaleXSq = this._m4storage[0] * this._m4storage[0] + this._m4storage[1] * this._m4storage[1] + this._m4storage[2] * this._m4storage[2];
        double scaleYSq = this._m4storage[4] * this._m4storage[4] + this._m4storage[5] * this._m4storage[5] + this._m4storage[6] * this._m4storage[6];
        double scaleZSq = this._m4storage[8] * this._m4storage[8] + this._m4storage[9] * this._m4storage[9] + this._m4storage[10] * this._m4storage[10];
        return Math.sqrt(Math.max(scaleXSq, Math.max(scaleYSq, scaleZSq)));
    }

    public void transposeRotation() {
        double temp = this._m4storage[1];
        this._m4storage[1] = this._m4storage[4];
        this._m4storage[4] = temp;
        temp = this._m4storage[2];
        this._m4storage[2] = this._m4storage[8];
        this._m4storage[8] = temp;
        temp = this._m4storage[4];
        this._m4storage[4] = this._m4storage[1];
        this._m4storage[1] = temp;
        temp = this._m4storage[6];
        this._m4storage[6] = this._m4storage[9];
        this._m4storage[9] = temp;
        temp = this._m4storage[8];
        this._m4storage[8] = this._m4storage[2];
        this._m4storage[2] = temp;
        temp = this._m4storage[9];
        this._m4storage[9] = this._m4storage[6];
        this._m4storage[6] = temp;
    }

    public double invert() {
        return this.copyInverse(this);
    }

    public double copyInverse(Matrix4 arg) {
        double[] argStorage = arg._m4storage;
        double a00 = argStorage[0];
        double a11 = argStorage[5];
        double a01 = argStorage[1];
        double a10 = argStorage[4];
        double b00 = a00 * a11 - a01 * a10;
        double a22 = argStorage[10];
        double a33 = argStorage[15];
        double a23 = argStorage[11];
        double a32 = argStorage[14];
        double b11 = a22 * a33 - a23 * a32;
        double a12 = argStorage[6];
        double a02 = argStorage[2];
        double b01 = a00 * a12 - a02 * a10;
        double a21 = argStorage[9];
        double a31 = argStorage[13];
        double b10 = a21 * a33 - a23 * a31;
        double a13 = argStorage[7];
        double a03 = argStorage[3];
        double b02 = a00 * a13 - a03 * a10;
        double b09 = a21 * a32 - a22 * a31;
        double b03 = a01 * a12 - a02 * a11;
        double a20 = argStorage[8];
        double a30 = argStorage[12];
        double b08 = a20 * a33 - a23 * a30;
        double b04 = a01 * a13 - a03 * a11;
        double b07 = a20 * a32 - a22 * a30;
        double b05 = a02 * a13 - a03 * a12;
        double b06 = a20 * a31 - a21 * a30;
        double det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
        if (det == 0.0) {
            this.setFrom(arg);
            return 0.0;
        }
        double invDet = 1.0 / det;
        this._m4storage[0] = (a11 * b11 - a12 * b10 + a13 * b09) * invDet;
        this._m4storage[1] = (-a01 * b11 + a02 * b10 - a03 * b09) * invDet;
        this._m4storage[2] = (a31 * b05 - a32 * b04 + a33 * b03) * invDet;
        this._m4storage[3] = (-a21 * b05 + a22 * b04 - a23 * b03) * invDet;
        this._m4storage[4] = (-a10 * b11 + a12 * b08 - a13 * b07) * invDet;
        this._m4storage[5] = (a00 * b11 - a02 * b08 + a03 * b07) * invDet;
        this._m4storage[6] = (-a30 * b05 + a32 * b02 - a33 * b01) * invDet;
        this._m4storage[7] = (a20 * b05 - a22 * b02 + a23 * b01) * invDet;
        this._m4storage[8] = (a10 * b10 - a11 * b08 + a13 * b06) * invDet;
        this._m4storage[9] = (-a00 * b10 + a01 * b08 - a03 * b06) * invDet;
        this._m4storage[10] = (a30 * b04 - a31 * b02 + a33 * b00) * invDet;
        this._m4storage[11] = (-a20 * b04 + a21 * b02 - a23 * b00) * invDet;
        this._m4storage[12] = (-a10 * b09 + a11 * b07 - a12 * b06) * invDet;
        this._m4storage[13] = (a00 * b09 - a01 * b07 + a02 * b06) * invDet;
        this._m4storage[14] = (-a30 * b03 + a31 * b01 - a32 * b00) * invDet;
        this._m4storage[15] = (a20 * b03 - a21 * b01 + a22 * b00) * invDet;
        return det;
    }

    public double invertRotation() {
        double det = this.determinant();
        if (det == 0.0) {
            return 0.0;
        }
        double invDet = 1.0 / det;
        double ix = invDet * (this._m4storage[5] * this._m4storage[10] - this._m4storage[6] * this._m4storage[9]);
        double iy = invDet * (this._m4storage[2] * this._m4storage[9] - this._m4storage[1] * this._m4storage[10]);
        double iz = invDet * (this._m4storage[1] * this._m4storage[6] - this._m4storage[2] * this._m4storage[5]);
        double jx = invDet * (this._m4storage[6] * this._m4storage[8] - this._m4storage[4] * this._m4storage[10]);
        double jy = invDet * (this._m4storage[0] * this._m4storage[10] - this._m4storage[2] * this._m4storage[8]);
        double jz = invDet * (this._m4storage[2] * this._m4storage[4] - this._m4storage[0] * this._m4storage[6]);
        double kx = invDet * (this._m4storage[4] * this._m4storage[9] - this._m4storage[5] * this._m4storage[8]);
        double ky = invDet * (this._m4storage[1] * this._m4storage[8] - this._m4storage[0] * this._m4storage[9]);
        double kz = invDet * (this._m4storage[0] * this._m4storage[5] - this._m4storage[1] * this._m4storage[4]);
        this._m4storage[0] = ix;
        this._m4storage[1] = iy;
        this._m4storage[2] = iz;
        this._m4storage[4] = jx;
        this._m4storage[5] = jy;
        this._m4storage[6] = jz;
        this._m4storage[8] = kx;
        this._m4storage[9] = ky;
        this._m4storage[10] = kz;
        return det;
    }

    public void setRotationX(double radians) {
        double c = Math.cos(radians);
        double s = Math.sin(radians);
        this._m4storage[0] = 1.0;
        this._m4storage[1] = 0.0;
        this._m4storage[2] = 0.0;
        this._m4storage[4] = 0.0;
        this._m4storage[5] = c;
        this._m4storage[6] = s;
        this._m4storage[8] = 0.0;
        this._m4storage[9] = -s;
        this._m4storage[10] = c;
        this._m4storage[3] = 0.0;
        this._m4storage[7] = 0.0;
        this._m4storage[11] = 0.0;
    }

    public void setRotationY(double radians) {
        double c = Math.cos(radians);
        double s = Math.sin(radians);
        this._m4storage[0] = c;
        this._m4storage[1] = 0.0;
        this._m4storage[2] = -s;
        this._m4storage[4] = 0.0;
        this._m4storage[5] = 1.0;
        this._m4storage[6] = 0.0;
        this._m4storage[8] = s;
        this._m4storage[9] = 0.0;
        this._m4storage[10] = c;
        this._m4storage[3] = 0.0;
        this._m4storage[7] = 0.0;
        this._m4storage[11] = 0.0;
    }

    public void setRotationZ(double radians) {
        double c = Math.cos(radians);
        double s = Math.sin(radians);
        this._m4storage[0] = c;
        this._m4storage[1] = s;
        this._m4storage[2] = 0.0;
        this._m4storage[4] = -s;
        this._m4storage[5] = c;
        this._m4storage[6] = 0.0;
        this._m4storage[8] = 0.0;
        this._m4storage[9] = 0.0;
        this._m4storage[10] = 1.0;
        this._m4storage[3] = 0.0;
        this._m4storage[7] = 0.0;
        this._m4storage[11] = 0.0;
    }

    public void scaleAdjoint(double scale) {
        double a1 = this._m4storage[0];
        double b1 = this._m4storage[4];
        double c1 = this._m4storage[8];
        double d1 = this._m4storage[12];
        double a2 = this._m4storage[1];
        double b2 = this._m4storage[5];
        double c2 = this._m4storage[9];
        double d2 = this._m4storage[13];
        double a3 = this._m4storage[2];
        double b3 = this._m4storage[6];
        double c3 = this._m4storage[10];
        double d3 = this._m4storage[14];
        double a4 = this._m4storage[3];
        double b4 = this._m4storage[7];
        double c4 = this._m4storage[11];
        double d4 = this._m4storage[15];
        this._m4storage[0] = (b2 * (c3 * d4 - c4 * d3) - c2 * (b3 * d4 - b4 * d3) + d2 * (b3 * c4 - b4 * c3)) * scale;
        this._m4storage[1] = -(a2 * (c3 * d4 - c4 * d3) - c2 * (a3 * d4 - a4 * d3) + d2 * (a3 * c4 - a4 * c3)) * scale;
        this._m4storage[2] = (a2 * (b3 * d4 - b4 * d3) - b2 * (a3 * d4 - a4 * d3) + d2 * (a3 * b4 - a4 * b3)) * scale;
        this._m4storage[3] = -(a2 * (b3 * c4 - b4 * c3) - b2 * (a3 * c4 - a4 * c3) + c2 * (a3 * b4 - a4 * b3)) * scale;
        this._m4storage[4] = -(b1 * (c3 * d4 - c4 * d3) - c1 * (b3 * d4 - b4 * d3) + d1 * (b3 * c4 - b4 * c3)) * scale;
        this._m4storage[5] = (a1 * (c3 * d4 - c4 * d3) - c1 * (a3 * d4 - a4 * d3) + d1 * (a3 * c4 - a4 * c3)) * scale;
        this._m4storage[6] = -(a1 * (b3 * d4 - b4 * d3) - b1 * (a3 * d4 - a4 * d3) + d1 * (a3 * b4 - a4 * b3)) * scale;
        this._m4storage[7] = (a1 * (b3 * c4 - b4 * c3) - b1 * (a3 * c4 - a4 * c3) + c1 * (a3 * b4 - a4 * b3)) * scale;
        this._m4storage[8] = (b1 * (c2 * d4 - c4 * d2) - c1 * (b2 * d4 - b4 * d2) + d1 * (b2 * c4 - b4 * c2)) * scale;
        this._m4storage[9] = -(a1 * (c2 * d4 - c4 * d2) - c1 * (a2 * d4 - a4 * d2) + d1 * (a2 * c4 - a4 * c2)) * scale;
        this._m4storage[10] = (a1 * (b2 * d4 - b4 * d2) - b1 * (a2 * d4 - a4 * d2) + d1 * (a2 * b4 - a4 * b2)) * scale;
        this._m4storage[11] = -(a1 * (b2 * c4 - b4 * c2) - b1 * (a2 * c4 - a4 * c2) + c1 * (a2 * b4 - a4 * b2)) * scale;
        this._m4storage[12] = -(b1 * (c2 * d3 - c3 * d2) - c1 * (b2 * d3 - b3 * d2) + d1 * (b2 * c3 - b3 * c2)) * scale;
        this._m4storage[13] = (a1 * (c2 * d3 - c3 * d2) - c1 * (a2 * d3 - a3 * d2) + d1 * (a2 * c3 - a3 * c2)) * scale;
        this._m4storage[14] = -(a1 * (b2 * d3 - b3 * d2) - b1 * (a2 * d3 - a3 * d2) + d1 * (a2 * b3 - a3 * b2)) * scale;
        this._m4storage[15] = (a1 * (b2 * c3 - b3 * c2) - b1 * (a2 * c3 - a3 * c2) + c1 * (a2 * b3 - a3 * b2)) * scale;
    }

    public Vector3 absoluteRotate(Vector3 arg) {
        double m00 = Math.abs(this._m4storage[0]);
        double m01 = Math.abs(this._m4storage[4]);
        double m02 = Math.abs(this._m4storage[8]);
        double m10 = Math.abs(this._m4storage[1]);
        double m11 = Math.abs(this._m4storage[5]);
        double m12 = Math.abs(this._m4storage[9]);
        double m20 = Math.abs(this._m4storage[2]);
        double m21 = Math.abs(this._m4storage[6]);
        double m22 = Math.abs(this._m4storage[10]);
        double[] argStorage = arg._v3storage;
        double x = argStorage[0];
        double y = argStorage[1];
        double z = argStorage[2];
        argStorage[0] = x * m00 + y * m01 + z * m02 + 0.0;
        argStorage[1] = x * m10 + y * m11 + z * m12 + 0.0;
        argStorage[2] = x * m20 + y * m21 + z * m22 + 0.0;
        return arg;
    }

    public void add(Matrix4 o) {
        double[] oStorage = o._m4storage;
        this._m4storage[0] = this._m4storage[0] + oStorage[0];
        this._m4storage[1] = this._m4storage[1] + oStorage[1];
        this._m4storage[2] = this._m4storage[2] + oStorage[2];
        this._m4storage[3] = this._m4storage[3] + oStorage[3];
        this._m4storage[4] = this._m4storage[4] + oStorage[4];
        this._m4storage[5] = this._m4storage[5] + oStorage[5];
        this._m4storage[6] = this._m4storage[6] + oStorage[6];
        this._m4storage[7] = this._m4storage[7] + oStorage[7];
        this._m4storage[8] = this._m4storage[8] + oStorage[8];
        this._m4storage[9] = this._m4storage[9] + oStorage[9];
        this._m4storage[10] = this._m4storage[10] + oStorage[10];
        this._m4storage[11] = this._m4storage[11] + oStorage[11];
        this._m4storage[12] = this._m4storage[12] + oStorage[12];
        this._m4storage[13] = this._m4storage[13] + oStorage[13];
        this._m4storage[14] = this._m4storage[14] + oStorage[14];
        this._m4storage[15] = this._m4storage[15] + oStorage[15];
    }

    public void sub(Matrix4 o) {
        double[] oStorage = o._m4storage;
        this._m4storage[0] = this._m4storage[0] - oStorage[0];
        this._m4storage[1] = this._m4storage[1] - oStorage[1];
        this._m4storage[2] = this._m4storage[2] - oStorage[2];
        this._m4storage[3] = this._m4storage[3] - oStorage[3];
        this._m4storage[4] = this._m4storage[4] - oStorage[4];
        this._m4storage[5] = this._m4storage[5] - oStorage[5];
        this._m4storage[6] = this._m4storage[6] - oStorage[6];
        this._m4storage[7] = this._m4storage[7] - oStorage[7];
        this._m4storage[8] = this._m4storage[8] - oStorage[8];
        this._m4storage[9] = this._m4storage[9] - oStorage[9];
        this._m4storage[10] = this._m4storage[10] - oStorage[10];
        this._m4storage[11] = this._m4storage[11] - oStorage[11];
        this._m4storage[12] = this._m4storage[12] - oStorage[12];
        this._m4storage[13] = this._m4storage[13] - oStorage[13];
        this._m4storage[14] = this._m4storage[14] - oStorage[14];
        this._m4storage[15] = this._m4storage[15] - oStorage[15];
    }

    public void negate() {
        this._m4storage[0] = -this._m4storage[0];
        this._m4storage[1] = -this._m4storage[1];
        this._m4storage[2] = -this._m4storage[2];
        this._m4storage[3] = -this._m4storage[3];
        this._m4storage[4] = -this._m4storage[4];
        this._m4storage[5] = -this._m4storage[5];
        this._m4storage[6] = -this._m4storage[6];
        this._m4storage[7] = -this._m4storage[7];
        this._m4storage[8] = -this._m4storage[8];
        this._m4storage[9] = -this._m4storage[9];
        this._m4storage[10] = -this._m4storage[10];
        this._m4storage[11] = -this._m4storage[11];
        this._m4storage[12] = -this._m4storage[12];
        this._m4storage[13] = -this._m4storage[13];
        this._m4storage[14] = -this._m4storage[14];
        this._m4storage[15] = -this._m4storage[15];
    }

    public void multiply(Matrix4 arg) {
        double m00 = this._m4storage[0];
        double m01 = this._m4storage[4];
        double m02 = this._m4storage[8];
        double m03 = this._m4storage[12];
        double m10 = this._m4storage[1];
        double m11 = this._m4storage[5];
        double m12 = this._m4storage[9];
        double m13 = this._m4storage[13];
        double m20 = this._m4storage[2];
        double m21 = this._m4storage[6];
        double m22 = this._m4storage[10];
        double m23 = this._m4storage[14];
        double m30 = this._m4storage[3];
        double m31 = this._m4storage[7];
        double m32 = this._m4storage[11];
        double m33 = this._m4storage[15];
        double[] argStorage = arg._m4storage;
        double n00 = argStorage[0];
        double n01 = argStorage[4];
        double n02 = argStorage[8];
        double n03 = argStorage[12];
        double n10 = argStorage[1];
        double n11 = argStorage[5];
        double n12 = argStorage[9];
        double n13 = argStorage[13];
        double n20 = argStorage[2];
        double n21 = argStorage[6];
        double n22 = argStorage[10];
        double n23 = argStorage[14];
        double n30 = argStorage[3];
        double n31 = argStorage[7];
        double n32 = argStorage[11];
        double n33 = argStorage[15];
        this._m4storage[0] = m00 * n00 + m01 * n10 + m02 * n20 + m03 * n30;
        this._m4storage[4] = m00 * n01 + m01 * n11 + m02 * n21 + m03 * n31;
        this._m4storage[8] = m00 * n02 + m01 * n12 + m02 * n22 + m03 * n32;
        this._m4storage[12] = m00 * n03 + m01 * n13 + m02 * n23 + m03 * n33;
        this._m4storage[1] = m10 * n00 + m11 * n10 + m12 * n20 + m13 * n30;
        this._m4storage[5] = m10 * n01 + m11 * n11 + m12 * n21 + m13 * n31;
        this._m4storage[9] = m10 * n02 + m11 * n12 + m12 * n22 + m13 * n32;
        this._m4storage[13] = m10 * n03 + m11 * n13 + m12 * n23 + m13 * n33;
        this._m4storage[2] = m20 * n00 + m21 * n10 + m22 * n20 + m23 * n30;
        this._m4storage[6] = m20 * n01 + m21 * n11 + m22 * n21 + m23 * n31;
        this._m4storage[10] = m20 * n02 + m21 * n12 + m22 * n22 + m23 * n32;
        this._m4storage[14] = m20 * n03 + m21 * n13 + m22 * n23 + m23 * n33;
        this._m4storage[3] = m30 * n00 + m31 * n10 + m32 * n20 + m33 * n30;
        this._m4storage[7] = m30 * n01 + m31 * n11 + m32 * n21 + m33 * n31;
        this._m4storage[11] = m30 * n02 + m31 * n12 + m32 * n22 + m33 * n32;
        this._m4storage[15] = m30 * n03 + m31 * n13 + m32 * n23 + m33 * n33;
    }

    public Matrix4 multiplied(Matrix4 arg) {
        Matrix4 ret = this.clone();
        ret.multiply(arg);
        return ret;
    }

    public void transposeMultiply(Matrix4 arg) {
        double m00 = this._m4storage[0];
        double m01 = this._m4storage[1];
        double m02 = this._m4storage[2];
        double m03 = this._m4storage[3];
        double m10 = this._m4storage[4];
        double m11 = this._m4storage[5];
        double m12 = this._m4storage[6];
        double m13 = this._m4storage[7];
        double m20 = this._m4storage[8];
        double m21 = this._m4storage[9];
        double m22 = this._m4storage[10];
        double m23 = this._m4storage[11];
        double m30 = this._m4storage[12];
        double m31 = this._m4storage[13];
        double m32 = this._m4storage[14];
        double m33 = this._m4storage[15];
        double[] argStorage = arg._m4storage;
        this._m4storage[0] = m00 * argStorage[0] + m01 * argStorage[1] + m02 * argStorage[2] + m03 * argStorage[3];
        this._m4storage[4] = m00 * argStorage[4] + m01 * argStorage[5] + m02 * argStorage[6] + m03 * argStorage[7];
        this._m4storage[8] = m00 * argStorage[8] + m01 * argStorage[9] + m02 * argStorage[10] + m03 * argStorage[11];
        this._m4storage[12] = m00 * argStorage[12] + m01 * argStorage[13] + m02 * argStorage[14] + m03 * argStorage[15];
        this._m4storage[1] = m10 * argStorage[0] + m11 * argStorage[1] + m12 * argStorage[2] + m13 * argStorage[3];
        this._m4storage[5] = m10 * argStorage[4] + m11 * argStorage[5] + m12 * argStorage[6] + m13 * argStorage[7];
        this._m4storage[9] = m10 * argStorage[8] + m11 * argStorage[9] + m12 * argStorage[10] + m13 * argStorage[11];
        this._m4storage[13] = m10 * argStorage[12] + m11 * argStorage[13] + m12 * argStorage[14] + m13 * argStorage[15];
        this._m4storage[2] = m20 * argStorage[0] + m21 * argStorage[1] + m22 * argStorage[2] + m23 * argStorage[3];
        this._m4storage[6] = m20 * argStorage[4] + m21 * argStorage[5] + m22 * argStorage[6] + m23 * argStorage[7];
        this._m4storage[10] = m20 * argStorage[8] + m21 * argStorage[9] + m22 * argStorage[10] + m23 * argStorage[11];
        this._m4storage[14] = m20 * argStorage[12] + m21 * argStorage[13] + m22 * argStorage[14] + m23 * argStorage[15];
        this._m4storage[3] = m30 * argStorage[0] + m31 * argStorage[1] + m32 * argStorage[2] + m33 * argStorage[3];
        this._m4storage[7] = m30 * argStorage[4] + m31 * argStorage[5] + m32 * argStorage[6] + m33 * argStorage[7];
        this._m4storage[11] = m30 * argStorage[8] + m31 * argStorage[9] + m32 * argStorage[10] + m33 * argStorage[11];
        this._m4storage[15] = m30 * argStorage[12] + m31 * argStorage[13] + m32 * argStorage[14] + m33 * argStorage[15];
    }

    public void multiplyTranspose(Matrix4 arg) {
        double m00 = this._m4storage[0];
        double m01 = this._m4storage[4];
        double m02 = this._m4storage[8];
        double m03 = this._m4storage[12];
        double m10 = this._m4storage[1];
        double m11 = this._m4storage[5];
        double m12 = this._m4storage[9];
        double m13 = this._m4storage[13];
        double m20 = this._m4storage[2];
        double m21 = this._m4storage[6];
        double m22 = this._m4storage[10];
        double m23 = this._m4storage[14];
        double m30 = this._m4storage[3];
        double m31 = this._m4storage[7];
        double m32 = this._m4storage[11];
        double m33 = this._m4storage[15];
        double[] argStorage = arg._m4storage;
        this._m4storage[0] = m00 * argStorage[0] + m01 * argStorage[4] + m02 * argStorage[8] + m03 * argStorage[12];
        this._m4storage[4] = m00 * argStorage[1] + m01 * argStorage[5] + m02 * argStorage[9] + m03 * argStorage[13];
        this._m4storage[8] = m00 * argStorage[2] + m01 * argStorage[6] + m02 * argStorage[10] + m03 * argStorage[14];
        this._m4storage[12] = m00 * argStorage[3] + m01 * argStorage[7] + m02 * argStorage[11] + m03 * argStorage[15];
        this._m4storage[1] = m10 * argStorage[0] + m11 * argStorage[4] + m12 * argStorage[8] + m13 * argStorage[12];
        this._m4storage[5] = m10 * argStorage[1] + m11 * argStorage[5] + m12 * argStorage[9] + m13 * argStorage[13];
        this._m4storage[9] = m10 * argStorage[2] + m11 * argStorage[6] + m12 * argStorage[10] + m13 * argStorage[14];
        this._m4storage[13] = m10 * argStorage[3] + m11 * argStorage[7] + m12 * argStorage[11] + m13 * argStorage[15];
        this._m4storage[2] = m20 * argStorage[0] + m21 * argStorage[4] + m22 * argStorage[8] + m23 * argStorage[12];
        this._m4storage[6] = m20 * argStorage[1] + m21 * argStorage[5] + m22 * argStorage[9] + m23 * argStorage[13];
        this._m4storage[10] = m20 * argStorage[2] + m21 * argStorage[6] + m22 * argStorage[10] + m23 * argStorage[14];
        this._m4storage[14] = m20 * argStorage[3] + m21 * argStorage[7] + m22 * argStorage[11] + m23 * argStorage[15];
        this._m4storage[3] = m30 * argStorage[0] + m31 * argStorage[4] + m32 * argStorage[8] + m33 * argStorage[12];
        this._m4storage[7] = m30 * argStorage[1] + m31 * argStorage[5] + m32 * argStorage[9] + m33 * argStorage[13];
        this._m4storage[11] = m30 * argStorage[2] + m31 * argStorage[6] + m32 * argStorage[10] + m33 * argStorage[14];
        this._m4storage[15] = m30 * argStorage[3] + m31 * argStorage[7] + m32 * argStorage[11] + m33 * argStorage[15];
    }

    public Vector3 rotate3(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        double x_ = this._m4storage[0] * argStorage[0] + this._m4storage[4] * argStorage[1] + this._m4storage[8] * argStorage[2];
        double y_ = this._m4storage[1] * argStorage[0] + this._m4storage[5] * argStorage[1] + this._m4storage[9] * argStorage[2];
        double z_ = this._m4storage[2] * argStorage[0] + this._m4storage[6] * argStorage[1] + this._m4storage[10] * argStorage[2];
        argStorage[0] = x_;
        argStorage[1] = y_;
        argStorage[2] = z_;
        return arg;
    }

    public Vector3 rotated3(Vector3 arg, Vector3 out) {
        if (out == null) {
            out = Vector3.copy(arg);
        } else {
            out.setFrom(arg);
        }
        return this.rotate3(out);
    }

    public Vector3 transform3(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        double x_ = this._m4storage[0] * argStorage[0] + this._m4storage[4] * argStorage[1] + this._m4storage[8] * argStorage[2] + this._m4storage[12];
        double y_ = this._m4storage[1] * argStorage[0] + this._m4storage[5] * argStorage[1] + this._m4storage[9] * argStorage[2] + this._m4storage[13];
        double z_ = this._m4storage[2] * argStorage[0] + this._m4storage[6] * argStorage[1] + this._m4storage[10] * argStorage[2] + this._m4storage[14];
        argStorage[0] = x_;
        argStorage[1] = y_;
        argStorage[2] = z_;
        return arg;
    }

    public Vector3 transformed3(Vector3 arg) {
        return this.transformed3(arg, null);
    }

    public Vector3 transformed3(Vector3 arg, Vector3 out) {
        if (out == null) {
            out = Vector3.copy(arg);
        } else {
            out.setFrom(arg);
        }
        return this.transform3(out);
    }

    public Vector4 transform(Vector4 arg) {
        double[] argStorage = arg._v4storage;
        double x_ = this._m4storage[0] * argStorage[0] + this._m4storage[4] * argStorage[1] + this._m4storage[8] * argStorage[2] + this._m4storage[12] * argStorage[3];
        double y_ = this._m4storage[1] * argStorage[0] + this._m4storage[5] * argStorage[1] + this._m4storage[9] * argStorage[2] + this._m4storage[13] * argStorage[3];
        double z_ = this._m4storage[2] * argStorage[0] + this._m4storage[6] * argStorage[1] + this._m4storage[10] * argStorage[2] + this._m4storage[14] * argStorage[3];
        double w_ = this._m4storage[3] * argStorage[0] + this._m4storage[7] * argStorage[1] + this._m4storage[11] * argStorage[2] + this._m4storage[15] * argStorage[3];
        argStorage[0] = x_;
        argStorage[1] = y_;
        argStorage[2] = z_;
        argStorage[3] = w_;
        return arg;
    }

    public Vector3 perspectiveTransform(Vector3 arg) {
        double[] argStorage = arg._v3storage;
        double x_ = this._m4storage[0] * argStorage[0] + this._m4storage[4] * argStorage[1] + this._m4storage[8] * argStorage[2] + this._m4storage[12];
        double y_ = this._m4storage[1] * argStorage[0] + this._m4storage[5] * argStorage[1] + this._m4storage[9] * argStorage[2] + this._m4storage[13];
        double z_ = this._m4storage[2] * argStorage[0] + this._m4storage[6] * argStorage[1] + this._m4storage[10] * argStorage[2] + this._m4storage[14];
        double w_ = 1.0 / (this._m4storage[3] * argStorage[0] + this._m4storage[7] * argStorage[1] + this._m4storage[11] * argStorage[2] + this._m4storage[15]);
        argStorage[0] = x_ * w_;
        argStorage[1] = y_ * w_;
        argStorage[2] = z_ * w_;
        return arg;
    }

    public Vector4 transformed(Vector4 arg) {
        return this.transformed(arg, null);
    }

    public Vector4 transformed(Vector4 arg, Vector4 out) {
        if (out == null) {
            out = Vector4.copy(arg);
        } else {
            out.setFrom(arg);
        }
        return this.transform(out);
    }

    void copyIntoArray(double[] array, int offset) {
        int i = offset;
        array[i + 15] = this._m4storage[15];
        array[i + 14] = this._m4storage[14];
        array[i + 13] = this._m4storage[13];
        array[i + 12] = this._m4storage[12];
        array[i + 11] = this._m4storage[11];
        array[i + 10] = this._m4storage[10];
        array[i + 9] = this._m4storage[9];
        array[i + 8] = this._m4storage[8];
        array[i + 7] = this._m4storage[7];
        array[i + 6] = this._m4storage[6];
        array[i + 5] = this._m4storage[5];
        array[i + 4] = this._m4storage[4];
        array[i + 3] = this._m4storage[3];
        array[i + 2] = this._m4storage[2];
        array[i + 1] = this._m4storage[1];
        array[i + 0] = this._m4storage[0];
    }

    void copyFromArray(double[] array, int offset) {
        int i = offset;
        this._m4storage[15] = array[i + 15];
        this._m4storage[14] = array[i + 14];
        this._m4storage[13] = array[i + 13];
        this._m4storage[12] = array[i + 12];
        this._m4storage[11] = array[i + 11];
        this._m4storage[10] = array[i + 10];
        this._m4storage[9] = array[i + 9];
        this._m4storage[8] = array[i + 8];
        this._m4storage[7] = array[i + 7];
        this._m4storage[6] = array[i + 6];
        this._m4storage[5] = array[i + 5];
        this._m4storage[4] = array[i + 4];
        this._m4storage[3] = array[i + 3];
        this._m4storage[2] = array[i + 2];
        this._m4storage[1] = array[i + 1];
        this._m4storage[0] = array[i + 0];
    }

    double[] applyToVector3Array(double[] array) {
        return this.applyToVector3Array(array, 0);
    }

    double[] applyToVector3Array(double[] array, int offset) {
        int i = 0;
        int j = offset;
        while (i < array.length) {
            Vector3 v = Vector3.array(array, j);
            v.applyMatrix4(this);
            array[j] = v.getStorage()[0];
            array[j + 1] = v.getStorage()[1];
            array[j + 2] = v.getStorage()[2];
            i += 3;
            j += 3;
        }
        return array;
    }

    public Vector3 getRight() {
        double x = this._m4storage[0];
        double y = this._m4storage[1];
        double z = this._m4storage[2];
        return new Vector3(x, y, z);
    }

    public Vector3 getUp() {
        double x = this._m4storage[4];
        double y = this._m4storage[5];
        double z = this._m4storage[6];
        return new Vector3(x, y, z);
    }

    public Vector3 getForward() {
        double x = this._m4storage[8];
        double y = this._m4storage[9];
        double z = this._m4storage[10];
        return new Vector3(x, y, z);
    }

    public boolean isIdentity() {
        return this._m4storage[0] == 1.0 && this._m4storage[1] == 0.0 && this._m4storage[2] == 0.0 && this._m4storage[3] == 0.0 && this._m4storage[4] == 0.0 && this._m4storage[5] == 1.0 && this._m4storage[6] == 0.0 && this._m4storage[7] == 0.0 && this._m4storage[8] == 0.0 && this._m4storage[9] == 0.0 && this._m4storage[10] == 1.0 && this._m4storage[11] == 0.0 && this._m4storage[12] == 0.0 && this._m4storage[13] == 0.0 && this._m4storage[14] == 0.0 && this._m4storage[15] == 1.0;
    }

    public boolean isZero() {
        return this._m4storage[0] == 0.0 && this._m4storage[1] == 0.0 && this._m4storage[2] == 0.0 && this._m4storage[3] == 0.0 && this._m4storage[4] == 0.0 && this._m4storage[5] == 0.0 && this._m4storage[6] == 0.0 && this._m4storage[7] == 0.0 && this._m4storage[8] == 0.0 && this._m4storage[9] == 0.0 && this._m4storage[10] == 0.0 && this._m4storage[11] == 0.0 && this._m4storage[12] == 0.0 && this._m4storage[13] == 0.0 && this._m4storage[14] == 0.0 && this._m4storage[15] == 0.0;
    }
}

